/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.geometry.internal.util.GeometryList;
import eu.udig.tools.geometry.internal.util.GeometrySet;
import eu.udig.tools.geometry.split.AdaptedPolygon;
import eu.udig.tools.geometry.split.IntersectionStrategy;
import eu.udig.tools.geometry.split.LineBoundaryIntersectionAssociation;
import eu.udig.tools.geometry.split.RingUtil;
import eu.udig.tools.geometry.split.SplitUtil;
import eu.udig.tools.geometry.split.UsefulSplitLine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class UsefulSplitLineBuilder {
    public static final double DEPRECIATE_VALUE = 1.0E-4;
    private static final int OUTSIDE = 1;
    private static final int INSIDE = -1;
    private static final int NONE = 0;
    private final LineString originalSplitLine;
    private List<Geometry> usefulSplitLineSegments = new GeometryList<Geometry>();
    private AdaptedPolygon adaptedPolygon = null;
    private final GeometryFactory geomFactory;
    private Set<LinearRing> nonSplitRings = new GeometrySet<LinearRing>();
    private Geometry resultSplitLine = null;

    public Set<LinearRing> getNonSplitRings() {
        return this.nonSplitRings;
    }

    public LineString getOriginalSplitLine() {
        return this.originalSplitLine;
    }

    public Geometry getResultSplitLine() {
        return this.resultSplitLine;
    }

    private Coordinate[] beginOutside(Coordinate[] modifiedCoords, Geometry extBoundary) {
        int posFirstCoord;
        Polygon polygonArea = this.geomFactory.createPolygon((LinearRing)extBoundary, null);
        int outsidePos = -1;
        int a = 0;
        while (a < modifiedCoords.length) {
            Coordinate point = modifiedCoords[a];
            if (!polygonArea.contains((Geometry)this.geomFactory.createPoint(point))) {
                outsidePos = a;
                break;
            }
            ++a;
        }
        IntersectionStrategy interStrategy = new IntersectionStrategy();
        interStrategy.findFirstIntersection(modifiedCoords, extBoundary);
        Coordinate firstIntersectionCoord = interStrategy.getIntersection();
        int firstIntersectionPosition = interStrategy.getIntersectionPosition();
        if (outsidePos == -1 && !interStrategy.foundIntersection()) {
            return modifiedCoords;
        }
        if (outsidePos > firstIntersectionPosition || outsidePos == -1) {
            modifiedCoords[firstIntersectionPosition] = firstIntersectionCoord;
            posFirstCoord = firstIntersectionPosition;
        } else {
            posFirstCoord = outsidePos;
        }
        modifiedCoords = SplitUtil.createCoordinateArrayWithoutDuplicated(posFirstCoord, modifiedCoords.length - 1, modifiedCoords);
        return modifiedCoords;
    }

    private UsefulSplitLineBuilder(LineString splitLine) {
        this.originalSplitLine = splitLine;
        this.geomFactory = splitLine.getFactory();
    }

    public static final UsefulSplitLineBuilder newInstance(LineString splitLine) {
        UsefulSplitLineBuilder splitWrapper = new UsefulSplitLineBuilder(splitLine);
        return splitWrapper;
    }

    public void build(Polygon polygon) {
        this.adaptedPolygon = new AdaptedPolygon(polygon);
        Geometry usefulSplitLines = this.createUsefulSplitLine(this.originalSplitLine, this.adaptedPolygon);
        assert (usefulSplitLines != null) : "must be at least one split line.";
        this.resultSplitLine = null;
        if (usefulSplitLines instanceof LineString) {
            ArrayList<Geometry> ccwLines = new ArrayList<Geometry>();
            int i = 0;
            while (i < usefulSplitLines.getNumGeometries()) {
                Coordinate[] closed;
                Geometry actual = usefulSplitLines.getGeometryN(i);
                Coordinate[] lineCoord = actual.getCoordinates();
                if (lineCoord.length > 2 && !SplitUtil.isColinear(lineCoord) && !CGAlgorithms.isCCW((Coordinate[])(closed = RingUtil.builRing(lineCoord)))) {
                    actual = this.reverseLineString(closed);
                    assert (CGAlgorithms.isCCW((Coordinate[])actual.getCoordinates())) : "It should be CCW. Actual SplitLine: " + actual + ". Geometry to split: " + polygon;
                    actual = this.reverseLineString(lineCoord);
                }
                ccwLines.add(actual);
                ++i;
            }
            this.resultSplitLine = usefulSplitLines.getFactory().buildGeometry(ccwLines);
        } else {
            this.resultSplitLine = SplitUtil.buildLineUnion(usefulSplitLines);
        }
    }

    private Geometry reverseLineString(Coordinate[] intersectionCoordinates) {
        intersectionCoordinates = CoordinateArrays.copyDeep((Coordinate[])intersectionCoordinates);
        CoordinateArrays.reverse((Coordinate[])intersectionCoordinates);
        return this.geomFactory.createLineString(intersectionCoordinates);
    }

    public Geometry createUsefulSplitLine(LineString splitLine, AdaptedPolygon adaptedPolygon) {
        Coordinate[] clonedSplitLineCoord = this.cloneCoordinate(splitLine.getCoordinates());
        Coordinate[] adaptedSplitLine = this.discardSplitLineSegmentAdaptingPolygon(clonedSplitLineCoord, splitLine, adaptedPolygon);
        UsefulSplitLine useful = new UsefulSplitLine(this.usefulSplitLineSegments, adaptedSplitLine);
        int location = this.whereIsFirstSplitLineCoord(adaptedSplitLine, adaptedPolygon);
        if (location == 1) {
            if ((useful = this.makeUsefulSplitLineFromOutsidePolygon(adaptedPolygon, useful)).getRemaininSplitLine().length > 0 && adaptedPolygon.asPolygon().getNumInteriorRing() > 0) {
                useful = this.makeUsefulSplitLineFromInsidePolygon(adaptedPolygon, useful);
            }
            this.usefulSplitLineSegments = useful.getUsefulSplitLineFragments();
            this.nonSplitRings = this.extractNonSplitHolesFromPolygon(adaptedPolygon, this.usefulSplitLineSegments, this.nonSplitRings);
        } else {
            useful = this.makeUsefulSplitLineFromInsidePolygon(adaptedPolygon, useful);
            this.usefulSplitLineSegments = useful.getUsefulSplitLineFragments();
            adaptedSplitLine = useful.getRemaininSplitLine();
            if (adaptedSplitLine.length > 1) {
                useful = this.makeUsefulSplitLineFromOutsidePolygon(adaptedPolygon, useful);
                this.usefulSplitLineSegments = useful.getUsefulSplitLineFragments();
            }
        }
        if (this.usefulSplitLineSegments.size() > 0) {
            return this.geomFactory.buildGeometry(this.usefulSplitLineSegments);
        }
        return null;
    }

    private Set<LinearRing> extractNonSplitHolesFromPolygon(AdaptedPolygon adapted, List<Geometry> splitLineSegments, Set<LinearRing> nonSplitRings) {
        Polygon polygon = adapted.asPolygon();
        int j = 0;
        while (j < polygon.getNumInteriorRing()) {
            LinearRing holeRing = (LinearRing)polygon.getInteriorRingN(j);
            Polygon polygonRing = this.geomFactory.createPolygon(holeRing, null);
            boolean intersects = false;
            int i = 0;
            while (i < splitLineSegments.size()) {
                Geometry eachLine = splitLineSegments.get(i);
                Geometry intersection = eachLine.intersection((Geometry)holeRing);
                if (eachLine.intersects((Geometry)holeRing) && !(intersection instanceof LineString) && !(intersection instanceof MultiLineString) && !eachLine.touches((Geometry)polygonRing)) {
                    intersects = true;
                    break;
                }
                ++i;
            }
            if (!intersects) {
                nonSplitRings.add(holeRing);
            }
            ++j;
        }
        return nonSplitRings;
    }

    private UsefulSplitLine makeUsefulSplitLineFromInsidePolygon(AdaptedPolygon adapt, UsefulSplitLine usefulSplitLine) {
        Polygon polygon = adapt.asPolygon();
        Coordinate[] splitLineCoords = usefulSplitLine.getRemaininSplitLine();
        Set<LinearRing> sortedRings = this.sortRing(splitLineCoords, polygon);
        for (LinearRing hole : sortedRings) {
            if (splitLineCoords.length > 1) {
                int numIntIntersection = SplitUtil.countIntersectionsFromPosition(0, splitLineCoords = this.beginInsideRing(splitLineCoords, (Geometry)hole), (Geometry)hole);
                if (numIntIntersection >= 2) {
                    usefulSplitLine = this.extractUsefulSplitLine(hole, usefulSplitLine, adapt);
                    splitLineCoords = usefulSplitLine.getRemaininSplitLine();
                    continue;
                }
                this.nonSplitRings.add(hole);
                continue;
            }
            this.nonSplitRings.add(hole);
        }
        List<Geometry> usefulSplitLineSegments = usefulSplitLine.getUsefulSplitLineFragments();
        ArrayList<LinearRing> correctSplitRings = new ArrayList<LinearRing>();
        for (Geometry piece : usefulSplitLineSegments) {
            for (LinearRing hole : this.nonSplitRings) {
                Polygon polygonRing = this.geomFactory.createPolygon(hole, null);
                if (!piece.intersects((Geometry)hole) || piece.touches((Geometry)polygonRing)) continue;
                correctSplitRings.add(hole);
            }
        }
        this.nonSplitRings.removeAll(correctSplitRings);
        usefulSplitLine.setRemaininSplitLine(splitLineCoords);
        usefulSplitLine.setUsefulSplitLineFragments(usefulSplitLineSegments);
        return usefulSplitLine;
    }

    private Set<LinearRing> sortRing(Coordinate[] shortCoords, Polygon polygon) {
        Set<LinearRing> sortedRings = new LinkedHashSet<LinearRing>();
        int i = 0;
        while (i < shortCoords.length - 1) {
            Coordinate[] lineSegment = new Coordinate[]{shortCoords[i], shortCoords[i + 1]};
            LineString segment = this.geomFactory.createLineString(lineSegment);
            List<LinearRing> rings = SplitUtil.addRingThatIntersects(segment, polygon);
            Map<LinearRing, Double> ringsDistance = RingUtil.setRingWithClosestIntersectionDistance(rings, (Geometry)segment, lineSegment);
            sortedRings = this.addClosestRings(sortedRings, ringsDistance);
            ++i;
        }
        return sortedRings;
    }

    private Set<LinearRing> addClosestRings(Set<LinearRing> sortedRings, Map<LinearRing, Double> ringsDistance) {
        if (ringsDistance.size() > 0) {
            Set<Map.Entry<LinearRing, Double>> entrySet = ringsDistance.entrySet();
            Iterator<Map.Entry<LinearRing, Double>> iterator = entrySet.iterator();
            double minDistance = Double.MAX_VALUE;
            LinearRing candidateRing = null;
            while (iterator.hasNext()) {
                Map.Entry<LinearRing, Double> eachEntry = iterator.next();
                Double distance = eachEntry.getValue();
                if (!(Math.abs(distance) < minDistance)) continue;
                minDistance = Math.abs(distance);
                candidateRing = eachEntry.getKey();
            }
            sortedRings.add(candidateRing);
            ringsDistance.remove(candidateRing);
            sortedRings = this.addClosestRings(sortedRings, ringsDistance);
        }
        return sortedRings;
    }

    private Coordinate[] beginInsideRing(Coordinate[] modifiedCoords, Geometry ring) {
        int posFirstCoord;
        Polygon ringArea = this.geomFactory.createPolygon((LinearRing)ring, null);
        int outsidePos = -1;
        int a = 0;
        while (a < modifiedCoords.length) {
            Coordinate point = modifiedCoords[a];
            if (ringArea.contains((Geometry)this.geomFactory.createPoint(point)) || ringArea.getExteriorRing().contains((Geometry)this.geomFactory.createPoint(point))) {
                outsidePos = a;
                break;
            }
            ++a;
        }
        IntersectionStrategy interStrategy = new IntersectionStrategy();
        interStrategy.findFirstIntersection(modifiedCoords, ring);
        Coordinate firstIntersectionCoord = interStrategy.getIntersection();
        int firstIntersectionPosition = interStrategy.getIntersectionPosition();
        if (outsidePos == -1 && !interStrategy.foundIntersection()) {
            return modifiedCoords;
        }
        if (outsidePos > firstIntersectionPosition || outsidePos == -1) {
            modifiedCoords[firstIntersectionPosition] = firstIntersectionCoord;
            posFirstCoord = firstIntersectionPosition;
        } else {
            posFirstCoord = outsidePos;
        }
        modifiedCoords = SplitUtil.createCoordinateArrayWithoutDuplicated(posFirstCoord, modifiedCoords.length - 1, modifiedCoords);
        return modifiedCoords;
    }

    private UsefulSplitLine makeUsefulSplitLineFromOutsidePolygon(AdaptedPolygon adapted, UsefulSplitLine useful) {
        Coordinate[] remainingCoords = useful.getRemaininSplitLine();
        Polygon polygon = adapted.asPolygon();
        LineString extBoundary = polygon.getExteriorRing();
        int numIntIntersection = SplitUtil.countIntersectionsFromPosition(0, remainingCoords = this.beginOutside(remainingCoords, (Geometry)extBoundary), (Geometry)extBoundary);
        if (numIntIntersection >= 2) {
            useful.setRemaininSplitLine(remainingCoords);
            useful = this.extractUsefulSplitLine((LinearRing)extBoundary, useful, adapted);
        }
        return useful;
    }

    private UsefulSplitLine extractUsefulSplitLine(LinearRing pieceOfBoundary, UsefulSplitLine usefulSplitLine, AdaptedPolygon adaptedPolygon) {
        Coordinate[] remainingSplitLine = usefulSplitLine.getRemaininSplitLine();
        List<Geometry> usefulSplitLineFragmentList = usefulSplitLine.getUsefulSplitLineFragments();
        AdaptedPolygon clonedPolygon = (AdaptedPolygon)adaptedPolygon.clone();
        Polygon polygon = clonedPolygon.asPolygon();
        int secondSegmentPosition = 0;
        Coordinate secondIntersection = null;
        LineBoundaryIntersectionAssociation interSegmentList = new LineBoundaryIntersectionAssociation((Coordinate[])remainingSplitLine.clone(), pieceOfBoundary);
        while (interSegmentList.countIntersections() - interSegmentList.getVisitedIntersection() >= 2) {
            interSegmentList.moveNextIntersection();
            int firstSegmentPosition = interSegmentList.getIntersectionSegmentPosition();
            Coordinate firstIntersection = interSegmentList.getIntersection();
            LineString firstRingSegment = interSegmentList.getRingSegment();
            interSegmentList.moveNextIntersection();
            secondSegmentPosition = interSegmentList.getIntersectionSegmentPosition();
            secondIntersection = interSegmentList.getIntersection();
            LineString secondRingSegment = interSegmentList.getRingSegment();
            clonedPolygon.insertVertex(pieceOfBoundary, firstRingSegment, firstIntersection);
            clonedPolygon.insertVertex(pieceOfBoundary, secondRingSegment, secondIntersection);
            polygon = clonedPolygon.asPolygon();
            LineString candidateSplitLineFragment = interSegmentList.buildLineBetweenIntersectionPoints(firstSegmentPosition, firstIntersection, secondSegmentPosition, secondIntersection);
            if (this.segmentsIntersectsPolygon(candidateSplitLineFragment, polygon)) {
                usefulSplitLineFragmentList.add((Geometry)candidateSplitLineFragment);
                adaptedPolygon.insertVertex(pieceOfBoundary, firstRingSegment, firstIntersection);
                adaptedPolygon.insertVertex(pieceOfBoundary, secondRingSegment, secondIntersection);
            }
            interSegmentList.moveBackIntersection();
        }
        remainingSplitLine = this.removeProcessedSegment(interSegmentList, secondSegmentPosition, secondIntersection, remainingSplitLine);
        usefulSplitLine.setUsefulSplitLineFragments(usefulSplitLineFragmentList);
        usefulSplitLine.setRemaininSplitLine(remainingSplitLine);
        return usefulSplitLine;
    }

    private Coordinate[] removeProcessedSegment(LineBoundaryIntersectionAssociation interSegmentList, int segmentPosition, Coordinate intersection, Coordinate[] remainingSplitLineCoords) {
        LineString splitLineFragment = interSegmentList.getSplitLineSegment(segmentPosition);
        remainingSplitLineCoords = this.cutRemaininigSplitLine(splitLineFragment, remainingSplitLineCoords);
        if (remainingSplitLineCoords.length > 0) {
            Coordinate[] reducedSplitLineFragment = SplitUtil.replaceCoordinate(0, intersection, splitLineFragment.getCoordinates());
            reducedSplitLineFragment = SplitUtil.createCoordinateArrayWithoutDuplicated(0, reducedSplitLineFragment.length - 1, reducedSplitLineFragment);
            remainingSplitLineCoords = SplitUtil.mergeCoordinate(reducedSplitLineFragment, remainingSplitLineCoords);
        }
        return remainingSplitLineCoords;
    }

    private Coordinate[] cutRemaininigSplitLine(LineString splitLineFragment, Coordinate[] remainingSplitLine) {
        int lastCoord = splitLineFragment.getNumPoints() - 1;
        int lastCoordPosition = CoordinateArrays.indexOf((Coordinate)splitLineFragment.getCoordinateN(lastCoord), (Coordinate[])remainingSplitLine);
        Coordinate[] newRemainingSplitLine = lastCoordPosition < remainingSplitLine.length - 1 ? SplitUtil.createCoordinateArrayWithoutDuplicated(lastCoordPosition, remainingSplitLine.length - 1, remainingSplitLine) : new Coordinate[]{};
        return newRemainingSplitLine;
    }

    private boolean segmentsIntersectsPolygon(LineString usefulSegment, Polygon polygon) {
        Geometry intersection = polygon.intersection((Geometry)usefulSegment);
        return SplitUtil.containsLineString(intersection);
    }

    private int whereIsFirstSplitLineCoord(Coordinate[] shortCoords, AdaptedPolygon adaptedPolygon) {
        Polygon polygon = adaptedPolygon.asPolygon();
        Polygon polygonArea = this.geomFactory.createPolygon((LinearRing)polygon.getExteriorRing(), null);
        int i = 0;
        while (i < shortCoords.length - 2) {
            double distance;
            if (!polygonArea.contains((Geometry)this.geomFactory.createPoint(shortCoords[i]))) {
                return 1;
            }
            int j = 0;
            while (j < polygon.getNumInteriorRing()) {
                Polygon ringArea = this.geomFactory.createPolygon((LinearRing)polygon.getInteriorRingN(j), null);
                if (ringArea.contains((Geometry)this.geomFactory.createPoint(shortCoords[i]))) {
                    return -1;
                }
                ++j;
            }
            Coordinate[] segCoords = new Coordinate[]{shortCoords[i], shortCoords[i + 1]};
            LineString segment = this.geomFactory.createLineString(segCoords);
            double minExtDistance = Double.MAX_VALUE;
            Geometry intersection = polygon.getExteriorRing().intersection((Geometry)segment);
            int j2 = 0;
            while (j2 < intersection.getNumGeometries()) {
                Coordinate pointToTest = intersection.getGeometryN(j2).getCoordinate();
                distance = SplitUtil.calculateDistanceFromFirst(pointToTest, segCoords[0], segCoords[1]);
                if (Math.abs(distance) < minExtDistance) {
                    minExtDistance = Math.abs(distance);
                }
                ++j2;
            }
            double minRingDistance = Double.MAX_VALUE;
            int j3 = 0;
            while (j3 < polygon.getNumInteriorRing()) {
                LineString ring = polygon.getInteriorRingN(j3);
                intersection = ring.intersection((Geometry)segment);
                int h = 0;
                while (h < intersection.getNumGeometries()) {
                    Coordinate pointToTest = intersection.getGeometryN(h).getCoordinate();
                    distance = SplitUtil.calculateDistanceFromFirst(pointToTest, segCoords[0], segCoords[1]);
                    if (Math.abs(distance) < minRingDistance) {
                        minRingDistance = Math.abs(distance);
                    }
                    ++h;
                }
                ++j3;
            }
            if (minExtDistance < minRingDistance) {
                return 1;
            }
            if (minRingDistance < minExtDistance) {
                return -1;
            }
            ++i;
        }
        if (!polygonArea.contains((Geometry)this.geomFactory.createPoint(shortCoords[shortCoords.length - 1]))) {
            return 1;
        }
        int j = 0;
        while (j < polygon.getNumInteriorRing()) {
            Polygon ringArea = this.geomFactory.createPolygon((LinearRing)polygon.getInteriorRingN(j), null);
            if (ringArea.contains((Geometry)this.geomFactory.createPoint(shortCoords[shortCoords.length - 1]))) {
                return -1;
            }
            ++j;
        }
        return 0;
    }

    private Coordinate[] cloneCoordinate(Coordinate[] coords) {
        Coordinate[] cloneCoordinates = new Coordinate[coords.length];
        int i = 0;
        while (i < coords.length) {
            cloneCoordinates[i] = (Coordinate)coords[i].clone();
            ++i;
        }
        return cloneCoordinates;
    }

    private Coordinate[] discardSplitLineSegmentAdaptingPolygon(Coordinate[] lineCoords, LineString splitLine, AdaptedPolygon adaptedPolygon) {
        Polygon polygon = adaptedPolygon.asPolygon();
        int posFirstCoord = 0;
        int posLastCoord = lineCoords.length - 1;
        Geometry boundary = polygon.getBoundary();
        int firstOutsidePosition = SplitUtil.findPositionOfFirstCoordinateOutside(splitLine, (Geometry)polygon);
        IntersectionStrategy interStrategy = new IntersectionStrategy();
        interStrategy.findFirstIntersection(lineCoords, boundary);
        Coordinate firstIntersectionCoord = interStrategy.getIntersection();
        int firstIntersectionPosition = interStrategy.getIntersectionPosition();
        if (firstOutsidePosition > firstIntersectionPosition || firstOutsidePosition == -1) {
            lineCoords[firstIntersectionPosition] = firstIntersectionCoord;
            posFirstCoord = firstIntersectionPosition;
            adaptedPolygon = this.insertCoordinateIntoPolygon(firstIntersectionCoord, adaptedPolygon, splitLine);
        } else {
            posFirstCoord = firstOutsidePosition;
        }
        int lastOutsidePosition = SplitUtil.findLastCoordinateOutside(splitLine, (Geometry)polygon);
        interStrategy.findLastIntersection(lineCoords, boundary);
        Coordinate lastCoord = interStrategy.getIntersection();
        int lastPosition = interStrategy.getIntersectionPosition();
        if (lastOutsidePosition < lastPosition || lastOutsidePosition == -1) {
            lineCoords[lastPosition] = lastCoord;
            posLastCoord = lastPosition;
            adaptedPolygon = this.insertCoordinateIntoPolygon(lastCoord, adaptedPolygon, splitLine);
        } else {
            posLastCoord = lastOutsidePosition;
        }
        Coordinate[] newCoords = SplitUtil.createCoordinateArrayWithoutDuplicated(posFirstCoord, posLastCoord, lineCoords);
        return newCoords;
    }

    private AdaptedPolygon insertCoordinateIntoPolygon(Coordinate coorToInsert, AdaptedPolygon adaptedPolygon1, LineString splitLine) {
        Coordinate[] shellCoords;
        Polygon adaptedPolygon = adaptedPolygon1.asPolygon();
        Coordinate[] boundaryCoord = adaptedPolygon.getExteriorRing().getCoordinates();
        int positionToInsert = -1;
        int positionToInsertOnRing = -1;
        int nRing = -1;
        int i = 0;
        while (i < boundaryCoord.length - 1) {
            Coordinate start = boundaryCoord[i];
            Coordinate end = boundaryCoord[i + 1];
            if (this.isSameTangent(start, coorToInsert, end) && this.isPointContainedInSegment(start, coorToInsert, end)) {
                assert (positionToInsert == -1) : "position to insert modified twice.";
                positionToInsert = i;
                break;
            }
            ++i;
        }
        ArrayList<Coordinate> updatedShell = new ArrayList<Coordinate>();
        if (positionToInsert != -1) {
            int i2 = 0;
            while (i2 < boundaryCoord.length) {
                updatedShell.add(boundaryCoord[i2]);
                if (i2 == positionToInsert) {
                    updatedShell.add(coorToInsert);
                }
                ++i2;
            }
            shellCoords = updatedShell.toArray(new Coordinate[updatedShell.size()]);
        } else {
            shellCoords = boundaryCoord;
        }
        GeometryFactory gf = adaptedPolygon.getFactory();
        LinearRing[] rings = null;
        if (adaptedPolygon.getNumInteriorRing() != 0) {
            int i3;
            rings = new LinearRing[adaptedPolygon.getNumInteriorRing()];
            int rIndex = 0;
            while (rIndex < adaptedPolygon.getNumInteriorRing()) {
                rings[rIndex] = (LinearRing)adaptedPolygon.getInteriorRingN(rIndex);
                Coordinate[] ringCoords = rings[rIndex].getCoordinates();
                i3 = 0;
                while (i3 < ringCoords.length - 1 && positionToInsertOnRing == -1) {
                    Coordinate start = ringCoords[i3];
                    Coordinate end = ringCoords[i3 + 1];
                    if (this.isSameTangent(start, coorToInsert, end) && this.isPointContainedInSegment(start, coorToInsert, end)) {
                        assert (positionToInsertOnRing == -1) : "position to insert modified twice.";
                        positionToInsertOnRing = i3;
                        nRing = rIndex;
                        break;
                    }
                    ++i3;
                }
                ++rIndex;
            }
            if (positionToInsertOnRing != -1) {
                LinearRing modifiedRing;
                assert (nRing != -1) : "there should be a ring index.";
                Coordinate[] originalRing = rings[nRing].getCoordinates();
                ArrayList<Coordinate> updatedHole = new ArrayList<Coordinate>();
                i3 = 0;
                while (i3 < originalRing.length) {
                    updatedHole.add(originalRing[i3]);
                    if (i3 == positionToInsertOnRing) {
                        updatedHole.add(coorToInsert);
                    }
                    ++i3;
                }
                Coordinate[] modifiedRingCoords = updatedHole.toArray(new Coordinate[updatedHole.size()]);
                rings[nRing] = modifiedRing = gf.createLinearRing(modifiedRingCoords);
            }
        }
        assert (shellCoords != null) : "there should be at least shell coordinates to build a polygon.";
        LinearRing shellRing = gf.createLinearRing(shellCoords);
        Polygon newPolygon = gf.createPolygon(shellRing, rings);
        AdaptedPolygon rebuildedPolygon = new AdaptedPolygon(newPolygon);
        return rebuildedPolygon;
    }

    private boolean isPointContainedInSegment(Coordinate start, Coordinate point, Coordinate end) {
        return start.x > point.x && point.x > end.x ? start.y > point.y && point.y > end.y || start.y < point.y && point.y < end.y : start.x < point.x && point.x < end.x && (start.y > point.y && point.y > end.y || start.y < point.y && point.y < end.y);
    }

    private boolean isSameTangent(Coordinate start, Coordinate coordToTest, Coordinate end) {
        double firstX = Math.abs(start.x - coordToTest.x);
        double secondX = Math.abs(coordToTest.x - end.x);
        if (firstX < 1.0E-4 && secondX < 1.0E-4) {
            return true;
        }
        double firstY = Math.abs(start.y - coordToTest.y);
        double secondY = Math.abs(coordToTest.y - end.y);
        if (firstY < 1.0E-4 && secondY < 1.0E-4) {
            return true;
        }
        Coordinate[] newCoor = new Coordinate[]{start, coordToTest};
        double dx1 = newCoor[1].x - newCoor[0].x;
        double dy1 = newCoor[1].y - newCoor[0].y;
        double tangent = dy1 / dx1;
        newCoor = new Coordinate[]{coordToTest, end};
        double dy2 = newCoor[1].y - newCoor[0].y;
        double dx2 = newCoor[1].x - newCoor[0].x;
        double tangentToCompare = dy2 / dx2;
        double diff = Math.abs(tangent - tangentToCompare);
        return diff < 1.0E-4;
    }

    public AdaptedPolygon getAdaptedPolygon() {
        return this.adaptedPolygon;
    }
}

