/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import eu.udig.tools.geometry.split.SplitEdge;
import java.util.ArrayList;
import java.util.List;

class SplitEdgeStar
extends DirectedEdgeStar {
    SplitEdgeStar() {
    }

    public void insert(DirectedEdge de) {
        assert (de != null) : "edge can not be null";
        this.insertEdgeEnd((EdgeEnd)de, de);
    }

    public void insert(EdgeEnd ee) {
        this.insert((DirectedEdge)ee);
    }

    public void remove(DirectedEdge edge) {
        assert (edge != null) : "edge can not be null";
        int degree = this.getDegree();
        Object removed = this.edgeMap.remove(edge);
        int afterDegree = this.getDegree();
        assert (afterDegree == degree - 1);
        if (edge != removed) {
            throw new IllegalArgumentException("Tried to remove an edge not registered in this edge star: " + edge);
        }
        this.edgeList = null;
    }

    private List<DirectedEdge> getOutgoingEdges() {
        Coordinate nodeCoord = this.getCoordinate();
        List edges = this.getEdges();
        ArrayList<DirectedEdge> outgoingEdges = new ArrayList<DirectedEdge>(edges.size());
        for (DirectedEdge edge : edges) {
            if (!nodeCoord.equals2D(edge.getCoordinate())) {
                edge = edge.getSym();
            }
            assert (nodeCoord.equals2D(edge.getCoordinate()));
            outgoingEdges.add(edge);
        }
        return outgoingEdges;
    }

    public DirectedEdge findClosestEdgeInDirection(DirectedEdge edge, int searchDirection) {
        assert (edge != null) : "edge can not be null";
        assert (this.getDegree() >= 2) : "there must be at least two edges in the edge star :" + ((SplitEdge)edge.getEdge()).toString();
        Coordinate nodeCoord = this.getCoordinate();
        assert (nodeCoord.equals2D(edge.getCoordinate()));
        double acutestAngle = Double.MAX_VALUE;
        DirectedEdge acutest = null;
        DirectedEdge adjacentEdge2 = null;
        Coordinate tip1 = edge.getDirectedCoordinate();
        Coordinate tail = nodeCoord;
        List<DirectedEdge> outgoingEdges = this.getOutgoingEdges();
        for (DirectedEdge adjacentEdge2 : outgoingEdges) {
            Coordinate tip2;
            double angle;
            if (adjacentEdge2 == edge || !((angle = this.computeAngleInDirection(tip1, tail, tip2 = adjacentEdge2.getDirectedCoordinate(), searchDirection)) < acutestAngle)) continue;
            acutestAngle = angle;
            acutest = adjacentEdge2;
        }
        return acutest;
    }

    public double computeAngleInDirection(Coordinate tip1, Coordinate tail, Coordinate tip2, int direction) {
        int orientation = CGAlgorithms.computeOrientation((Coordinate)tail, (Coordinate)tip1, (Coordinate)tip2);
        double angle = Angle.angleBetween((Coordinate)tip1, (Coordinate)tail, (Coordinate)tip2);
        if (orientation != direction) {
            angle = Math.PI * 2 - angle;
        }
        return angle;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SplitEdgeStar[degree: ");
        sb.append(this.getDegree()).append(", edges: ");
        for (DirectedEdge de : this.getEdges()) {
            sb.append("DirectedEdge[");
            sb.append(de.getEdge()).append(" ");
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

