/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;

final class SplitEdge
extends Edge {
    private int countVisited = 0;

    public static SplitEdge newInstance(Coordinate firstCoord, Coordinate secondCoord, int onLoc, int leftLoc, int rightLoc) {
        Label label = new Label(onLoc, leftLoc, rightLoc);
        Coordinate[] edgeCoord = new Coordinate[]{firstCoord, secondCoord};
        SplitEdge edge = new SplitEdge(edgeCoord, label);
        return edge;
    }

    public static SplitEdge newInstance(Coordinate[] coords, int onLoc, int leftLoc, int rightLoc) {
        Label label = new Label(onLoc, leftLoc, rightLoc);
        SplitEdge splitEdge = new SplitEdge(coords, label);
        return splitEdge;
    }

    private SplitEdge(Coordinate[] pts, Label label) {
        super(pts, label);
    }

    public boolean isVisited() {
        return this.countVisited > 0;
    }

    public boolean isTwiceVisited() {
        return this.countVisited >= 2;
    }

    public void countVisited() {
        ++this.countVisited;
    }

    private int[] getLabelLocations() {
        int[] locations = new int[3];
        Label label = this.getLabel();
        locations[0] = label.getLocation(0, 0);
        locations[1] = label.getLocation(0, 1);
        locations[2] = label.getLocation(0, 2);
        return locations;
    }

    public boolean isShellEdge() {
        int[] loc = this.getLabelLocations();
        return loc[1] == 2 && loc[2] == 0;
    }

    public boolean isHoleEdge() {
        int[] loc = this.getLabelLocations();
        return loc[1] == 0 && loc[2] == 2;
    }

    public boolean isIntersectionEdge() {
        int[] loc = this.getLabelLocations();
        return loc[1] == 0 && loc[2] == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Edge[label=");
        sb.append(this.getLabel()).append(", ");
        Coordinate[] coords = this.getCoordinates();
        int i = 0;
        while (i < coords.length) {
            sb.append(coords[i].x).append(",").append(coords[i].y).append(" ");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equalsCoordinates(Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge e = (Edge)o;
        if (this.getCoordinates().length != e.getCoordinates().length) {
            return false;
        }
        int i = 0;
        while (i < this.getCoordinates().length) {
            boolean found = false;
            int j = 0;
            while (j < e.getCoordinates().length) {
                if (this.getCoordinate(i).equals2D(e.getCoordinate(j))) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

