/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import eu.udig.tools.geometry.internal.util.GeometryList;
import eu.udig.tools.geometry.split.SplitUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class RingUtil {
    private RingUtil() {
    }

    public static List<LineString> ringToSegmentList(LinearRing ring) {
        GeometryFactory gf = ring.getFactory();
        GeometryList<LineString> segmentList = new GeometryList<LineString>();
        Coordinate[] ringCoords = ring.getCoordinates();
        int i = 0;
        while (i < ringCoords.length - 1) {
            LineString segment = gf.createLineString(new Coordinate[]{ringCoords[i], ringCoords[i + 1]});
            segmentList.add(segment);
            ++i;
        }
        return segmentList;
    }

    public static LinearRing segmentListToRing(List<LineString> adaptedRingSegmentList) {
        LinkedList<Coordinate> coordList = new LinkedList<Coordinate>();
        for (LineString line : adaptedRingSegmentList) {
            Coordinate[] lineCoords = line.getCoordinates();
            int i = 0;
            while (i < lineCoords.length) {
                if (!coordList.contains(lineCoords[i])) {
                    coordList.add(lineCoords[i]);
                }
                ++i;
            }
        }
        coordList.add((Coordinate)coordList.get(0));
        Coordinate[] linearRingCoords = coordList.toArray(new Coordinate[coordList.size()]);
        GeometryFactory factory = adaptedRingSegmentList.get(0).getFactory();
        LinearRing ring = factory.createLinearRing(linearRingCoords);
        return ring;
    }

    public static Coordinate[] builRing(Coordinate[] coordinates) {
        int length = coordinates.length;
        Coordinate[] closed = Arrays.copyOf(coordinates, length + 1);
        closed[length] = coordinates[0];
        return closed;
    }

    public static Map<LinearRing, Double> setRingWithClosestIntersectionDistance(List<LinearRing> rings, Geometry segment, Coordinate[] lineSegment) {
        HashMap<LinearRing, Double> ringsDistance = new HashMap<LinearRing, Double>();
        for (LinearRing eachRing : rings) {
            double distance;
            Geometry intersection = eachRing.intersection(segment);
            int numGeometries = intersection.getNumGeometries();
            if (numGeometries == 1) {
                Coordinate intersectionPoint = intersection.getCoordinate();
                distance = SplitUtil.calculateDistanceFromFirst(intersectionPoint, lineSegment[0], lineSegment[1]);
                ringsDistance.put(eachRing, Math.abs(distance));
                continue;
            }
            if (numGeometries <= 1) continue;
            double minDistance = Double.MAX_VALUE;
            int j = 0;
            while (j < intersection.getNumGeometries()) {
                Coordinate curPoint = intersection.getGeometryN(j).getCoordinate();
                distance = SplitUtil.calculateDistanceFromFirst(curPoint, lineSegment[0], lineSegment[1]);
                if (Math.abs(distance) < minDistance) {
                    minDistance = Math.abs(distance);
                }
                ++j;
            }
            ringsDistance.put(eachRing, Math.abs(minDistance));
        }
        return ringsDistance;
    }
}

