/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geomgraph.NodeFactory;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import eu.udig.tools.geometry.split.SplitEdge;
import eu.udig.tools.geometry.split.SplitGraphNodeFactory;
import java.util.ArrayList;
import java.util.List;

final class Graph
extends PlanarGraph {
    private static final NodeFactory NODE_FACTORY = new SplitGraphNodeFactory();

    public Graph() {
        super(NODE_FACTORY);
    }

    public void addEdges(List<Geometry> nodedHolesList, int boundary, int interior, int exterior) {
        for (Geometry geom : nodedHolesList) {
            this.addEdges(geom, boundary, interior, exterior);
        }
    }

    private void addEdges(Geometry linearGeom, int onLoc, int leftLoc, int rightLoc) {
        int nParts = linearGeom.getNumGeometries();
        ArrayList<SplitEdge> edges = new ArrayList<SplitEdge>();
        int i = 0;
        while (i < nParts) {
            SplitEdge edge = this.createEdge(linearGeom, i, onLoc, leftLoc, rightLoc);
            edges.add(edge);
            ++i;
        }
        super.addEdges(edges);
    }

    private SplitEdge createEdge(Geometry linearGeom, int i, int onLoc, int leftLoc, int rightLoc) {
        Geometry currGeom = linearGeom.getGeometryN(i);
        Coordinate[] coords = currGeom.getCoordinates();
        SplitEdge edge = SplitEdge.newInstance(coords, onLoc, leftLoc, rightLoc);
        return edge;
    }

    public void addEdge(SplitEdge edge) {
        ArrayList<SplitEdge> edges = new ArrayList<SplitEdge>();
        edges.add(edge);
        super.addEdges(edges);
    }
}

