/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.merge;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MergeStrategy {
    private Geometry mergeGeometry = null;

    public MergeStrategy(Geometry mergeGeometry) {
        if (mergeGeometry == null) {
            throw new NullPointerException();
        }
        this.mergeGeometry = mergeGeometry;
    }

    public static Geometry mergeOp(Geometry mergeGeometry, Geometry withGeometry) {
        MergeStrategy strategy = new MergeStrategy(mergeGeometry);
        Geometry merged = strategy.merge(withGeometry);
        return merged;
    }

    public Geometry merge(Geometry withGeometry) {
        if (withGeometry == null) {
            throw new NullPointerException();
        }
        Geometry mergeResult = null;
        mergeResult = this.mergeGeometry.getClass().equals(MultiLineString.class) || this.mergeGeometry.getClass().equals(LineString.class) ? this.unionLines(withGeometry) : this.mergeGeometry.union(withGeometry);
        return mergeResult;
    }

    private Geometry unionLines(Geometry withGeometry) {
        Geometry result = null;
        LineMerger merger = new LineMerger();
        merger.add(this.mergeGeometry);
        merger.add(withGeometry);
        Collection mergedLineStrings = merger.getMergedLineStrings();
        Iterator it = mergedLineStrings.iterator();
        if (mergedLineStrings.size() == 1) {
            result = (Geometry)it.next();
        } else {
            GeometryFactory gf = this.mergeGeometry.getFactory();
            ArrayList lineList = new ArrayList(mergedLineStrings);
            LineString[] lineStrings = lineList.toArray(new LineString[mergedLineStrings.size()]);
            result = gf.createMultiLineString(lineStrings);
        }
        return result;
    }
}

