/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.feature.util;

import eu.udig.tools.feature.util.GeoToolsUtils;
import eu.udig.tools.internal.i18n.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.Unit;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.osgi.framework.Bundle;

public final class UnitList {
    private static UnitList THIS = null;
    private static Map<Unit<?>, String> LENGTH_UNITS = new HashMap();
    private static final String[][] DEFAULT_LENGTH_UNITS = new String[][]{{"km", Messages.GeoToolsUtils_unitName_kilometers}, {"pixel", Messages.GeoToolsUtils_unitName_pixels}, {"ft", Messages.GeoToolsUtils_unitName_feet}, {"yd", Messages.GeoToolsUtils_unitName_yards}, {"in", Messages.GeoToolsUtils_unitName_inches}, {"cm", Messages.GeoToolsUtils_unitName_centimeters}, {"m", Messages.GeoToolsUtils_unitName_meters}, {"\u00b0", Messages.GeoToolsUtils_unitName_degrees}};
    public static final Unit<?> PIXEL_UNITS = Unit.valueOf((CharSequence)"pixel");
    protected static final Logger LOGGER = Logger.getLogger(UnitList.class.getName());

    private UnitList() {
    }

    public static synchronized UnitList getInstance() {
        if (THIS != null) {
            return THIS;
        }
        THIS = new UnitList();
        UnitList.popultate();
        return THIS;
    }

    private static void popultate() {
        block19: {
            BufferedReader reader = null;
            try {
                try {
                    int i = 0;
                    while (i < DEFAULT_LENGTH_UNITS.length) {
                        Unit unit = Unit.valueOf((CharSequence)DEFAULT_LENGTH_UNITS[i][0]);
                        String unitName = DEFAULT_LENGTH_UNITS[i][1];
                        LENGTH_UNITS.put(unit, unitName);
                        ++i;
                    }
                    File crsFile = UnitList.getCRSfile();
                    String line = "";
                    String totalReadedCrs = "";
                    LinkedList<String> crsList = new LinkedList<String>();
                    reader = new BufferedReader(new FileReader(crsFile.getAbsolutePath()));
                    while ((line = reader.readLine()) != null && !line.trim().equals("")) {
                        totalReadedCrs = line.substring(0, line.indexOf("|"));
                        line = line.substring(line.indexOf("|") + 1);
                        while (line.contains("|")) {
                            crsList.add(line.substring(0, line.indexOf("|")));
                            line = line.substring(line.indexOf("|") + 1);
                        }
                        crsList.add(line);
                    }
                    if (crsList.size() == 0) {
                        UnitList.fillcommonLengthUnits(crsFile);
                    } else {
                        int totalCount = UnitList.getTotalCrsCount();
                        if (totalCount != Integer.parseInt(totalReadedCrs)) {
                            UnitList.fillcommonLengthUnits(crsFile);
                        } else {
                            UnitList.loadFromProperties(crsList);
                        }
                    }
                    LENGTH_UNITS = Collections.unmodifiableMap(LENGTH_UNITS);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                    if (reader == null) break block19;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public synchronized Set<Unit<?>> getCommonLengthUnits() throws Exception {
        if (LENGTH_UNITS != null) {
            return LENGTH_UNITS.keySet();
        }
        return Collections.emptySet();
    }

    private static void loadFromProperties(List<String> crsList) throws Exception {
        for (String crsUnit : crsList) {
            BaseUnit unit = new BaseUnit(crsUnit);
            if (LENGTH_UNITS.containsKey(unit)) continue;
            LENGTH_UNITS.put((Unit<?>)unit, unit.toString());
        }
    }

    private static int getTotalCrsCount() {
        int crsCount = 0;
        for (Object object : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)object;
            try {
                Set codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
                crsCount += codes.size();
            }
            catch (Exception e) {
                LOGGER.warning("exception" + e.getMessage());
            }
        }
        return crsCount;
    }

    private static File getCRSfile() throws IOException {
        Bundle bundle = Platform.getBundle((String)"eu.udig.tools");
        URL internal = bundle.getEntry("crs.properties");
        URL fileUrl = FileLocator.toFileURL((URL)internal);
        String externalForm = fileUrl.toExternalForm();
        String path = externalForm.replaceFirst("file:", "");
        return new File(path);
    }

    private static void fillcommonLengthUnits(File crsFile) throws IOException {
        int crsCount = 0;
        StringBuilder crsSequence = new StringBuilder();
        for (Object object : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)object;
            try {
                Set codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
                for (String code : codes) {
                    ++crsCount;
                    try {
                        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem(code);
                        Unit<?> unit = GeoToolsUtils.getDefaultCRSUnit(crs);
                        if (LENGTH_UNITS.containsKey(unit)) continue;
                        LENGTH_UNITS.put(unit, unit.toString());
                        unit.getStandardUnit();
                        unit.toStandardUnit();
                        crsSequence.append("|" + unit.toString());
                    }
                    catch (Exception e) {
                        LOGGER.warning("exception" + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warning("exception" + e.getMessage());
            }
        }
        String finalcrsSequence = String.valueOf(crsCount) + crsSequence.toString();
        BufferedWriter writer = new BufferedWriter(new FileWriter(crsFile.getAbsolutePath()));
        writer.write(finalcrsSequence);
        writer.close();
    }

    public synchronized String getUnitName(Unit<?> unit) {
        assert (unit != null);
        String unitName = LENGTH_UNITS.get(unit);
        assert (unitName != null) : "unit name cannot be null";
        return unitName;
    }
}

