/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.feature.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import eu.udig.tools.feature.util.CoordSeqFactoryPreservingCoordinateSequenceTransformer;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import java.util.HashMap;
import javax.measure.unit.Unit;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.resources.CRSUtilities;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class GeoToolsUtils {
    private GeoToolsUtils() {
    }

    public static void copyAttributes(SimpleFeature source, SimpleFeature target) throws IllegalAttributeException {
        HashMap<String, Class> sourceTypes = new HashMap<String, Class>();
        for (AttributeDescriptor att : source.getFeatureType().getAttributeDescriptors()) {
            sourceTypes.put(att.getLocalName(), att.getType().getBinding());
        }
        for (AttributeDescriptor att : target.getFeatureType().getAttributeDescriptors()) {
            String name = att.getLocalName();
            Class sourceBinding = (Class)sourceTypes.get(name);
            if (sourceBinding == null || sourceBinding != att.getType().getBinding()) continue;
            Object attribute = source.getAttribute(name);
            target.setAttribute(name, attribute);
        }
    }

    public static Unit<?> getDefaultCRSUnit(CoordinateReferenceSystem crs) {
        assert (crs != null);
        CoordinateSystem coordinateSystem = crs.getCoordinateSystem();
        Unit unit = CRSUtilities.getUnit((CoordinateSystem)coordinateSystem);
        if (unit == null) {
            CoordinateSystemAxis axis = coordinateSystem.getAxis(0);
            unit = axis.getUnit();
        }
        return unit;
    }

    public static GeometryCoordinateSequenceTransformer getTransformer(GeometryFactory gFactory, CoordinateReferenceSystem geomCrs, CoordinateReferenceSystem reprojectCrs) throws OperationNotFoundException {
        MathTransform mathTransform;
        assert (geomCrs != null);
        assert (reprojectCrs != null);
        CoordinateSequenceFactory csFactory = gFactory.getCoordinateSequenceFactory();
        CoordSeqFactoryPreservingCoordinateSequenceTransformer csTransformer = new CoordSeqFactoryPreservingCoordinateSequenceTransformer(csFactory);
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer((CoordinateSequenceTransformer)csTransformer);
        try {
            mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)geomCrs, (CoordinateReferenceSystem)reprojectCrs, (boolean)true);
        }
        catch (FactoryException e) {
            throw new OperationNotFoundException(e.getMessage());
        }
        transformer.setMathTransform(mathTransform);
        return transformer;
    }

    public static Geometry reproject(Geometry geom, CoordinateReferenceSystem geomCrs, CoordinateReferenceSystem reprojectCrs) throws OperationNotFoundException, TransformException {
        assert (geom != null) : "geom cannot be null";
        assert (geomCrs != null) : "geomCrs cannot be null";
        assert (reprojectCrs != null) : "reprojectCrs cannot be null";
        if (geomCrs.equals(reprojectCrs)) {
            return geom;
        }
        if (CRS.equalsIgnoreMetadata((Object)geomCrs, (Object)reprojectCrs)) {
            return geom;
        }
        GeometryFactory gFactory = geom.getFactory();
        GeometryCoordinateSequenceTransformer transformer = GeoToolsUtils.getTransformer(gFactory, geomCrs, reprojectCrs);
        Geometry geometry = transformer.transform(geom);
        return geometry;
    }

    public static int getDimensionOf(SimpleFeatureType featureType) {
        GeometryDescriptor geomAttr = featureType.getGeometryDescriptor();
        Class geomClass = geomAttr.getType().getBinding();
        int dim = GeometryUtil.getDimension(geomClass);
        return dim;
    }

    public static LineSegment reproject(LineSegment segment, CoordinateReferenceSystem segmentCrs, CoordinateReferenceSystem reprojectCrs) {
        MathTransform mathTransform;
        assert (segment != null);
        assert (segmentCrs != null);
        assert (reprojectCrs != null);
        if (segmentCrs.equals(reprojectCrs)) {
            return segment;
        }
        if (CRS.equalsIgnoreMetadata((Object)segmentCrs, (Object)reprojectCrs)) {
            return segment;
        }
        try {
            mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)segmentCrs, (CoordinateReferenceSystem)reprojectCrs, (boolean)true);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e.getMessage());
        }
        double[] src = new double[]{segment.p0.x, segment.p0.y, segment.p1.x, segment.p1.y};
        double[] dst = new double[4];
        try {
            mathTransform.transform(src, 0, dst, 0, 2);
        }
        catch (TransformException e) {
            throw new RuntimeException(e.getMessage());
        }
        Coordinate p0 = new Coordinate(dst[0], dst[1]);
        Coordinate p1 = new Coordinate(dst[2], dst[3]);
        LineSegment lineSegment = new LineSegment(p0, p1);
        return lineSegment;
    }
}

