/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.feature.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import eu.udig.tools.internal.i18n.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class FeatureUtil {
    private FeatureUtil() {
    }

    public static SimpleFeature copyAttributes(SimpleFeature source, SimpleFeature target) throws IllegalAttributeException {
        List<String> emptyList = Collections.emptyList();
        return FeatureUtil.copyAttributesOmitting(source, target, emptyList);
    }

    public static SimpleFeature copyAttributesOmitting(SimpleFeature source, SimpleFeature target, List<String> attributeNameToOmit) throws IllegalAttributeException {
        assert (source != null) : "source cannot be null";
        assert (target != null) : "target cannot be null";
        for (AttributeDescriptor targetAttrDescriptor : target.getFeatureType().getAttributeDescriptors()) {
            String attName = targetAttrDescriptor.getLocalName();
            if (attributeNameToOmit.contains(attName)) continue;
            target = FeatureUtil.copyAttributeValue(attName, source, target);
        }
        return target;
    }

    public static SimpleFeature copyAttributesInPropertyList(SimpleFeature source, SimpleFeature target, List<String> propertiesList) throws IllegalAttributeException {
        assert (source != null) : "source cannot be null";
        assert (target != null) : "target cannot be null";
        assert (propertiesList != null) : "attributeToCopy cannot be null";
        for (String property : propertiesList) {
            assert (source.getAttribute(property) != null) : "propery should be in the source feature";
            AttributeDescriptor propDescriptor = target.getFeatureType().getDescriptor(property);
            if (propDescriptor == null) continue;
            target = FeatureUtil.copyAttributeValue(property, source, target);
        }
        return target;
    }

    private static SimpleFeature copyAttributeValue(String attrName, SimpleFeature source, SimpleFeature target) {
        Class targetClass;
        Class sourceClass;
        AttributeDescriptor targetAttrDescriptor;
        AttributeDescriptor sourceAttrDescriptor = source.getType().getDescriptor(attrName);
        if (sourceAttrDescriptor != null && (targetAttrDescriptor = target.getType().getDescriptor(attrName)) != null && (sourceClass = sourceAttrDescriptor.getType().getBinding()).isAssignableFrom(targetClass = targetAttrDescriptor.getType().getBinding())) {
            Object value = source.getAttribute(attrName);
            target.setAttribute(attrName, value);
        }
        return target;
    }

    public static SimpleFeatureTypeBuilder createDefaultFeatureType() {
        return FeatureUtil.createDefaultFeatureType(Messages.GeoToolsUtils_FeatureTypeName);
    }

    public static SimpleFeatureTypeBuilder createDefaultFeatureType(SimpleFeatureType prototype) {
        assert (prototype != null);
        String newTypeName = String.valueOf(prototype.getTypeName()) + "2";
        return FeatureUtil.createDefaultFeatureType(prototype, newTypeName);
    }

    public static SimpleFeatureTypeBuilder createDefaultFeatureType(SimpleFeatureType prototype, String typeName) {
        assert (prototype != null);
        assert (typeName != null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(typeName);
        List attributes = prototype.getAttributeDescriptors();
        GeometryDescriptor defaultGeometry = prototype.getGeometryDescriptor();
        int i = 0;
        while (i < attributes.size()) {
            AttributeDescriptor att = (AttributeDescriptor)attributes.get(i);
            if (att == defaultGeometry) {
                if (att.getType().getBinding() != MultiPolygon.class && att.getType().getBinding() != Polygon.class) {
                    Class<Polygon> targetGeomType = Polygon.class;
                    Class sourceGeomClass = defaultGeometry.getType().getBinding();
                    if (GeometryCollection.class.isAssignableFrom(sourceGeomClass)) {
                        targetGeomType = MultiPolygon.class;
                    }
                    String geomTypeName = att.getLocalName();
                    CoordinateReferenceSystem crs = defaultGeometry.getCoordinateReferenceSystem();
                    AttributeTypeBuilder build = new AttributeTypeBuilder();
                    build.setName(geomTypeName);
                    build.setBinding(targetGeomType);
                    build.setNillable(true);
                    build.setCRS(crs);
                    GeometryType type = build.buildGeometryType();
                    att = build.buildDescriptor(geomTypeName, type);
                }
                builder.add(att);
                builder.setDefaultGeometry(att.getLocalName());
            } else {
                builder.add(att);
            }
            ++i;
        }
        return builder;
    }

    public static SimpleFeatureTypeBuilder createDefaultFeatureType(String typeName) {
        return FeatureUtil.createDefaultFeatureType(typeName, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, Geometry.class);
    }

    public static SimpleFeatureTypeBuilder createDefaultFeatureType(String typeName, CoordinateReferenceSystem crs, Class<? extends Geometry> targetClass) {
        assert (typeName != null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(typeName);
        builder.setCRS(crs);
        builder.add(Messages.GeoToolsUtils_Geometry, targetClass);
        return builder;
    }

    public static SimpleFeatureType createFeatureType(SimpleFeatureType prototype, String typeName, CoordinateReferenceSystem crs) throws SchemaException {
        assert (prototype != null) : "prototype can be null";
        GeometryDescriptor geomAttrType = prototype.getGeometryDescriptor();
        assert (geomAttrType != null) : "the Geometry Class can be null";
        Class geomClass = geomAttrType.getType().getBinding();
        return FeatureUtil.createFeatureType(prototype, typeName, crs, geomClass);
    }

    public static SimpleFeatureType createFeatureType(SimpleFeatureType prototype, String typeName, CoordinateReferenceSystem crs, Class<? extends Geometry> geometryClass) throws SchemaException {
        assert (prototype != null) : "propotype cannot be null";
        assert (typeName != null) : "typeName cannot be null";
        assert (crs != null) : "crs cannot be null";
        assert (geometryClass != null) : "geometryClass be null";
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(typeName);
        List attributes = prototype.getAttributeDescriptors();
        GeometryDescriptor defaultGeomAttr = prototype.getGeometryDescriptor();
        assert (defaultGeomAttr != null) : "default geometry was expected";
        int i = 0;
        while (i < attributes.size()) {
            AttributeDescriptor att = (AttributeDescriptor)attributes.get(i);
            if (att != defaultGeomAttr) {
                builder.add(att);
            }
            ++i;
        }
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        build.setName(defaultGeomAttr.getLocalName());
        build.setNillable(true);
        build.setBinding(geometryClass);
        build.setCRS(crs);
        GeometryType type = build.buildGeometryType();
        builder.setDefaultGeometry(build.buildDescriptor(defaultGeomAttr.getLocalName(), type).getLocalName());
        builder.add(defaultGeomAttr.getLocalName(), geometryClass, crs);
        return builder.buildFeatureType();
    }

    public static SimpleFeatureType createFeatureType(String name, CoordinateReferenceSystem crs, Class<? extends Geometry> geomClass, List<AttributeDescriptor> attrTypeCollection) throws SchemaException {
        SimpleFeatureTypeBuilder builder = FeatureUtil.createDefaultFeatureType(name, crs, geomClass);
        for (AttributeDescriptor att : attrTypeCollection) {
            builder.add(att);
        }
        return builder.buildFeatureType();
    }

    public static SimpleFeature createFeatureUsing(SimpleFeature sourceFeature, SimpleFeatureType targetType, Geometry newGeometry) throws IllegalAttributeException {
        try {
            SimpleFeature newFeature = DataUtilities.template((SimpleFeatureType)targetType);
            GeometryDescriptor targetGeometryType = targetType.getGeometryDescriptor();
            String geoAttName = targetGeometryType.getLocalName();
            ArrayList<String> omitAttr = new ArrayList<String>(1);
            omitAttr.add(geoAttName);
            newFeature = FeatureUtil.copyAttributesOmitting(sourceFeature, newFeature, omitAttr);
            Class geomClass = targetGeometryType.getType().getBinding();
            Geometry adaptedGeometry = GeometryUtil.adapt(newGeometry, (Class<? extends Geometry>)geomClass);
            newFeature.setAttribute(geoAttName, (Object)adaptedGeometry);
            return newFeature;
        }
        catch (IllegalAttributeException e) {
            throw new IllegalAttributeException(null, null, e.getMessage());
        }
    }

    public static SimpleFeature copyAttributesCheater(SimpleFeature source, SimpleFeature target, List<String> attributeNameToOmit) throws IllegalAttributeException {
        String name;
        assert (source != null) : "illegal argument: source cannot be null";
        assert (target != null) : "illegal argument: target cannot be null";
        HashMap<String, Class> sourceTypes = new HashMap<String, Class>();
        for (AttributeDescriptor att : source.getFeatureType().getAttributeDescriptors()) {
            name = att.getLocalName();
            if (attributeNameToOmit.contains(name)) continue;
            sourceTypes.put(name.toUpperCase(), att.getType().getBinding());
        }
        for (AttributeDescriptor att : target.getFeatureType().getAttributeDescriptors()) {
            name = att.getLocalName();
            if (attributeNameToOmit.contains(name)) continue;
            Class sourceBinding = (Class)sourceTypes.get(name);
            if (sourceBinding == null) {
                sourceBinding = (Class)sourceTypes.get(name.toUpperCase());
            }
            if (sourceBinding == null) continue;
            Object attribute = source.getAttribute(name);
            if (attribute == null) {
                attribute = source.getAttribute(name.toLowerCase());
            }
            if (attribute == null) {
                attribute = source.getAttribute(name.toUpperCase());
            }
            target.setAttribute(name, attribute);
        }
        return target;
    }

    public static SimpleFeature createFeatureWithGeometry(SimpleFeatureType type, Geometry geometry) {
        try {
            SimpleFeature newFeature = DataUtilities.template((SimpleFeatureType)type);
            GeometryDescriptor targetGeometryType = type.getGeometryDescriptor();
            String attGeomName = targetGeometryType.getLocalName();
            Class geomClass = targetGeometryType.getType().getBinding();
            Geometry geoAdapted = GeometryUtil.adapt(geometry, (Class<? extends Geometry>)geomClass);
            newFeature.setAttribute(attGeomName, (Object)geoAdapted);
            return newFeature;
        }
        catch (IllegalAttributeException e) {
            String msg = Messages.GeoToolsUtils_FailCreatingFeature;
            throw (RuntimeException)new RuntimeException(msg).initCause(e);
        }
    }

    public static int computeCollectionSize(FeatureCollection<SimpleFeatureType, SimpleFeature> features) {
        Iterator iter = features.iterator();
        int count = 0;
        try {
            try {
                while (iter.hasNext()) {
                    iter.next();
                    ++count;
                }
            }
            catch (ArithmeticException arithmeticException) {
                count = Integer.MAX_VALUE;
                features.close(iter);
            }
        }
        finally {
            features.close(iter);
        }
        return count;
    }

    public static boolean hasProperty(SimpleFeatureType featureType, List<String> dissolveProperty) {
        for (String property : dissolveProperty) {
            if (FeatureUtil.getPositionProperty(featureType, property) != -1) continue;
            return false;
        }
        return true;
    }

    public static int getPositionProperty(SimpleFeatureType featureType, String propertyName) {
        assert (featureType != null) : "featureType cannot be null";
        assert (propertyName != null) : "propertyName != cannot be null";
        int i = 0;
        while (i < featureType.getAttributeCount()) {
            String name = featureType.getDescriptor(i).getLocalName();
            if (propertyName.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<Integer> getPositionProperty(SimpleFeatureType featureType, List<String> propertyNames) {
        assert (featureType != null) : "featureType cannot be null";
        assert (propertyNames != null) : "propertyName != cannot be null";
        LinkedList<Integer> indexList = new LinkedList<Integer>();
        for (String property : propertyNames) {
            indexList.add(FeatureUtil.getPositionProperty(featureType, property));
        }
        return indexList;
    }

    public static boolean isNewFeature(SimpleFeature feature) {
        boolean isNew = false;
        if (feature.getID().startsWith("new")) {
            isNew = true;
        }
        return isNew;
    }

    public static SimpleFeatureType addAttributeToFeatureType(SimpleFeatureType prototype, String attributeName, Class<?> clazz) throws SchemaException {
        assert (prototype != null);
        assert (attributeName != null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(prototype.getName());
        for (AttributeDescriptor att : prototype.getAttributeDescriptors()) {
            builder.add(att);
        }
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        build.setName(attributeName);
        build.setNillable(true);
        build.setBinding(clazz);
        AttributeDescriptor att = build.buildDescriptor(attributeName);
        builder.add(att);
        return builder.buildFeatureType();
    }

    public static List<SimpleFeature> getFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        FeatureIterator iter = null;
        ArrayList<SimpleFeature> featureList = new ArrayList<SimpleFeature>(featureCollection.size());
        try {
            iter = featureCollection.features();
            while (iter.hasNext()) {
                featureList.add((SimpleFeature)iter.next());
            }
            ArrayList<SimpleFeature> arrayList = featureList;
            return arrayList;
        }
        finally {
            if (iter != null) {
                featureCollection.close(iter);
            }
        }
    }
}

