/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.feature.util;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class FeatureTypeUnionBuilder {
    private final String FEATURE_TYPE_NAME;
    private Map<String, AttributeDescriptor> mapUnionAttributes = new LinkedHashMap<String, AttributeDescriptor>();
    private Map<UnionKey, String> mapOriginalUnion = new HashMap<UnionKey, String>();
    private GeometryDescriptor unionGeometryAttr = null;
    private SimpleFeatureType unionFeatureType = null;
    private List<SimpleFeature> unionFeatures = new ArrayList<SimpleFeature>(2);
    private Geometry geometry = null;
    private Class<? extends Geometry> geometryClass = null;
    private String geometryName = null;

    public FeatureTypeUnionBuilder(String featureTypeName) {
        this.FEATURE_TYPE_NAME = featureTypeName;
    }

    public FeatureTypeUnionBuilder add(SimpleFeatureType featureType) {
        int i = 0;
        while (i < featureType.getAttributeCount()) {
            AttributeDescriptor attributeType = featureType.getDescriptor(i);
            if (!(attributeType instanceof GeometryDescriptor)) {
                String attrUnionName = attributeType.getLocalName();
                if (this.mapUnionAttributes.containsKey(attrUnionName)) {
                    StringBuffer duplicatedName = new StringBuffer(attrUnionName);
                    duplicatedName.append("2");
                    attrUnionName = duplicatedName.toString();
                }
                AttributeTypeBuilder builder = new AttributeTypeBuilder();
                builder.setBinding(attributeType.getType().getBinding());
                builder.setNillable(attributeType.isNillable());
                AttributeDescriptor newAttribute = builder.buildDescriptor(attrUnionName);
                this.mapUnionAttributes.put(attrUnionName, newAttribute);
                this.mapOriginalUnion.put(new UnionKey(featureType.getTypeName(), attributeType.getLocalName()), attrUnionName);
            }
            ++i;
        }
        return this;
    }

    public FeatureTypeUnionBuilder setGeometryClass(String geometryName, Class<? extends Geometry> geomClass, CoordinateReferenceSystem crs) {
        GeometryDescriptor geoAttrType;
        assert (geometryName != null) : "the geometry name can not be null";
        assert (geomClass != null) : "the geometry class can not be null";
        assert (crs != null) : "the CRS can not be null";
        this.geometryName = geometryName;
        this.geometryClass = geomClass;
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        build.setName(this.geometryName);
        build.setBinding(this.geometryClass);
        build.setNillable(true);
        build.setLength(100);
        build.setCRS(crs);
        GeometryType type = build.buildGeometryType();
        this.unionGeometryAttr = geoAttrType = build.buildDescriptor(this.geometryName, type);
        return this;
    }

    public FeatureTypeUnionBuilder setGeometry(Geometry geom) {
        this.geometry = geom;
        return this;
    }

    public FeatureTypeUnionBuilder add(SimpleFeature feature) {
        this.unionFeatures.add(feature);
        return this;
    }

    private SimpleFeatureType createFeatureType() throws SchemaException {
        AttributeDescriptor[] attrType = new AttributeDescriptor[this.mapUnionAttributes.size()];
        int i = 0;
        for (Map.Entry<String, AttributeDescriptor> entry : this.mapUnionAttributes.entrySet()) {
            attrType[i++] = entry.getValue();
        }
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.FEATURE_TYPE_NAME);
        builder.setAbstract(false);
        builder.add((AttributeDescriptor)this.unionGeometryAttr);
        builder.addAll(attrType);
        SimpleFeatureType newType = builder.buildFeatureType();
        return newType;
    }

    public SimpleFeatureType getFeatureType() throws SchemaException {
        if (this.unionFeatureType == null) {
            this.unionFeatureType = this.createFeatureType();
        }
        return this.unionFeatureType;
    }

    public SimpleFeature getFeature() throws IllegalAttributeException, SchemaException {
        SimpleFeatureType unionFeatureType = this.getFeatureType();
        Object[] attrList = new Object[unionFeatureType.getAttributeCount()];
        for (SimpleFeature feature : this.unionFeatures) {
            SimpleFeatureType featureType = feature.getFeatureType();
            int j = 0;
            while (j < featureType.getAttributeCount()) {
                AttributeDescriptor attrType = featureType.getDescriptor(j);
                if (!(attrType instanceof GeometryDescriptor)) {
                    Object attrValue = feature.getAttribute(j);
                    String unionAttrName = this.findAttributeName(featureType.getTypeName(), attrType.getLocalName());
                    int unionAttrPosition = unionFeatureType.indexOf(unionAttrName);
                    attrList[unionAttrPosition] = attrValue;
                }
                ++j;
            }
        }
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(unionFeatureType);
        builder.addAll(attrList);
        SimpleFeature product = builder.buildFeature(null);
        product.setDefaultGeometry((Object)this.geometry);
        return product;
    }

    private String findAttributeName(String featureTypeName, String attrName) {
        UnionKey key = new UnionKey(featureTypeName, attrName);
        String unionAttrName = this.mapOriginalUnion.get(key);
        return unionAttrName;
    }

    protected class UnionKey {
        private String featureTypeName;
        private String attrTypeName;

        UnionKey(String featureTypeName, String attrTypeName) {
            this.attrTypeName = attrTypeName;
            this.featureTypeName = featureTypeName;
        }

        public String getFeatureTypeName() {
            return this.featureTypeName;
        }

        public String getAttrTypeName() {
            return this.attrTypeName;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.attrTypeName == null ? 0 : this.attrTypeName.hashCode());
            result = 31 * result + (this.featureTypeName == null ? 0 : this.featureTypeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnionKey other = (UnionKey)obj;
            if (this.attrTypeName == null ? other.attrTypeName != null : !this.attrTypeName.equals(other.attrTypeName)) {
                return false;
            }
            return !(this.featureTypeName == null ? other.featureTypeName != null : !this.featureTypeName.equals(other.featureTypeName));
        }
    }
}

