/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.feature.split;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import eu.udig.tools.feature.split.CannotSplitException;
import eu.udig.tools.feature.split.SplitFeatureBuilderFailException;
import eu.udig.tools.feature.util.GeoToolsUtils;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import eu.udig.tools.geometry.split.SplitStrategy;
import eu.udig.tools.geometry.split.VertexStrategy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public final class SplitFeatureBuilder {
    private static final Logger LOGGER = Logger.getLogger(SplitFeatureBuilder.class.getName());
    private List<Geometry> originalGeometryList;
    private List<SimpleFeature> splitResultList;
    private List<SimpleFeature> neighbourResultList = null;
    private LineString splitLine;
    private SplitStrategy splitStrategy;
    private List<SimpleFeature> featureList;
    private CoordinateReferenceSystem desiredCRS;
    private List<SimpleFeature> featuresThatSufferedSplit;

    private SplitFeatureBuilder() {
    }

    public static SplitFeatureBuilder newInstance(List<SimpleFeature> featureList, LineString splitLine, CoordinateReferenceSystem desiredCRS) throws IllegalArgumentException, SplitFeatureBuilderFailException {
        if (featureList == null) {
            throw new IllegalArgumentException("The source feature list is required");
        }
        if (splitLine == null) {
            throw new IllegalArgumentException("The split line is required");
        }
        if (desiredCRS == null) {
            throw new IllegalArgumentException("The desired crs is required, i.e: map crs");
        }
        if (!(splitLine.getUserData() instanceof CoordinateReferenceSystem)) {
            throw new IllegalArgumentException("Set the crs of the line before calling newInstance (splitLine.setUserData(CoordinateReferenceSystem))");
        }
        LOGGER.fine("featureList parameter:" + SplitFeatureBuilder.prettyPrint(featureList));
        LOGGER.fine("splitLine parameter:" + splitLine.toText());
        LOGGER.fine(((CoordinateReferenceSystem)splitLine.getUserData()).toWKT());
        try {
            LineString splitReprojected = (LineString)GeoToolsUtils.reproject((Geometry)splitLine, (CoordinateReferenceSystem)splitLine.getUserData(), desiredCRS);
            SplitFeatureBuilder sfb = new SplitFeatureBuilder();
            sfb.splitLine = splitReprojected;
            sfb.splitStrategy = new SplitStrategy(splitLine);
            sfb.splitResultList = null;
            sfb.originalGeometryList = new LinkedList<Geometry>();
            sfb.featuresThatSufferedSplit = new LinkedList<SimpleFeature>();
            sfb.featureList = featureList;
            sfb.desiredCRS = desiredCRS;
            return sfb;
        }
        catch (Exception e) {
            throw SplitFeatureBuilder.makeFailException(e);
        }
    }

    public static SplitFeatureBuilder newInstance(SimpleFeature feature, LineString splitLine, CoordinateReferenceSystem desiredCRS) throws SplitFeatureBuilderFailException {
        LinkedList<SimpleFeature> featureList = new LinkedList<SimpleFeature>();
        featureList.add(feature);
        return SplitFeatureBuilder.newInstance(featureList, splitLine, desiredCRS);
    }

    private static String prettyPrint(List<SimpleFeature> featureList) {
        StringBuilder strBuilder = new StringBuilder("\n");
        for (SimpleFeature f : featureList) {
            strBuilder.append("Feature Id -- Geometry: ").append(f.getID()).append(" -- ").append(f.getDefaultGeometry()).append("\n");
        }
        return strBuilder.toString();
    }

    public SplitFeatureBuilder buildSplit() throws SplitFeatureBuilderFailException, CannotSplitException {
        try {
            this.splitResultList = new LinkedList<SimpleFeature>();
            boolean existSplit = false;
            for (SimpleFeature feature : this.featureList) {
                Geometry geomToSplit = (Geometry)feature.getDefaultGeometry();
                assert (geomToSplit.isValid()) : "No Valid Geometry: " + geomToSplit.toText();
                CoordinateReferenceSystem featureCrs = feature.getFeatureType().getCoordinateReferenceSystem();
                if (!this.canSplit(geomToSplit = GeoToolsUtils.reproject(geomToSplit, featureCrs, this.desiredCRS))) continue;
                existSplit = true;
                this.featuresThatSufferedSplit.add(feature);
                List<Geometry> splitGeometriesResult = this.split(geomToSplit);
                this.splitResultList.addAll(this.createSplitFeatures(splitGeometriesResult, feature));
            }
            if (!existSplit) {
                throw new CannotSplitException("The split line cannot split any features");
            }
        }
        catch (OperationNotFoundException e) {
            throw SplitFeatureBuilder.makeFailException((Exception)((Object)e));
        }
        catch (TransformException e) {
            throw SplitFeatureBuilder.makeFailException((Exception)((Object)e));
        }
        return this;
    }

    private static SplitFeatureBuilderFailException makeFailException(Exception e) {
        e.printStackTrace();
        String msg = e.getMessage();
        LOGGER.severe(msg);
        return new SplitFeatureBuilderFailException(msg);
    }

    private List<SimpleFeature> createSplitFeatures(List<Geometry> splitGeometries, SimpleFeature feature) throws OperationNotFoundException, TransformException {
        SimpleFeatureType featureType = feature.getFeatureType();
        CoordinateReferenceSystem featureCrs = featureType.getCoordinateReferenceSystem();
        Class geometryType = featureType.getGeometryDescriptor().getType().getBinding();
        LinkedList<SimpleFeature> splitFeatureList = new LinkedList<SimpleFeature>();
        for (Geometry splittedPart : splitGeometries) {
            splittedPart = GeoToolsUtils.reproject(splittedPart, this.desiredCRS, featureCrs);
            splittedPart = GeometryUtil.adapt(splittedPart, (Class<? extends Geometry>)geometryType);
            SimpleFeature newFeature = DataUtilities.template((SimpleFeatureType)featureType);
            GeoToolsUtils.copyAttributes(feature, newFeature);
            newFeature.setDefaultGeometry((Object)splittedPart);
            splitFeatureList.add(newFeature);
        }
        return splitFeatureList;
    }

    public List<SimpleFeature> getSplitResult() {
        if (this.splitResultList == null) {
            throw new IllegalStateException("the buildSplit method must be called before");
        }
        return this.splitResultList;
    }

    private boolean canSplit(Geometry geom) {
        return this.splitStrategy.canSplit(geom);
    }

    private List<Geometry> split(Geometry geomToSplit) {
        this.originalGeometryList.add(geomToSplit);
        return this.splitStrategy.split(geomToSplit);
    }

    public SplitFeatureBuilder buildNeighbours() throws SplitFeatureBuilderFailException {
        this.neighbourResultList = new ArrayList<SimpleFeature>();
        try {
            for (SimpleFeature feature : this.featureList) {
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                CoordinateReferenceSystem featureCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                if (this.canSplit(geom = GeoToolsUtils.reproject(geom, featureCRS, this.desiredCRS)) || !this.requireVertex(geom)) continue;
                Geometry geomWithAddedVertex = this.addVertexToNeighbour(geom);
                geomWithAddedVertex = GeoToolsUtils.reproject(geomWithAddedVertex, this.desiredCRS, featureCRS);
                feature.setDefaultGeometry((Object)geomWithAddedVertex);
                this.neighbourResultList.add(feature);
            }
        }
        catch (Exception e) {
            throw SplitFeatureBuilder.makeFailException(e);
        }
        return this;
    }

    public List<SimpleFeature> getNeighbourResult() {
        if (this.neighbourResultList == null) {
            throw new IllegalStateException("the method buildNeighbours() must be called before");
        }
        return this.neighbourResultList;
    }

    private boolean requireVertex(Geometry geomToAddVertex) {
        for (Geometry geomNeighbor : this.originalGeometryList) {
            if (!geomToAddVertex.touches(geomNeighbor)) continue;
            return true;
        }
        return false;
    }

    private Geometry addVertexToNeighbour(Geometry geomToAddVertex) {
        return VertexStrategy.addIntersectionVertex(geomToAddVertex, (Geometry)this.splitLine, this.originalGeometryList);
    }

    public List<SimpleFeature> getFeaturesThatSufferedSplit() {
        assert (this.featuresThatSufferedSplit != null);
        return this.featuresThatSufferedSplit;
    }
}

