/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.arc.internal;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import eu.udig.tools.arc.internal.ArcBuilder;
import eu.udig.tools.feature.util.GeoToolsUtils;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import eu.udig.tools.internal.mediator.AppGISAdapter;
import eu.udig.tools.internal.ui.util.DialogUtil;
import eu.udig.tools.internal.ui.util.LayerUtil;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class CreateArcBehaviour
implements Behaviour {
    public boolean isValid(EditToolHandler handler) {
        PrimitiveShape currentShape = handler.getCurrentShape();
        if (currentShape == null) {
            return false;
        }
        int nCoords = currentShape.getNumCoords();
        return nCoords == 3;
    }

    public UndoableMapCommand getCommand(EditToolHandler handler) {
        SimpleFeature feature;
        PrimitiveShape currentShape = handler.getCurrentShape();
        ILayer editLayer = handler.getEditLayer();
        GeometryFactory gf = new GeometryFactory();
        CoordinateReferenceSystem layerCrs = LayerUtil.getCrs(editLayer);
        CoordinateReferenceSystem mapCrs = editLayer.getMap().getViewportModel().getCRS();
        Point p1 = gf.createPoint(currentShape.getCoord(0));
        Point p2 = gf.createPoint(currentShape.getCoord(1));
        Point p3 = gf.createPoint(currentShape.getCoord(2));
        try {
            p1 = (Point)GeoToolsUtils.reproject((Geometry)p1, layerCrs, mapCrs);
            p2 = (Point)GeoToolsUtils.reproject((Geometry)p2, layerCrs, mapCrs);
            p3 = (Point)GeoToolsUtils.reproject((Geometry)p3, layerCrs, mapCrs);
        }
        catch (OperationNotFoundException onfe) {
            throw new RuntimeException(onfe);
        }
        catch (TransformException te) {
            throw new RuntimeException(te);
        }
        ArcBuilder builder = new ArcBuilder();
        builder.setPoints(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
        LineString geom = builder.getGeometry(15);
        if (geom == null) {
            throw new RuntimeException("null geom");
        }
        try {
            geom = GeoToolsUtils.reproject((Geometry)geom, mapCrs, layerCrs);
        }
        catch (OperationNotFoundException onfe) {
            throw new RuntimeException(onfe);
        }
        catch (TransformException te) {
            throw new RuntimeException(te);
        }
        EditCommandFactory editCmdFac = AppGISAdapter.getEditCommandFactory();
        ILayer layer = editLayer;
        SimpleFeatureType schema = layer.getSchema();
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[1], null);
            assert (feature != null) : "feature creation fail.";
            Class type = schema.getGeometryDescriptor().getType().getBinding();
            geom = GeometryUtil.adapt((Geometry)geom, (Class<? extends Geometry>)type);
            feature.setDefaultGeometry((Object)geom);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException(e);
        }
        UndoableMapCommand command = editCmdFac.createAddFeatureCommand(feature, layer);
        handler.setCurrentShape(null);
        handler.setCurrentState(EditState.NONE);
        return command;
    }

    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        error.printStackTrace();
        DialogUtil.openError("Create arc failed to execute", error.getMessage());
    }
}

