/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.arc.internal;

import eu.udig.tools.arc.internal.ArcBuilder;
import eu.udig.tools.arc.internal.beahaviour.EditToolFeedbackManager;
import java.awt.Shape;
import java.awt.geom.Line2D;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.commands.DrawCommandFactory;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.internal.commands.draw.DrawShapeCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;

public class ArcFeedbackManager
implements EditToolFeedbackManager {
    private DrawShapeCommand drawShapeCommand;
    private ArcBuilder arcBuilder = new ArcBuilder();
    private Line2D linearArc = new Line2D.Double();

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean isValid;
        if (EventType.MOVED != eventType) {
            return false;
        }
        boolean editting = handler.getCurrentState() == EditState.CREATING;
        PrimitiveShape currentShape = handler.getCurrentShape();
        int nPoints = currentShape == null ? 0 : currentShape.getNumPoints();
        boolean bl = isValid = editting && nPoints <= 2;
        if (!isValid) {
            this.clearFeedback();
        }
        return isValid;
    }

    @Override
    public UndoableMapCommand getFeedbackCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        PrimitiveShape currentShape = handler.getCurrentShape();
        if (currentShape == null) {
            return this.getCancelCommand(handler);
        }
        int numPoints = currentShape.getNumPoints();
        assert (numPoints == 1 || numPoints == 2);
        Point point1 = currentShape.getPoint(0);
        Shape shape = null;
        if (numPoints == 1) {
            this.linearArc.setLine(point1.getX(), point1.getY(), e.x, e.y);
            shape = this.linearArc;
        } else {
            Point point2 = currentShape.getPoint(1);
            double x1 = point1.getX();
            double y1 = point1.getY();
            double x2 = point2.getX();
            double y2 = point2.getY();
            double x3 = e.x;
            double y3 = e.y;
            this.arcBuilder.setPoints(x1, y1, x2, y2, x3, y3);
            shape = this.arcBuilder.getArc();
            if (shape == null) {
                double fromX = Math.min(x1, Math.min(x2, x3));
                double fromY = Math.min(y1, Math.min(y2, y3));
                double toX = Math.max(x1, Math.max(x2, x3));
                double toY = Math.max(y1, Math.max(y2, y3));
                this.linearArc.setLine(fromX, fromY, toX, toY);
                shape = this.linearArc;
            }
        }
        if (this.drawShapeCommand == null) {
            DrawCommandFactory dcf = DrawCommandFactory.getInstance();
            this.drawShapeCommand = dcf.createDrawShapeCommand(shape);
            IToolContext context = handler.getContext();
            ViewportPane viewportPane = context.getViewportPane();
            viewportPane.addDrawCommand((IDrawCommand)this.drawShapeCommand);
        } else {
            this.drawShapeCommand.setShape(shape);
        }
        handler.repaint();
        return null;
    }

    @Override
    public UndoableMapCommand getCancelCommand(EditToolHandler handler) {
        this.clearFeedback();
        return null;
    }

    @Override
    public UndoableMapCommand getAcceptCommand(EditToolHandler handler) {
        this.clearFeedback();
        return null;
    }

    private void clearFeedback() {
        if (this.drawShapeCommand != null) {
            this.drawShapeCommand.setValid(false);
        }
        this.drawShapeCommand = null;
    }
}

