/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.arc.internal;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Triangle;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;

public class ArcBuilder {
    private final Coordinate point1 = new Coordinate();
    private final Coordinate point2 = new Coordinate();
    private final Coordinate point3 = new Coordinate();
    private Coordinate[] ring = new Coordinate[]{this.point1, this.point2, this.point3, this.point1};

    public Arc2D getArc() {
        Coordinate end;
        Coordinate start;
        Coordinate arcCenter = this.getArcCenter();
        if (arcCenter == null) {
            return null;
        }
        double radius = arcCenter.distance(this.point1);
        double minx = arcCenter.x - radius;
        double miny = arcCenter.y - radius;
        Rectangle2D.Double rect = new Rectangle2D.Double(minx, miny, 2.0 * radius, 2.0 * radius);
        Arc2D.Double arc = new Arc2D.Double(rect, 0.0, 0.0, 0);
        boolean ccw = CGAlgorithms.isCCW((Coordinate[])this.ring);
        if (ccw) {
            start = this.point3;
            end = this.point1;
        } else {
            start = this.point1;
            end = this.point3;
        }
        arc.setAngles(start.x, start.y, end.x, end.y);
        return arc;
    }

    public LineString getGeometry(int pointsPerQuadrant) {
        assert (pointsPerQuadrant > 0);
        GeometryFactory gf = new GeometryFactory();
        Arc2D arc = this.getArc();
        if (arc == null) {
            return null;
        }
        double flatness = this.calculateMaxDistanceToCurve(arc, pointsPerQuadrant);
        PathIterator pathIterator = arc.getPathIterator(null, flatness);
        LinkedList<Coordinate> coords = new LinkedList<Coordinate>();
        double[] coordsHolder = new double[6];
        while (!pathIterator.isDone()) {
            int pathSegType = pathIterator.currentSegment(coordsHolder);
            double x = coordsHolder[0];
            double y = coordsHolder[1];
            switch (pathSegType) {
                case 0: {
                    assert (coords.size() == 0);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected path segment type: " + pathSegType);
                }
            }
            coords.add(new Coordinate(x, y));
            pathIterator.next();
        }
        Coordinate[] coordinates = coords.toArray(new Coordinate[coords.size()]);
        LineString line = gf.createLineString(coordinates);
        return line;
    }

    private double calculateMaxDistanceToCurve(Arc2D arc, int pointsPerQuadrant) {
        double centerX = arc.getCenterX();
        double centerY = arc.getCenterY();
        Coordinate center = new Coordinate(centerX, centerY);
        Point2D sp = arc.getStartPoint();
        Coordinate startPoint = new Coordinate(sp.getX(), sp.getY());
        double radius = center.distance(startPoint);
        double angleStep = 1.5707963267948966 / (double)pointsPerQuadrant;
        double dx = radius * Math.cos(angleStep);
        double dy = radius * Math.sin(angleStep);
        Coordinate c1 = new Coordinate(center.x + radius, center.y);
        Coordinate c2 = new Coordinate(center.x + dx, center.y + dy);
        Coordinate bisectorCoord = Triangle.angleBisector((Coordinate)c1, (Coordinate)center, (Coordinate)c2);
        double bisectorLength = center.distance(bisectorCoord);
        double flatness = radius - bisectorLength;
        return flatness;
    }

    public Coordinate getArcCenter() {
        LineSegment chord1 = new LineSegment(this.point1, this.point2);
        LineSegment chord2 = new LineSegment(this.point2, this.point3);
        LineSegment midPointNormal1 = this.getMidpointNormal(chord1, 1.0E7);
        LineSegment midPointNormal2 = this.getMidpointNormal(chord2, 1.0E7);
        Coordinate center = midPointNormal1.intersection(midPointNormal2);
        return center;
    }

    public LineSegment getMidpointNormal(LineSegment segment, double lenght) {
        Coordinate midPoint = segment.midPoint();
        double chordAngle = segment.angle();
        double normalAngle = chordAngle + 1.5707963267948966;
        double midLen = lenght / 2.0;
        double dx = midLen * Math.cos(normalAngle);
        double dy = midLen * Math.sin(normalAngle);
        double x1 = midPoint.x - dx;
        double y1 = midPoint.y - dy;
        double x2 = midPoint.x + dx;
        double y2 = midPoint.y + dy;
        Coordinate p1 = new Coordinate(x1, y1);
        Coordinate p2 = new Coordinate(x2, y2);
        LineSegment normalSegment = new LineSegment(p1, p2);
        return normalSegment;
    }

    public void setPoints(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.point1.x = x1;
        this.point1.y = y1;
        this.point2.x = x2;
        this.point2.y = y2;
        this.point3.x = x3;
        this.point3.y = y3;
    }

    public Coordinate getPoint1() {
        return new Coordinate(this.point1);
    }

    public Coordinate getPoint2() {
        return new Coordinate(this.point2);
    }

    public Coordinate getPoint3() {
        return new Coordinate(this.point3);
    }
}

