/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.feature.basic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.TopologyException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.refractions.udig.core.TransparencyRemovingVisitor;
import net.refractions.udig.core.jts.ReferencedEnvelopeCache;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.internal.render.impl.Styling;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.render.feature.basic.internal.Messages;
import net.refractions.udig.render.internal.feature.basic.LabelCacheDecorator;
import net.refractions.udig.render.internal.feature.basic.RendererPlugin;
import net.refractions.udig.style.filter.FilterStyle;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class BasicFeatureRenderer
extends RendererImpl {
    private GTRenderer renderer = null;
    protected MapContent map = null;
    protected Layer[] layers = null;
    protected BasicRenderListener listener = new BasicRenderListener();
    private static final int NOT_INITIALIZED = -2;
    int count = -2;
    private int expandSizePaintArea = 0;

    public BasicFeatureRenderer() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(StreamingRenderer.class.getClassLoader());
            Logger logger = Logger.getLogger("org.geotools.rendering");
            if (RendererPlugin.isDebugging("net.refractions.udig.render.feature.basic/finest")) {
                logger.setLevel(Level.FINE);
                ConsoleHandler ch = new ConsoleHandler();
                ch.setLevel(Level.FINE);
                logger.addHandler(ch);
            } else {
                logger.setLevel(Level.SEVERE);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    public void render(Graphics2D destination, IProgressMonitor monitor) throws RenderException {
        this.render(destination, this.getContext().getImageBounds(), monitor, false);
    }

    protected void setQueries() {
    }

    private void prepareDraw(IProgressMonitor monitor) throws IOException, SchemaException {
        FeatureLayer featureLayer;
        CoordinateReferenceSystem dataCRS;
        ILayer layer = this.getContext().getLayer();
        StyleBlackboard styleBlackboard = (StyleBlackboard)layer.getStyleBlackboard();
        SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getResource(SimpleFeatureStore.class, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        if (featureSource == null) {
            featureSource = (SimpleFeatureSource)layer.getResource(SimpleFeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        }
        Style style = this.getStyle(styleBlackboard, (FeatureSource<SimpleFeatureType, SimpleFeature>)featureSource);
        this.layers = new Layer[1];
        CoordinateReferenceSystem layerCRS = layer.getCRS();
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        Query query = this.getContext().getFeatureQuery();
        if (styleBlackboard.contains("net.refractions.udig.style.filter")) {
            FilterStyle filterStyle;
            Filter styleFilter;
            if (query == null) {
                query = new Query(schema.getTypeName());
            }
            if ((styleFilter = (filterStyle = (FilterStyle)styleBlackboard.get("net.refractions.udig.style.filter")).toFilter((FeatureType)schema)) != Filter.INCLUDE) {
                Filter queryFilter = query.getFilter();
                if (queryFilter == Filter.INCLUDE) {
                    query.setFilter(styleFilter);
                } else {
                    FilterFactory ff = CommonFactoryFinder.getFilterFactory();
                    And combinedFilter = ff.and(styleFilter, queryFilter);
                    query.setFilter((Filter)combinedFilter);
                }
            }
        }
        if (!layerCRS.equals(dataCRS = schema.getCoordinateReferenceSystem())) {
            featureLayer = new FeatureLayer((FeatureSource)featureSource, style, layer.getName());
            if (query == null) {
                query = new Query(schema.getTypeName());
            }
            query.setCoordinateSystem(layerCRS);
            featureLayer.setQuery(query);
            SimpleFeatureCollection features = featureSource.getFeatures(query);
            CoordinateReferenceSystem queryCRS = ((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem();
            if (queryCRS.equals(layerCRS)) {
                this.layers[0] = featureLayer;
            } else {
                ForceCoordinateSystemFeatureResults reprojectingFc = new ForceCoordinateSystemFeatureResults((FeatureCollection)features, layerCRS);
                this.layers[0] = new FeatureLayer((FeatureCollection)reprojectingFc, style, layer.getName());
            }
        } else {
            featureLayer = new FeatureLayer((FeatureSource)featureSource, style, layer.getName());
            if (query != null) {
                featureLayer.setQuery(query);
            }
            this.layers[0] = featureLayer;
        }
        this.map = new MapContent();
        this.map.getViewport().setCoordinateReferenceSystem(this.getContext().getCRS());
        this.map.layers().addAll(Arrays.asList(this.layers));
    }

    protected Style getStyle(StyleBlackboard styleBlackboard, FeatureSource<SimpleFeatureType, SimpleFeature> featureSource) {
        Style style = (Style)styleBlackboard.lookup(Style.class);
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        boolean transparency = store.getBoolean("transparencyPreference");
        try {
            if (!transparency && style != null) {
                DuplicatingStyleVisitor duplicator = new DuplicatingStyleVisitor();
                style.accept((StyleVisitor)duplicator);
                style = (Style)duplicator.getCopy();
                style = this.removeTransparency(style);
            }
        }
        catch (Throwable e) {
            RendererPlugin.log("Error duplicating style for transparency setting", e);
        }
        if (style != null) {
            this.expandSizePaintArea = this.getExpandSizeFromStyle(style);
        }
        if (style == null) {
            style = Styling.createLineStyle((String)((SimpleFeatureType)featureSource.getSchema()).getName().getLocalPart(), (Color)Color.BLUE);
        }
        return style;
    }

    private Style removeTransparency(Style style) {
        style.accept((StyleVisitor)new TransparencyRemovingVisitor());
        return style;
    }

    private int getExpandSizeFromStyle(Style style) {
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        FeatureTypeStyle[] styles = style.getFeatureTypeStyles();
        int t = 0;
        while (t < styles.length) {
            FeatureTypeStyle lfts = styles[t];
            Rule[] rules = lfts.getRules();
            int j = 0;
            while (j < rules.length) {
                rbe.visit(rules[j]);
                ++j;
            }
            ++t;
        }
        if (!rbe.isEstimateAccurate()) {
            RendererPlugin.log("Assuming rendering buffer = " + rbe.getBuffer() + ", but estimation is not accurate, you may want to set a buffer manually", null);
        }
        return (int)Math.round((double)rbe.getBuffer() / 2.0 + 1.0);
    }

    public void dispose() {
        if (this.getRenderer() != null) {
            this.getRenderer().stopRendering();
        }
    }

    public void setState(int newState) {
        super.setState(newState);
    }

    public void render(IProgressMonitor monitor) throws RenderException {
        Graphics2D graphics = null;
        try {
            graphics = this.getContext().getImage().createGraphics();
            this.render(graphics, this.getRenderBounds(), monitor, true);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void render(Graphics2D graphics, ReferencedEnvelope bounds, IProgressMonitor monitor, boolean clear) throws RenderException {
        block41: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.getContext().setStatus(1);
            this.getContext().setStatusMessage(Messages.BasicFeatureRenderer_rendering_status);
            endMessage = null;
            endStatus = 0;
            monitor.beginTask("rendering features", 100);
            if (this.getContext().getLayer().getSchema() == null || this.getContext().getLayer().getSchema().getGeometryDescriptor() == null) {
                endStatus = 4;
                endMessage = Messages.BasicFeatureRenderer_layer_has_no_geometry;
                return;
            }
            this.prepareDraw((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (monitor.isCanceled()) ** continue;
            validBounds = BasicFeatureRenderer.validateBounds(bounds, (IProgressMonitor)new SubProgressMonitor(monitor, 3), this.getContext());
            if (validBounds.isNull()) {
                return;
            }
            try {
                monitor.setTaskName("rendering features - area");
                validBounds.transform(this.getContext().getLayer().getCRS(), true);
            }
            catch (TransformException te) {
                RendererPlugin.log("viewable area is available in the layer CRS", te);
                endMessage = Messages.BasicFeatureRenderer_warning1;
                endStatus = 4;
                if (this.map != null) {
                    this.map.layers().clear();
                }
                this.getContext().setStatus(endStatus);
                this.getContext().setStatusMessage(endMessage);
                renderingProblem = this.listener.exception;
                if (renderingProblem != null) {
                    if (renderingProblem instanceof InterruptedException) {
                        return;
                    }
                    if (!(renderingProblem instanceof TopologyException)) {
                        e2 = new RenderException(String.valueOf(Messages.BasicFeatureRenderer_renderingProblem) + renderingProblem.getLocalizedMessage(), (Throwable)renderingProblem);
                        throw e2;
                    }
                }
                if (!this.listener.featureRendered && (totalFeatures = -1) != -1 && totalFeatures > 0) {
                    this.getContext().setStatusMessage(Messages.BasicFeatureRenderer_noFeatures);
                }
                monitor.done();
                return;
            }
            catch (AssertionError te) {
                block40: {
                    RendererPlugin.log("Viewable area available in the layer CRS", (Throwable)te);
                    endMessage = Messages.BasicFeatureRenderer_warning1;
                    endStatus = 4;
                    if (this.map == null) break block40;
                    this.map.layers().clear();
                }
                this.getContext().setStatus(endStatus);
                this.getContext().setStatusMessage(endMessage);
                renderingProblem = this.listener.exception;
                if (renderingProblem != null) {
                    if (renderingProblem instanceof InterruptedException) {
                        return;
                    }
                    if (!(renderingProblem instanceof TopologyException)) {
                        e2 = new RenderException(String.valueOf(Messages.BasicFeatureRenderer_renderingProblem) + renderingProblem.getLocalizedMessage(), (Throwable)renderingProblem);
                        throw e2;
                    }
                }
                if (!this.listener.featureRendered && (totalFeatures = -1) != -1 && totalFeatures > 0) {
                    this.getContext().setStatusMessage(Messages.BasicFeatureRenderer_noFeatures);
                }
                monitor.done();
                return;
            }
            catch (FactoryException e) {
                throw (RenderException)new RenderException().initCause((Throwable)e);
            }
            this.listener.init((IProgressMonitor)new SubProgressMonitor(monitor, 90));
            this.setQueries();
            monitor.worked(5);
            min = this.getContext().worldToPixel(new Coordinate(validBounds.getMinX(), validBounds.getMinY()));
            max = this.getContext().worldToPixel(new Coordinate(validBounds.getMaxX(), validBounds.getMaxY()));
            width = Math.abs(max.x - min.x);
            height = Math.abs(max.y - min.y);
            paintArea = new Rectangle(Math.min(min.x, max.x), Math.min(min.y, max.y), width, height);
            expandPaintAreaBy = 0;
            if (this.expandSizePaintArea > 0) {
                expandPaintAreaBy = this.expandSizePaintArea;
            }
            paintArea.add(Math.min(min.x, max.x) - expandPaintAreaBy, Math.min(min.y, max.y) - expandPaintAreaBy);
            paintArea.add(Math.max(min.x, max.x) + expandPaintAreaBy, Math.max(min.y, max.y) + expandPaintAreaBy);
            if (clear) {
                graphics.setBackground(new Color(0, 0, 0, 0));
                graphics.clearRect(paintArea.x, paintArea.y, paintArea.width, paintArea.height);
            }
            validBounds = this.getContext().worldBounds(paintArea);
            mapViewport = new MapViewport(validBounds);
            this.map.setViewport(mapViewport);
            geotToolsRenderer = this.getRenderer();
            if (bounds != null && !bounds.isNull()) {
                graphics.setClip(paintArea);
            }
            rendererHints = geotToolsRenderer.getRendererHints();
            rendererHints.put("declaredScaleDenominator", this.getContext().getViewportModel().getScaleDenominator());
            rendererHints.put("scaleComputationMethod", "ACCURATE");
            labelPainter = this.getContext().getLabelPainter();
            origin = new Point(paintArea.x, paintArea.y);
            layerId = this.getContext().getLayer().getID().toString();
            if (this.getContext().getLayer() instanceof SelectionLayer) {
                layerId = String.valueOf(layerId) + "-Selection";
            }
            rendererHints.put("labelCache", new LabelCacheDecorator((LabelCache)labelPainter, origin, layerId));
            geotToolsRenderer.setRendererHints(rendererHints);
            hints = new RenderingHints(Collections.EMPTY_MAP);
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED));
            hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
            hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED));
            hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED));
            hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR));
            hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
            hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF));
            store = ProjectPlugin.getPlugin().getPreferenceStore();
            antiAliasing = store.getBoolean("antiAliasingPreference");
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, antiAliasing != false ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF));
            graphics.addRenderingHints(hints);
            geotToolsRenderer.setJava2DHints(hints);
            if (!monitor.isCanceled()) ** GOTO lbl-1000
            return;
lbl-1000:
            // 1 sources

            {
                if (paintArea == null || paintArea.isEmpty() || validBounds == null || validBounds.isEmpty() || validBounds.isNull() || validBounds.getWidth() <= 0.0 || validBounds.getHeight() <= 0.0) {
                    System.out.println("nothing to draw");
                } else {
                    geotToolsRenderer.paint(graphics, paintArea, validBounds);
                }
                break block41;
                {
                    catch (Throwable renderingProblem) {
                        if (renderingProblem instanceof InterruptedException) {
                            return;
                        }
                        e2 = new RenderException(renderingProblem.getClass() + " occured during rendering: " + renderingProblem.getLocalizedMessage(), renderingProblem);
                        throw e2;
                    }
                    catch (Throwable var23_51) {
                        throw var23_51;
                    }
                }
            }
            finally {
                if (this.map != null) {
                    this.map.layers().clear();
                }
                this.getContext().setStatus(endStatus);
                this.getContext().setStatusMessage(endMessage);
                renderingProblem = this.listener.exception;
                if (renderingProblem != null) {
                    if (renderingProblem instanceof InterruptedException) {
                        return;
                    }
                    if (!(renderingProblem instanceof TopologyException)) {
                        e2 = new RenderException(String.valueOf(Messages.BasicFeatureRenderer_renderingProblem) + renderingProblem.getLocalizedMessage(), (Throwable)renderingProblem);
                        throw e2;
                    }
                }
                if (!this.listener.featureRendered && (totalFeatures = -1) != -1 && totalFeatures > 0) {
                    this.getContext().setStatusMessage(Messages.BasicFeatureRenderer_noFeatures);
                }
                monitor.done();
            }
        }
    }

    protected GTRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new StreamingRenderer();
            HashMap<String, Boolean> rendererHints = new HashMap<String, Boolean>();
            rendererHints.put("optimizedDataLoadingEnabled", true);
            this.renderer.setRendererHints(rendererHints);
            this.renderer.addRenderListener((RenderListener)this.listener);
        }
        this.renderer.setMapContent(this.map);
        return this.renderer;
    }

    public static ReferencedEnvelope validateBounds(ReferencedEnvelope viewBounds, IProgressMonitor monitor, IRenderContext context) throws IOException, FactoryException, RenderException {
        if (viewBounds == null) {
            viewBounds = context.getImageBounds();
        }
        CoordinateReferenceSystem viewCRS = context.getCRS();
        ReferencedEnvelope layerBounds = context.getLayer().getBounds(monitor, viewCRS);
        if (layerBounds == null || layerBounds.isNull() || layerBounds.isEmpty()) {
            return context.getImageBounds();
        }
        if (layerBounds.getCoordinateReferenceSystem() == viewBounds.getCoordinateReferenceSystem() && layerBounds.intersects((BoundingBox)viewBounds)) {
            ReferencedEnvelope screen = new ReferencedEnvelope((Envelope)viewBounds, viewCRS);
            return screen;
        }
        try {
            ReferencedEnvelope crsBounds = ReferencedEnvelopeCache.getReferencedEnvelope((CoordinateReferenceSystem)viewCRS);
            if (crsBounds.isEmpty() || crsBounds.isNull()) {
                return context.getImageBounds();
            }
            ReferencedEnvelope maxBounds = crsBounds.transform(viewCRS, true, 10);
            if (maxBounds.getCoordinateReferenceSystem() == viewBounds.getCoordinateReferenceSystem() && maxBounds.intersects((BoundingBox)viewBounds)) {
                ReferencedEnvelope clip = new ReferencedEnvelope(maxBounds.intersection((Envelope)viewBounds), viewCRS);
                return clip;
            }
            return new ReferencedEnvelope(viewCRS);
        }
        catch (TransformException transformException) {
            return new ReferencedEnvelope((Envelope)viewBounds, viewCRS);
        }
    }

    public void refreshImage() {
        try {
            this.render(ProgressManager.instance().get(new Object[0]));
        }
        catch (RenderException e) {
            this.getContext().setStatus(2);
            if (e.getCause() != null) {
                this.getContext().setStatusMessage(String.valueOf(e.getLocalizedMessage()) + " - " + e.getLocalizedMessage());
            }
            this.getContext().setStatusMessage(e.getLocalizedMessage());
        }
    }

    private class BasicRenderListener
    implements RenderListener {
        IProgressMonitor monitor;
        Exception exception;
        int exceptionCount = 0;
        boolean featureRendered = false;
        int count = 0;
        long lastUpdate;
        private static final int UPDATE_INTERVAL = 3000;

        private BasicRenderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void featureRenderer(SimpleFeature feature) {
            if (!this.featureRendered) {
                this.featureRendered = true;
            }
            ++this.count;
            IProgressMonitor iProgressMonitor = this.monitor;
            synchronized (iProgressMonitor) {
                if (this.monitor.isCanceled()) {
                    BasicFeatureRenderer.this.getRenderer().stopRendering();
                }
            }
            long current = System.currentTimeMillis();
            if (current - this.lastUpdate > 3000L) {
                this.lastUpdate = current;
                BasicFeatureRenderer.this.setState(2);
            }
        }

        public void errorOccurred(Exception e) {
            if (e != null) {
                if (e.getMessage() != null && (e.getMessage().toLowerCase().contains("timeout") || e.getMessage().toLowerCase().contains("time-out") || e.getMessage().toLowerCase().contains("timed out"))) {
                    this.exception = new Exception(Messages.BasicFeatureRenderer_request_timed_out);
                    if (BasicFeatureRenderer.this.getRenderer() != null) {
                        BasicFeatureRenderer.this.getRenderer().stopRendering();
                    }
                }
                if (e instanceof IOException) {
                    if (BasicFeatureRenderer.this.getRenderer() != null) {
                        BasicFeatureRenderer.this.getRenderer().stopRendering();
                    }
                    this.exception = e;
                }
                ProjectPlugin.log((String)(String.valueOf(BasicFeatureRenderer.this.getContext().getLayer().getName()) + " rendering error:" + e), (Throwable)e);
                e.printStackTrace();
            }
            if (this.exceptionCount > 500 && BasicFeatureRenderer.this.getRenderer() != null) {
                BasicFeatureRenderer.this.getRenderer().stopRendering();
            }
            this.exception = e;
            ++this.exceptionCount;
        }

        public void init(IProgressMonitor monitor) {
            this.lastUpdate = System.currentTimeMillis();
            this.monitor = monitor;
            this.exception = null;
            this.exceptionCount = 0;
            this.featureRendered = false;
            this.count = 0;
        }
    }
}

