/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.feature.basic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.core.MinMaxScaleCalculator;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.render.internal.feature.basic.BasicFeatureMetricsFactory;
import net.refractions.udig.render.internal.feature.basic.BasicFeatureRenderer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.geotools.styling.Style;
import org.geotools.util.Range;

public class BasicFeatureMetrics
extends AbstractRenderMetrics {
    protected static List<String> listExpectedStyleIds() {
        ArrayList<String> styleIds = new ArrayList<String>();
        styleIds.add("net.refractions.udig.style.sld");
        styleIds.add("net.refractions.udig.project.view");
        styleIds.add("net.refractions.udig.style.filter");
        styleIds.add("net.refractions.udig.style.cache");
        return styleIds;
    }

    public BasicFeatureMetrics(IRenderContext context, BasicFeatureMetricsFactory factory) {
        super(context, (IRenderMetricsFactory)factory, BasicFeatureMetrics.listExpectedStyleIds());
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        boolean antiAliasing = store.getBoolean("antiAliasingPreference");
        this.resolutionMetric = antiAliasing ? 0.5 : 1.0;
        ID id = context.getGeoResource().getID();
        Boolean memory = (Boolean)context.getLayer().getStyleBlackboard().get("net.refractions.udig.style.cache");
        if (id.isMemory()) {
            this.latencyMetric = 0L;
            this.timeToDrawMetric = 400L;
        } else if (Boolean.TRUE.equals(memory)) {
            this.latencyMetric = 100L;
            this.timeToDrawMetric = 400L;
        } else if (id.isFile()) {
            this.latencyMetric = 200L;
            this.timeToDrawMetric = 600L;
        } else if (id.isJDBC() || id.isWFS()) {
            this.latencyMetric = 500L;
            this.timeToDrawMetric = 600L;
        }
    }

    public Renderer createRenderer() {
        BasicFeatureRenderer renderer = new BasicFeatureRenderer();
        renderer.setContext(this.context);
        renderer.setName(this.context.getLayer().getName());
        return renderer;
    }

    public boolean canStyle(String SyleID, Object value) {
        return value != null && value instanceof Style;
    }

    public Set<Range<Double>> getValidScaleRanges() {
        Object value = this.context.getLayer().getStyleBlackboard().get("net.refractions.udig.style.sld");
        if (value == null) {
            return new HashSet<Range<Double>>();
        }
        if (value instanceof Style) {
            Style style = (Style)value;
            return MinMaxScaleCalculator.getValidScaleRanges((Style)style);
        }
        System.out.println("Unexpected " + value.getClass() + " for " + "net.refractions.udig.style.sld" + ":" + value);
        return new HashSet<Range<Double>>();
    }
}

