/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.jdbc.VirtualTableParameter;
import org.geotools.util.logging.Logging;

public class VirtualTable
implements Serializable {
    static final Logger LOGGER = Logging.getLogger(VirtualTable.class);
    String name;
    String sql;
    List<String> primaryKeyColumns = new CopyOnWriteArrayList<String>();
    Map<String, Class<? extends Geometry>> geometryTypes = new ConcurrentHashMap<String, Class<? extends Geometry>>();
    Map<String, Integer> nativeSrids = new ConcurrentHashMap<String, Integer>();
    Map<String, VirtualTableParameter> parameters = new ConcurrentHashMap<String, VirtualTableParameter>();

    public VirtualTable(String name, String sql) {
        this.name = name;
        this.sql = sql;
    }

    public VirtualTable(String name, VirtualTable other) {
        this.name = name;
        this.sql = other.sql;
        this.geometryTypes = new ConcurrentHashMap<String, Class<? extends Geometry>>(other.geometryTypes);
        this.nativeSrids = new ConcurrentHashMap<String, Integer>(other.nativeSrids);
        this.parameters = new ConcurrentHashMap<String, VirtualTableParameter>(other.parameters);
        this.primaryKeyColumns = new ArrayList<String>(other.primaryKeyColumns);
    }

    public VirtualTable(VirtualTable other) {
        this.name = other.name;
        this.sql = other.sql;
        this.geometryTypes = new ConcurrentHashMap<String, Class<? extends Geometry>>(other.geometryTypes);
        this.nativeSrids = new ConcurrentHashMap<String, Integer>(other.nativeSrids);
        this.parameters = new ConcurrentHashMap<String, VirtualTableParameter>(other.parameters);
        this.primaryKeyColumns = new ArrayList<String>(other.primaryKeyColumns);
    }

    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void setPrimaryKeyColumns(List<String> primaryKeyColumns) {
        this.primaryKeyColumns.clear();
        if (primaryKeyColumns != null) {
            this.primaryKeyColumns.addAll(primaryKeyColumns);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSql() {
        return this.sql;
    }

    public String expandParameters(Hints hints) throws SQLException {
        if (this.parameters.size() == 0) {
            return this.sql;
        }
        Map values = null;
        if (hints != null) {
            values = (Map)hints.get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
        }
        if (values == null) {
            values = Collections.emptyMap();
        }
        String result = this.sql;
        for (VirtualTableParameter param : this.parameters.values()) {
            String value = (String)values.get(param.getName());
            if (value == null) {
                value = param.getDefaultValue();
                if (value == null) {
                    value = "";
                }
            } else if (param.getValidator() != null) {
                try {
                    param.getValidator().validate(value);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.SEVERE, "Invalid value for parameter " + param.getName(), e);
                    throw new SQLException("Invalid value for parameter " + param.getName());
                }
            }
            result = result.replace("%" + param.getName() + "%", value);
        }
        return result;
    }

    public void addGeometryMetadatata(String geometry, Class<? extends Geometry> binding, int nativeSrid) {
        this.geometryTypes.put(geometry, binding);
        this.nativeSrids.put(geometry, nativeSrid);
    }

    public void addParameter(VirtualTableParameter param) {
        this.parameters.put(param.getName(), param);
    }

    public void removeParameter(String paramName) {
        this.parameters.remove(paramName);
    }

    public Collection<String> getParameterNames() {
        return new ArrayList<String>(this.parameters.keySet());
    }

    public VirtualTableParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public Class<? extends Geometry> getGeometryType(String geometryName) {
        return this.geometryTypes.get(geometryName);
    }

    public Set<String> getGeometries() {
        return this.geometryTypes.keySet();
    }

    public int getNativeSrid(String geometryName) {
        Integer srid = this.nativeSrids.get(geometryName);
        if (srid == null) {
            srid = -1;
        }
        return srid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.geometryTypes == null ? 0 : ((Object)this.geometryTypes).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nativeSrids == null ? 0 : ((Object)this.nativeSrids).hashCode());
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.primaryKeyColumns == null ? 0 : ((Object)this.primaryKeyColumns).hashCode());
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualTable other = (VirtualTable)obj;
        if (this.geometryTypes == null ? other.geometryTypes != null : !((Object)this.geometryTypes).equals(other.geometryTypes)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nativeSrids == null ? other.nativeSrids != null : !((Object)this.nativeSrids).equals(other.nativeSrids)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        if (this.primaryKeyColumns == null ? other.primaryKeyColumns != null : !((Object)this.primaryKeyColumns).equals(other.primaryKeyColumns)) {
            return false;
        }
        return !(this.sql == null ? other.sql != null : !this.sql.equals(other.sql));
    }

    public String toString() {
        return "VirtualTable [name=" + this.name + ", sql=" + this.sql + "]";
    }
}

