/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentState;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.PrimaryKey;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;

public class JDBCUpdateFeatureWriter
extends JDBCFeatureReader
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    JDBCFeatureReader.ResultSetFeature last;
    ReferencedEnvelope lastBounds;

    public JDBCUpdateFeatureWriter(String sql, Connection cx, JDBCFeatureSource featureSource, Hints hints) throws SQLException, IOException {
        super(sql, cx, featureSource, featureSource.getSchema(), hints);
        this.last = new JDBCFeatureReader.ResultSetFeature(this.rs, cx);
    }

    public JDBCUpdateFeatureWriter(PreparedStatement ps, Connection cx, JDBCFeatureSource featureSource, Hints hints) throws SQLException, IOException {
        super(ps, cx, featureSource, featureSource.getSchema(), hints);
        this.last = new JDBCFeatureReader.ResultSetFeature(this.rs, ps.getConnection());
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        this.ensureNext();
        try {
            this.last.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.next = null;
        if (this.featureSource.getEntry().getState(this.tx).hasListener()) {
            this.lastBounds = new ReferencedEnvelope(this.last.getBounds());
        }
        return this.last;
    }

    @Override
    public void remove() throws IOException {
        try {
            this.dataStore.delete(this.featureType, this.last.getID(), this.st.getConnection());
            ContentEntry entry = this.featureSource.getEntry();
            ContentState state = entry.getState(this.tx);
            if (state.hasListener()) {
                state.fireFeatureRemoved((FeatureSource)((Object)this.featureSource), (Feature)this.last);
            }
        }
        catch (SQLException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public void write() throws IOException {
        try {
            PrimaryKey key = this.dataStore.getPrimaryKey(this.featureType);
            String fid = this.dataStore.encodeFID(key, this.rs);
            Id filter = this.dataStore.getFilterFactory().id(Collections.singleton(this.dataStore.getFilterFactory().featureId(fid)));
            ArrayList<AttributeDescriptor> changed = new ArrayList<AttributeDescriptor>();
            ArrayList<Object> values = new ArrayList<Object>();
            for (AttributeDescriptor att : this.featureType.getAttributeDescriptors()) {
                if (!this.last.isDirrty(att.getLocalName())) continue;
                changed.add(att);
                values.add(this.last.getAttribute(att.getLocalName()));
            }
            this.dataStore.update(this.featureType, changed, values, (Filter)filter, this.st.getConnection());
            ContentEntry entry = this.featureSource.getEntry();
            ContentState state = entry.getState(this.tx);
            if (state.hasListener()) {
                state.fireFeatureUpdated((FeatureSource)((Object)this.featureSource), (Feature)this.last, this.lastBounds);
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.last != null) {
            this.last.close();
            this.last = null;
        }
    }
}

