/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Iterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.Filters;
import org.geotools.filter.LogicFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;

public class SQLUnpacker {
    private FilterPair pair;
    private FilterCapabilities capabilities;
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public SQLUnpacker(FilterCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void unPackAND(Filter filter) {
        this.pair = this.doUnPack(filter, (short)2);
    }

    public void unPackOR(Filter filter) {
        this.pair = this.doUnPack(filter, (short)1);
    }

    public Filter getUnSupported() {
        return this.pair.getUnSupported();
    }

    public Filter getSupported() {
        return this.pair.getSupported();
    }

    private FilterPair doUnPack(Filter filter, short splitType) {
        Filter subSup = null;
        Filter subUnSup = null;
        Filter retSup = null;
        Filter retUnSup = null;
        if (filter == null) {
            return new FilterPair(null, null);
        }
        if (this.capabilities.fullySupports(filter)) {
            retSup = filter;
        } else {
            short type = Filters.getFilterType((Filter)filter);
            if (type == splitType && this.capabilities.supports(splitType)) {
                Iterator filters = ((LogicFilter)filter).getFilterIterator();
                while (filters.hasNext()) {
                    Filter next = (Filter)filters.next();
                    FilterPair subPair = this.doUnPack(next, splitType);
                    subSup = subPair.getSupported();
                    subUnSup = subPair.getUnSupported();
                    retSup = this.combineFilters(retSup, subSup, splitType);
                    retUnSup = this.combineFilters(retUnSup, subUnSup, splitType);
                }
            } else if (type == 3 && this.capabilities.supports((short)3)) {
                Iterator filters = ((LogicFilter)filter).getFilterIterator();
                FilterPair subPair = this.doUnPack((Filter)filters.next(), splitType);
                subSup = subPair.getSupported();
                subUnSup = subPair.getUnSupported();
                if (subSup != null) {
                    retSup = this.ff.not(subSup);
                }
                if (subUnSup != null) {
                    retUnSup = this.ff.not(subUnSup);
                }
            } else {
                retUnSup = filter;
            }
        }
        FilterPair retPair = new FilterPair(retSup, retUnSup);
        return retPair;
    }

    private Filter combineFilters(Filter filter1, Filter filter2, short splitType) {
        Object retFilter = filter1 != null ? (filter2 != null ? (splitType == 2 ? Filters.and((FilterFactory)this.ff, (Filter)filter1, (Filter)filter2) : Filters.or((FilterFactory)this.ff, (Filter)filter1, (Filter)filter2)) : filter1) : (filter2 != null ? filter2 : null);
        return retFilter;
    }

    private class FilterPair {
        private Filter supported;
        private Filter unSupported;

        public FilterPair(Filter supported, Filter unSupported) {
            this.supported = supported;
            this.unSupported = unSupported;
        }

        public Filter getSupported() {
            return this.supported;
        }

        public Filter getUnSupported() {
            return this.unSupported;
        }
    }
}

