/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.pdf;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.BoundsStrategy;
import net.refractions.udig.project.ui.SelectionStyle;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.wizard.export.image.Image2Pdf;
import net.refractions.udig.project.ui.wizard.export.image.ImageExportPage;
import net.refractions.udig.project.ui.wizard.export.image.MapSelectorPageWithScaleColumn;
import net.refractions.udig.project.ui.wizard.export.image.PDFImageExportFormat;
import net.refractions.udig.project.ui.wizard.export.image.Paper;
import net.refractions.udig.project.ui.wizard.export.image.XAffineTransform;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.XMLMemento;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class SivecoExportMapToImageWizard
extends Wizard
implements IExportWizard {
    public static final String DIRECTORY_KEY = "exportDirectoryKey";
    public static final String FORMAT_KEY = "exportFormatKey";
    public static final String WIDTH_KEY = "widthKey";
    public static final String HEIGHT_KEY = Messages.ExportMapToImageWizard_3;
    public static final String SELECTION = "SELECTION_HANDLING";
    private static final String FEATURE_ID_KEY = "FEATURE_ID";
    private ImageExportPage imageSettingsPage = new ImageExportPage();
    private MapSelectorPageWithScaleColumn mapSelectorPage = new MapSelectorPageWithScaleColumn("Map Select", null, null);

    public SivecoExportMapToImageWizard() {
        this.setWindowTitle(Messages.ExportMapToImageWizard_windowtitle);
        this.setDialogSettings(ProjectUIPlugin.getDefault().getDialogSettings());
        this.addPage((IWizardPage)this.mapSelectorPage);
        this.addPage((IWizardPage)this.imageSettingsPage);
        this.setNeedsProgressMonitor(true);
    }

    public static void exportSivecoMap(IMap map, int dpi, Paper paper, File dest, SelectionStyle selectionStyle, IProgressMonitor monitor) throws RenderException, IOException, TransformException, NoninvertibleTransformException {
        if (map == null) {
            throw new IllegalArgumentException("map must not be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        if (dpi <= 0) {
            throw new IllegalArgumentException("dpi must be > 0");
        }
        if (paper == null) {
            throw new IllegalArgumentException("paper must not be null");
        }
        monitor.beginTask(Messages.ExportMapToImageWizard_RenderingTaskName, 3);
        String pattern = Messages.ExportMapToImageWizard_preparingTaskName;
        Object[] args = new Object[]{map.getName()};
        monitor.setTaskName(MessageFormat.format(pattern, args));
        Dimension contentDim = new Dimension(paper.getPixelWidth(true, dpi) - 20, paper.getPixelHeight(true, dpi) - 20);
        BufferedImage image = new BufferedImage(contentDim.width, contentDim.height, 2);
        Graphics2D g = image.createGraphics();
        try {
            monitor.worked(1);
            pattern = Messages.ExportMapToImageWizard_renderingTaskname;
            args = new Object[]{map.getName()};
            monitor.setTaskName(MessageFormat.format(pattern, args));
            int scaleDenom = MapSelectorPageWithScaleColumn.getScaleDenom((IMap)map);
            BoundsStrategy boundsStrategy = new BoundsStrategy((double)scaleDenom);
            Map mapCopy = (Map)ApplicationGIS.copyMap((IMap)map);
            List layersInternal = mapCopy.getLayersInternal();
            List<Layer> mapGraphics = SivecoExportMapToImageWizard.prepareMapGraphics(mapCopy, contentDim, monitor);
            layersInternal.addAll(mapGraphics);
            ApplicationGIS.DrawMapParameter drawMapParameter = new ApplicationGIS.DrawMapParameter(g, new Dimension(contentDim.width, contentDim.height), (IMap)mapCopy, boundsStrategy, dpi, selectionStyle, monitor);
            ApplicationGIS.drawMap((ApplicationGIS.DrawMapParameter)drawMapParameter);
        }
        finally {
            g.dispose();
        }
        monitor.worked(1);
        pattern = Messages.ExportMapToImageWizard_writingTaskname;
        args = new Object[]{map.getName()};
        monitor.setTaskName(MessageFormat.format(pattern, args));
        Image2Pdf.write((BufferedImage)image, (String)dest.getAbsolutePath(), (Paper)paper, (int)10, (int)10, (boolean)true, (int)dpi);
        monitor.done();
    }

    public boolean performFinish() {
        final ArrayList errors = new ArrayList();
        final ArrayList renderedMaps = new ArrayList();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Collection maps = SivecoExportMapToImageWizard.this.mapSelectorPage.getMaps();
                    monitor.beginTask(Messages.ExportMapToImageWizard_exportMapsTaskName, maps.size() * 3 + 1);
                    monitor.worked(1);
                    for (IMap map : maps) {
                        try {
                            SivecoExportMapToImageWizard.this.exportMap(map, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                        }
                        catch (RenderException e) {
                            Object[] args = new Object[]{map.getName(), e.getLocalizedMessage()};
                            String pattern = Messages.ExportMapToImageWizard_renderingErrorMessage;
                            errors.add(MessageFormat.format(pattern, args));
                        }
                        catch (IOException e) {
                            errors.add(String.valueOf(Messages.ExportMapToImageWizard_ioexceptionErrorMessage) + e.getLocalizedMessage());
                        }
                        catch (TransformException transformException) {
                            errors.add("Failed to create world file.  This image can not be used as a Raster file in uDig");
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            errors.add("Failed to create world file.  This image can not be used as a Raster file in uDig");
                        }
                        renderedMaps.add(map);
                    }
                    SivecoExportMapToImageWizard.this.mapSelectorPage.getMaps().remove(renderedMaps);
                    SivecoExportMapToImageWizard.this.mapSelectorPage.updateMapList();
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (!errors.isEmpty()) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(String.valueOf(Messages.ExportMapToImageWizard_ShowErrorMessage) + (String)errors.iterator().next());
            return false;
        }
        this.getDialogSettings().put(DIRECTORY_KEY, this.mapSelectorPage.getExportDir().getAbsolutePath());
        this.getDialogSettings().put(FORMAT_KEY, this.imageSettingsPage.getFormat().getName());
        return true;
    }

    private void exportMap(IMap map, IProgressMonitor monitor) throws RenderException, IOException, TransformException, NoninvertibleTransformException {
        IMap renderedMap;
        if (this.imageSettingsPage.isPDF()) {
            SivecoExportMapToImageWizard.exportSivecoMap(map, this.imageSettingsPage.getFormat().getDPI(), ((PDFImageExportFormat)this.imageSettingsPage.getFormat()).paper(), this.determineDestinationFile(map), this.imageSettingsPage.getSelectionHandling(), monitor);
            return;
        }
        monitor.beginTask(Messages.ExportMapToImageWizard_RenderingTaskName, 3);
        String pattern = Messages.ExportMapToImageWizard_preparingTaskName;
        Object[] args = new Object[]{map.getName()};
        monitor.setTaskName(MessageFormat.format(pattern, args));
        File destination = this.determineDestinationFile(map);
        if (destination == null) {
            return;
        }
        double mapheight = map.getViewportModel().getHeight();
        double mapwidth = map.getViewportModel().getWidth();
        int width = this.imageSettingsPage.getWidth(mapwidth, mapheight);
        int height = this.imageSettingsPage.getHeight(mapwidth, mapheight);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        try {
            monitor.worked(1);
            pattern = Messages.ExportMapToImageWizard_renderingTaskname;
            args = new Object[]{map.getName()};
            monitor.setTaskName(MessageFormat.format(pattern, args));
            int scaleDenom = MapSelectorPageWithScaleColumn.getScaleDenom((IMap)map);
            BoundsStrategy boundsStrategy = new BoundsStrategy((double)scaleDenom);
            Map mapCopy = (Map)ApplicationGIS.copyMap((IMap)map);
            ApplicationGIS.DrawMapParameter drawMapParameter = new ApplicationGIS.DrawMapParameter(g, new Dimension(width, height), (IMap)mapCopy, boundsStrategy, this.imageSettingsPage.getFormat().getDPI(), this.imageSettingsPage.getSelectionHandling(), monitor);
            renderedMap = ApplicationGIS.drawMap((ApplicationGIS.DrawMapParameter)drawMapParameter);
        }
        finally {
            g.dispose();
        }
        monitor.worked(1);
        pattern = Messages.ExportMapToImageWizard_writingTaskname;
        args = new Object[]{map.getName()};
        monitor.setTaskName(MessageFormat.format(pattern, args));
        this.imageSettingsPage.getFormat().write(renderedMap, image, destination);
        String baseFile = destination.getPath().substring(0, destination.getPath().lastIndexOf("."));
        this.createWorldFile(renderedMap.getViewportModel().worldToScreenTransform().createInverse(), baseFile);
        this.createProjectionFile(baseFile, renderedMap.getViewportModel().getCRS());
        this.addToCatalog(destination);
        monitor.done();
    }

    private static List<Layer> prepareMapGraphics(Map map, Dimension contentDim, IProgressMonitor monitor) {
        ArrayList<Layer> mapGraphics = new ArrayList<Layer>();
        Rectangle whiteboxLoc = new Rectangle((int)((double)contentDim.width - (double)contentDim.width * 0.25), 0, contentDim.width, contentDim.height);
        Layer whiteboxLayer = SivecoExportMapToImageWizard.createWhitebox(map, whiteboxLoc);
        mapGraphics.add(whiteboxLayer);
        Rectangle titleAreaBox = new Rectangle(whiteboxLoc.x, whiteboxLoc.y, whiteboxLoc.width, (int)((double)whiteboxLoc.height * 0.25));
        Layer titleAreaLayer = SivecoExportMapToImageWizard.createTitleArea(map, titleAreaBox, monitor);
        mapGraphics.add(titleAreaLayer);
        return mapGraphics;
    }

    private static Layer createWhitebox(Map map, Rectangle location) {
        try {
            ICatalog localCatalog = CatalogPlugin.getDefault().getLocalCatalog();
            LayerFactory layerFactory = map.getLayerFactory();
            URL resourceID = new URL(null, "mapgraphic://localhost/mapgraphic#net.refractions.udig.tutorial.mapgraphic.Whitebox", CorePlugin.RELAXED_HANDLER);
            ID id = new ID(resourceID);
            IGeoResource resource = (IGeoResource)localCatalog.getById(IGeoResource.class, id, (IProgressMonitor)new NullProgressMonitor());
            Layer whiteboxLayer = layerFactory.createLayer(resource);
            whiteboxLayer.getStyleBlackboard().put("net.refractions.udig.printing.ui.locationStyle", (Object)location);
            return whiteboxLayer;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create whitebox", e);
        }
    }

    protected static Layer createTitleArea(Map map, Rectangle location, IProgressMonitor monitor) {
        try {
            ICatalog localCatalog = CatalogPlugin.getDefault().getLocalCatalog();
            List layersInternal = map.getLayersInternal();
            LayerFactory layerFactory = map.getLayerFactory();
            Iterator layerIterator = layersInternal.iterator();
            Layer farmParcelLayer = null;
            while (layerIterator.hasNext()) {
                Layer layer = (Layer)layerIterator.next();
                if (!layer.getName().equals("SDE.DATE_PRIMARE")) continue;
                farmParcelLayer = layer;
            }
            if (farmParcelLayer == null) {
                throw new IllegalStateException("cannot find farm layer");
            }
            Filter farmParcelFilter = farmParcelLayer.getFilter();
            DefaultQuery query = new DefaultQuery(farmParcelLayer.getSchema().getTypeName(), farmParcelFilter, new String[0]);
            FeatureSource featureSource = (FeatureSource)farmParcelLayer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            FeatureCollection features = featureSource.getFeatures((Query)query);
            FeatureIterator featureIterator = features.features();
            if (!featureIterator.hasNext()) {
                throw new IllegalStateException("At least one feature must be selected in the farm layer. " + features.size() + " found.");
            }
            SimpleFeature selectedFarmFeature = (SimpleFeature)featureIterator.next();
            String cfr_ignored_0 = (String)selectedFarmFeature.getAttribute(0);
            String id = (String)selectedFarmFeature.getAttribute(1);
            URL detailsResId = new URL(null, "mapgraphic://localhost/mapgraphic#net.refractions.udig.tutorial.mapgraphic.TitleArea", CorePlugin.RELAXED_HANDLER);
            IGeoResource detailsRes = (IGeoResource)localCatalog.getById(IGeoResource.class, new ID(detailsResId), (IProgressMonitor)new NullProgressMonitor());
            Layer titleAreaLayer = layerFactory.createLayer(detailsRes);
            titleAreaLayer.getStyleBlackboard().put("net.refractions.udig.printing.ui.locationStyle", (Object)location);
            XMLMemento selectedFeatureMemento = XMLMemento.createWriteRoot((String)"style");
            selectedFeatureMemento.putString(FEATURE_ID_KEY, id);
            titleAreaLayer.getStyleBlackboard().put("net.refractions.udig.style.dialogSettings", (Object)selectedFeatureMemento);
            return titleAreaLayer;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create title area", e);
        }
    }

    private void addToCatalog(File destination) throws MalformedURLException {
        IServiceFactory serviceFactory = CatalogPlugin.getDefault().getServiceFactory();
        URL url = DataUtilities.fileToURL((File)destination);
        List services = serviceFactory.createService(url);
        ICatalog localCatalog = CatalogPlugin.getDefault().getLocalCatalog();
        for (IService service : services) {
            localCatalog.add(service);
        }
    }

    private void createProjectionFile(String baseFile, CoordinateReferenceSystem coordinateReferenceSystem) throws IOException {
        File prjFile = new File(new StringBuffer(baseFile).append(".prj").toString());
        BufferedWriter out = new BufferedWriter(new FileWriter(prjFile));
        out.write(coordinateReferenceSystem.toWKT());
        out.close();
    }

    private void createWorldFile(AffineTransform gridToWorld, String baseFile) throws IOException, TransformException {
        boolean lonFirst = XAffineTransform.getSwapXY((AffineTransform)gridToWorld) != -1;
        double xPixelSize = lonFirst ? gridToWorld.getScaleX() : gridToWorld.getShearY();
        double rotation1 = lonFirst ? gridToWorld.getShearX() : gridToWorld.getScaleX();
        double rotation2 = lonFirst ? gridToWorld.getShearY() : gridToWorld.getScaleY();
        double yPixelSize = lonFirst ? gridToWorld.getScaleY() : gridToWorld.getShearX();
        double xLoc = gridToWorld.getTranslateX();
        double yLoc = gridToWorld.getTranslateY();
        StringBuffer buff = new StringBuffer(baseFile);
        buff.append(".wld");
        File worldFile = new File(buff.toString());
        PrintWriter out = new PrintWriter(new FileOutputStream(worldFile));
        out.println(xPixelSize);
        out.println(rotation1);
        out.println(rotation2);
        out.println(yPixelSize);
        out.println(xLoc);
        out.println(yLoc);
        out.flush();
        out.close();
    }

    private File determineDestinationFile(IMap map) {
        File exportDir = this.mapSelectorPage.getExportDir();
        File destination = this.addSuffix(new File(exportDir, map.getName()));
        if (destination.exists()) {
            boolean overwrite;
            boolean bl = overwrite = !MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Messages.ExportMapToImageWizard_overwriteWarningTitle, (String)(String.valueOf(Messages.ExportMapToImageWizard_overwriteWarningMessage) + destination.getName()));
            if (!overwrite) {
                if (!destination.delete()) {
                    destination = this.selectFile(destination, Messages.ExportMapToImageWizard_unableToDeleteMsg);
                }
            } else {
                destination = this.selectFile(destination, Messages.ExportMapToImageWizard_selectFileTitle);
            }
        }
        if (destination == null) {
            return null;
        }
        return this.addSuffix(destination);
    }

    private File addSuffix(File file) {
        String extension;
        String path = this.stripEndSlash(file.getPath());
        if (path.endsWith(extension = this.imageSettingsPage.getFormat().getExtension())) {
            return file;
        }
        File destination = new File(String.valueOf(path) + "." + extension);
        return destination;
    }

    private String stripEndSlash(String path) {
        if (path.endsWith("/")) {
            return this.stripEndSlash(path.substring(0, path.length() - 1));
        }
        return path;
    }

    private File selectFile(File destination, String string) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(string);
        dialog.setFilterPath(destination.getParent());
        dialog.setFileName(destination.getName());
        String file = dialog.open();
        destination = file == null ? null : new File(file);
        return destination;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mapSelectorPage.setSelection(selection);
    }
}

