/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.pdf;

import java.util.Map;
import net.refractions.udig.printing.ui.Template;
import net.refractions.udig.printing.ui.TemplateFactory;
import net.refractions.udig.printing.ui.internal.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class PrintWizardPage1
extends WizardPage
implements Listener {
    public static final int CURRENT_MAP_SCALE = 1;
    public static final int CUSTOM_MAP_SCALE = 2;
    public static final int ZOOM_TO_SELECTION = 3;
    protected static final int PREFERRED_HEIGHT = 50;
    private CheckboxTableViewer listViewer;
    private Button exportRasterCheckbox;
    private Combo dpiCombo;
    private Combo pageCombo;
    private Button currentScaleButton;
    private Combo customScaleCombo;
    private Button customScaleButton;
    private Button zoomToSelectionButton;
    Map<String, TemplateFactory> templateFactories;

    public PrintWizardPage1(Map<String, TemplateFactory> templateFactories) {
        super("ExportPDFFromTemplatePage");
        this.setTitle(Messages.PrintWizardPage1_PAGE_TITLE);
        this.setDescription(Messages.PrintWizardPage1_PAGE_DESC);
        this.templateFactories = templateFactories;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createListViewer(composite, true);
        this.createOptionsGroup(composite);
        this.updateUIBasedOnTemplate();
        this.validatePage();
        this.setControl((Control)composite);
    }

    protected void createListViewer(Composite parent, boolean useHeightHint) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = 50;
        }
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.listViewer.setInput(this.templateFactories.values());
        if (this.templateFactories.size() > 0) {
            this.listViewer.setChecked(this.listViewer.getElementAt(0), true);
        }
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] allChecked = PrintWizardPage1.this.listViewer.getCheckedElements();
                int i = 0;
                while (i < allChecked.length) {
                    if (!allChecked[i].equals(event.getElement())) {
                        PrintWizardPage1.this.listViewer.setChecked(allChecked[i], false);
                    }
                    ++i;
                }
                PrintWizardPage1.this.updateUIBasedOnTemplate();
                PrintWizardPage1.this.validatePage();
            }
        });
    }

    private void updateUIBasedOnTemplate() {
        Object[] allChecked = this.listViewer.getCheckedElements();
        if (allChecked.length == 0) {
            return;
        }
        TemplateFactory selectedFactory = (TemplateFactory)allChecked[0];
        Template selectedTemplate = selectedFactory.createTemplate();
        selectedTemplate.getPreferredOrientation();
    }

    private ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((TemplateFactory)element).getName();
            }
        };
    }

    protected void createOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(Messages.PrintWizardPage1_OPTIONS);
        optionsGroup.setFont(parent.getFont());
        this.createOptionsGroupControls(optionsGroup);
    }

    protected void createOptionsGroupControls(Group group) {
        group.getFont();
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(768));
        Composite left = new Composite((Composite)group, 0);
        left.setLayoutData((Object)new GridData(16384, 128, true, false));
        left.setLayout((Layout)new GridLayout(1, false));
        Group scaleGroup = new Group(left, 0);
        scaleGroup.setLayout((Layout)new GridLayout(1, false));
        this.currentScaleButton = new Button((Composite)scaleGroup, 16);
        this.currentScaleButton.setText(Messages.ExportPDFWizardPage1_CURRENT_SCALE);
        this.customScaleButton = new Button((Composite)scaleGroup, 16);
        this.customScaleButton.setText(Messages.ExportPDFWizardPage1_CUSTOM_SCALE);
        Composite customScaleComposite = new Composite((Composite)scaleGroup, 0);
        customScaleComposite.setLayout((Layout)new GridLayout(2, false));
        this.customScaleCombo = new Combo(customScaleComposite, 0);
        this.customScaleCombo.setText("1000");
        this.customScaleCombo.setEnabled(false);
        this.customScaleCombo.addListener(24, (Listener)this);
        this.customScaleCombo.addListener(13, (Listener)this);
        this.zoomToSelectionButton = new Button((Composite)scaleGroup, 16);
        this.zoomToSelectionButton.setText(Messages.ExportPDFWizardPage1_ZOOM_TO_SELECTION);
        this.customScaleButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (PrintWizardPage1.this.currentScaleButton.getSelection()) {
                    PrintWizardPage1.this.customScaleCombo.setEnabled(false);
                } else {
                    PrintWizardPage1.this.customScaleCombo.setEnabled(true);
                }
                PrintWizardPage1.this.validatePage();
            }
        });
        this.currentScaleButton.setSelection(true);
        Composite right = new Composite((Composite)group, 0);
        right.setLayoutData((Object)new GridData(16384, 2, true, false));
        right.setLayout((Layout)new GridLayout(1, false));
        this.exportRasterCheckbox = new Button(right, 16416);
        this.exportRasterCheckbox.setText(Messages.PrintWizardPage1_EXPORT_RASTERS);
        this.exportRasterCheckbox.setSelection(true);
        Composite dpiAndPageComposite = new Composite(right, 0);
        dpiAndPageComposite.setLayoutData((Object)new GridData(16384, 2, true, false));
        dpiAndPageComposite.setLayout((Layout)new GridLayout(2, false));
        Label dpiLabel = new Label(dpiAndPageComposite, 16384);
        dpiLabel.setText(Messages.PrintWizardPage1_DPI);
        this.dpiCombo = new Combo(dpiAndPageComposite, 8);
        this.dpiCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.dpiCombo.setItems(new String[]{"72", "144", "300"});
        this.dpiCombo.setData("0", (Object)72);
        this.dpiCombo.setData("1", (Object)144);
        this.dpiCombo.setData("2", (Object)300);
        this.dpiCombo.select(2);
        Label pageLabel = new Label(dpiAndPageComposite, 16384);
        pageLabel.setText(Messages.PrintWizardPage1_PAGE_SIZE);
        this.pageCombo = new Combo(dpiAndPageComposite, 8);
        this.pageCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.pageCombo.add("A4");
        this.pageCombo.add("A3");
        this.pageCombo.add(Messages.PrintWizardPage1_LETTER_PAGE_SIZE);
        this.pageCombo.select(0);
    }

    protected String getPageSize() {
        return this.pageCombo.getText();
    }

    protected int getDpi() {
        return Integer.valueOf(this.dpiCombo.getText());
    }

    protected int getScaleOption() {
        if (this.currentScaleButton.getSelection()) {
            return 1;
        }
        if (this.customScaleButton.getSelection()) {
            return 2;
        }
        return 3;
    }

    protected float getCustomScale() {
        if (this.getScaleOption() != 2) {
            throw new IllegalStateException(Messages.PrintWizardPage1_1);
        }
        return Float.parseFloat(this.customScaleCombo.getText());
    }

    protected TemplateFactory getTemplateFactory() {
        Object[] elements = this.listViewer.getCheckedElements();
        assert (elements.length == 0 || elements.length == 1);
        if (elements.length == 1) {
            return (TemplateFactory)elements[0];
        }
        return null;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.customScaleCombo) {
            this.validatePage();
        }
    }

    private String getOutputFile(String fbid, String printNum) {
        return "RO_" + fbid + "_yymmdd_" + printNum + ".pdf";
    }

    private boolean validatePage() {
        boolean valid = this.isOneTemplateChecked() && this.isScaleValid();
        this.setPageComplete(valid);
        return valid;
    }

    private boolean isOneTemplateChecked() {
        if (this.listViewer.getCheckedElements().length != 1) {
            this.setMessage(Messages.PrintWizardPage1_SELECT_TEMPLATE);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean getRasterEnabled() {
        return this.exportRasterCheckbox.getSelection();
    }

    public boolean isScaleValid() {
        if (this.currentScaleButton.getSelection()) {
            this.setMessage(null);
            return true;
        }
        try {
            float scale = Float.valueOf(this.customScaleCombo.getText()).floatValue();
            if (scale < 1.0f) {
                this.setErrorMessage(Messages.PrintWizardPage1_INVALID_SCALE);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.PrintWizardPage1_INVALID_SCALE);
            return false;
        }
        this.setMessage(null);
        return true;
    }
}

