/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.pdf;

import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.ModelFactory;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.ui.Template;
import net.refractions.udig.printing.ui.TemplateFactory;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.printing.ui.internal.TemplatePrintingEngine;
import net.refractions.udig.printing.ui.pdf.PrintWizardPage1;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.opengis.coverage.grid.GridCoverageReader;

public class PrintWizard
extends Wizard
implements IExportWizard {
    private net.refractions.udig.project.internal.Map map;
    private PrintWizardPage1 page1;
    private static float MARGIN = 36.0f;

    public PrintWizard() {
        PrintingPlugin plugin = PrintingPlugin.getDefault();
        Map<String, TemplateFactory> templateFactories = plugin.getTemplateFactories();
        this.setWindowTitle(Messages.PrintWizard_Title);
        String key = "wizban/exportpdf_wiz.gif";
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        ImageDescriptor image = imageRegistry.getDescriptor(key);
        if (image == null) {
            URL banURL = plugin.getBundle().getResource("icons/" + key);
            image = ImageDescriptor.createFromURL((URL)banURL);
            imageRegistry.put(key, image);
        }
        IEditorInput input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        this.map = (net.refractions.udig.project.internal.Map)((MapEditorInput)input).getProjectElement();
        this.setDefaultPageImageDescriptor(image);
        this.page1 = new PrintWizardPage1(templateFactories);
        this.addPage((IWizardPage)this.page1);
    }

    public boolean canFinish() {
        return this.page1.isPageComplete();
    }

    public boolean performFinish() {
        Template template = this.page1.getTemplateFactory().createTemplate();
        boolean showRasters = this.page1.getRasterEnabled();
        double currentViewportScaleDenom = this.map.getViewportModel().getScaleDenominator();
        if (currentViewportScaleDenom == -1.0) {
            throw new IllegalStateException("no scale denominator is available from the viewport model");
        }
        if (this.page1.getScaleOption() == 2) {
            float customScale = this.page1.getCustomScale();
            template.setMapScaleHint(customScale);
        } else if (this.page1.getScaleOption() == 1) {
            template.setMapScaleHint(currentViewportScaleDenom);
        } else if (this.page1.getScaleOption() == 3) {
            template.setZoomToSelectionHint(true);
            template.setMapScaleHint(currentViewportScaleDenom);
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = new Paper();
        Rectangle pageSize = this.getITextPageSize(this.page1.getPageSize());
        paper.setSize(pageSize.getWidth(), pageSize.getHeight());
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        pageFormat.setPaper(paper);
        if (this.page1.getTemplateFactory().createTemplate().getPreferredOrientation() == 1) {
            pageFormat.setOrientation(0);
        }
        final String jobName = this.map.getName();
        TemplatePrintingEngine engine = new TemplatePrintingEngine(this.map, template, showRasters);
        printerJob.setPrintable(engine, pageFormat);
        Job job = new Job(Messages.PrintAction_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                if (printerJob.printDialog()) {
                    try {
                        printerJob.setJobName(jobName);
                        printerJob.print();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        if (job.isSystem()) {
            job.setSystem(false);
        }
        job.schedule();
        return true;
    }

    private Rectangle getITextPageSize(String pageSizeName) {
        if (pageSizeName.equals("A3")) {
            return PageSize.A3;
        }
        if (pageSizeName.equals("A4")) {
            return PageSize.A4;
        }
        if (pageSizeName.equals("Letter")) {
            return PageSize.LETTER;
        }
        throw new IllegalArgumentException(String.valueOf(pageSizeName) + " is not a supported page size");
    }

    protected Page makePage(int width, int height) {
        Template template = this.getTemplate();
        net.refractions.udig.project.internal.Map mapCopy = null;
        mapCopy = (net.refractions.udig.project.internal.Map)ApplicationGIS.copyMap((IMap)this.map);
        List layersNoRasters = mapCopy.getLayersInternal();
        if (!this.page1.getRasterEnabled()) {
            ArrayList<Layer> toRemove = new ArrayList<Layer>();
            for (Layer layer : layersNoRasters) {
                for (IGeoResource resource : layer.getGeoResources()) {
                    if (!resource.canResolve(GridCoverageReader.class)) continue;
                    toRemove.add(layer);
                }
            }
            layersNoRasters.removeAll(toRemove);
        }
        if (this.page1.getScaleOption() == 2) {
            float customScale = this.page1.getCustomScale();
            template.setMapScaleHint(customScale);
        } else if (this.page1.getScaleOption() == 1) {
            double currentViewportScaleDenom = this.map.getViewportModel().getScaleDenominator();
            if (currentViewportScaleDenom == -1.0) {
                throw new IllegalStateException("no scale denominator is available from the viewport model");
            }
            template.setMapScaleHint(currentViewportScaleDenom);
        } else if (this.page1.getScaleOption() == 3) {
            template.setZoomToSelectionHint(true);
        }
        Page page = ModelFactory.eINSTANCE.createPage();
        page.setSize(new Dimension(width, height));
        MessageFormat formatter = new MessageFormat(Messages.CreatePageAction_newPageName, Locale.getDefault());
        if (page.getName() == null || page.getName().length() == 0) {
            page.setName(formatter.format(new Object[]{mapCopy.getName()}));
        }
        template.init(page, mapCopy);
        Iterator<Box> iter = template.iterator();
        while (iter.hasNext()) {
            page.getBoxes().add(iter.next());
        }
        return page;
    }

    protected Page makePage2(float width, float height) {
        Template template = this.getTemplate();
        IEditorInput input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        net.refractions.udig.project.internal.Map mapCopy = null;
        net.refractions.udig.project.internal.Map map = (net.refractions.udig.project.internal.Map)((MapEditorInput)input).getProjectElement();
        mapCopy = (net.refractions.udig.project.internal.Map)ApplicationGIS.copyMap((IMap)map);
        if (this.page1.getScaleOption() == 2) {
            float customScale = this.page1.getCustomScale();
            template.setMapScaleHint(customScale);
        } else if (this.page1.getScaleOption() == 1) {
            double currentViewportScaleDenom = map.getViewportModel().getScaleDenominator();
            if (currentViewportScaleDenom == -1.0) {
                throw new IllegalStateException("no scale denominator is available from the viewport model");
            }
            template.setMapScaleHint(currentViewportScaleDenom);
        } else if (this.page1.getScaleOption() == 3) {
            template.setZoomToSelectionHint(true);
        }
        Page page = ModelFactory.eINSTANCE.createPage();
        page.setSize(new Dimension((int)width, (int)height));
        MessageFormat formatter = new MessageFormat(Messages.CreatePageAction_newPageName, Locale.getDefault());
        if (page.getName() == null || page.getName().length() == 0) {
            page.setName(formatter.format(new Object[]{mapCopy.getName()}));
        }
        template.init(page, mapCopy);
        Iterator<Box> iter = template.iterator();
        while (iter.hasNext()) {
            page.getBoxes().add(iter.next());
        }
        return page;
    }

    private Template getTemplate() {
        TemplateFactory templateFactory = this.page1.getTemplateFactory();
        Template template = templateFactory.createTemplate();
        return template;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

