/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.ModelFactory;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.ui.Template;
import net.refractions.udig.printing.ui.TemplateFactory;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.printing.ui.internal.PrintingEngine;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.printing.ui.pdf.ExportPDFWizardConfigBean;
import net.refractions.udig.printing.ui.pdf.ExportPDFWizardPage1;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.command.navigation.SetViewportBBoxCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.BoundsStrategy;
import net.refractions.udig.project.ui.SelectionStyle;
import net.refractions.udig.project.ui.internal.MapEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.opengis.coverage.grid.GridCoverageReader;

public class ExportPDFWizard
extends Wizard
implements IExportWizard {
    private net.refractions.udig.project.internal.Map map;
    private ExportPDFWizardPage1 page1;

    public ExportPDFWizard() {
        PrintingPlugin plugin = PrintingPlugin.getDefault();
        Map<String, TemplateFactory> templateFactories = plugin.getTemplateFactories();
        this.setWindowTitle(Messages.ExportPDFWizard_Title);
        String key = "wizban/exportpdf_wiz.gif";
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        ImageDescriptor image = imageRegistry.getDescriptor(key);
        if (image == null) {
            URL banURL = plugin.getBundle().getResource("icons/" + key);
            image = ImageDescriptor.createFromURL((URL)banURL);
            imageRegistry.put(key, image);
        }
        this.setDefaultPageImageDescriptor(image);
        IEditorInput input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        this.map = (net.refractions.udig.project.internal.Map)((MapEditorInput)input).getProjectElement();
        IBlackboard mapBlackboard = this.map.getBlackboard();
        ExportPDFWizardConfigBean config = (ExportPDFWizardConfigBean)mapBlackboard.get("ExportPDFWizardConfiBean.key");
        this.page1 = new ExportPDFWizardPage1(templateFactories, config);
        this.addPage((IWizardPage)this.page1);
    }

    public boolean canFinish() {
        return this.page1.isPageComplete();
    }

    public boolean performFinish() {
        Rectangle suggestedPageSize = this.getITextPageSize(this.page1.getPageSize());
        Rectangle pageSize = this.rotatePageIfNecessary(suggestedPageSize);
        Document document = new Document(pageSize);
        try {
            String outputFile = String.valueOf(this.page1.getDestinationDir()) + System.getProperty("file.separator") + this.page1.getOutputFile();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outputFile));
            document.open();
            Graphics2D graphics = null;
            Template template = this.getTemplate();
            int i = 0;
            int numPages = 1;
            do {
                template.setActivePage(i);
                PdfContentByte cb = writer.getDirectContent();
                Page page = this.makePage(pageSize, document, template);
                graphics = cb.createGraphics(pageSize.getWidth(), pageSize.getHeight());
                PrintingEngine engine = new PrintingEngine(page);
                PageFormat pageFormat = new PageFormat();
                pageFormat.setOrientation(1);
                Paper awtPaper = new Paper();
                awtPaper.setSize(pageSize.getWidth() * 3.0f, pageSize.getHeight() * 3.0f);
                awtPaper.setImageableArea(0.0, 0.0, pageSize.getWidth(), pageSize.getHeight());
                pageFormat.setPaper(awtPaper);
                engine.print(graphics, pageFormat, 0);
                graphics.dispose();
                document.newPage();
                if (i != 0) continue;
                numPages = template.getNumPages();
            } while (++i < numPages);
            document.close();
            writer.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
        return true;
    }

    private Rectangle getITextPageSize(String pageSizeName) {
        if (pageSizeName.equals("A3")) {
            return PageSize.A3;
        }
        if (pageSizeName.equals("A4")) {
            return PageSize.A4;
        }
        throw new IllegalArgumentException(String.valueOf(pageSizeName) + " is not a supported page size");
    }

    protected Rectangle rotatePageIfNecessary(Rectangle suggestedPageSize) {
        if (suggestedPageSize.getHeight() > suggestedPageSize.getWidth() && this.page1.isLandscape()) {
            float temp = suggestedPageSize.getWidth();
            suggestedPageSize.getHeight();
            return new Rectangle(suggestedPageSize.getHeight(), suggestedPageSize.getWidth());
        }
        return suggestedPageSize;
    }

    protected Page makePage(Rectangle pageSize, Document doc, Template template) {
        net.refractions.udig.project.internal.Map mapOnlyRasterLayers = null;
        net.refractions.udig.project.internal.Map mapNoRasterLayers = null;
        mapNoRasterLayers = (net.refractions.udig.project.internal.Map)ApplicationGIS.copyMap((IMap)this.map);
        List layersNoRasters = mapNoRasterLayers.getLayersInternal();
        ArrayList<Layer> toRemove = new ArrayList<Layer>();
        for (Layer layer : layersNoRasters) {
            for (IGeoResource resource : layer.getGeoResources()) {
                if (!resource.canResolve(GridCoverageReader.class)) continue;
                toRemove.add(layer);
            }
        }
        layersNoRasters.removeAll(toRemove);
        double currentViewportScaleDenom = this.map.getViewportModel().getScaleDenominator();
        if (currentViewportScaleDenom == -1.0) {
            throw new IllegalStateException("no scale denominator is available from the viewport model");
        }
        if (this.page1.getScaleOption() == 2) {
            float customScale = this.page1.getCustomScale();
            template.setMapScaleHint(customScale);
        } else if (this.page1.getScaleOption() == 1) {
            template.setMapScaleHint(currentViewportScaleDenom);
        } else if (this.page1.getScaleOption() == 3) {
            template.setZoomToSelectionHint(true);
            template.setMapScaleHint(currentViewportScaleDenom);
        }
        Page page = ModelFactory.eINSTANCE.createPage();
        page.setSize(new org.eclipse.draw2d.geometry.Dimension((int)pageSize.getWidth(), (int)pageSize.getHeight()));
        MessageFormat formatter = new MessageFormat(Messages.CreatePageAction_newPageName, Locale.getDefault());
        if (page.getName() == null || page.getName().length() == 0) {
            page.setName(formatter.format(new Object[]{mapNoRasterLayers.getName()}));
        }
        template.init(page, mapNoRasterLayers);
        if (this.page1.getRasterEnabled()) {
            mapOnlyRasterLayers = (net.refractions.udig.project.internal.Map)ApplicationGIS.copyMap((IMap)this.map);
            List layersOnlyRasters = mapOnlyRasterLayers.getLayersInternal();
            ArrayList<Layer> toRemove2 = new ArrayList<Layer>();
            for (Layer layer : layersOnlyRasters) {
                for (IGeoResource resource : layer.getGeoResources()) {
                    if (resource.canResolve(GridCoverageReader.class)) continue;
                    toRemove2.add(layer);
                }
            }
            layersOnlyRasters.removeAll(toRemove2);
            SetViewportBBoxCommand cmdBbox = new SetViewportBBoxCommand(mapNoRasterLayers.getViewportModel().getBounds());
            mapOnlyRasterLayers.sendCommandSync((MapCommand)cmdBbox);
            if (layersNoRasters.size() > 0) {
                this.writeRasterLayersOnlyToDocument(mapOnlyRasterLayers, template.getMapBounds(), doc, page.getSize(), mapNoRasterLayers.getViewportModel().getScaleDenominator());
            }
        }
        Iterator<Box> iter = template.iterator();
        while (iter.hasNext()) {
            page.getBoxes().add(iter.next());
        }
        return page;
    }

    private Template getTemplate() {
        TemplateFactory templateFactory = this.page1.getTemplateFactory();
        Template template = templateFactory.createTemplate();
        return template;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private void writeRasterLayersOnlyToDocument(net.refractions.udig.project.internal.Map mapWithRasterLayersOnly, org.eclipse.swt.graphics.Rectangle mapBoundsInTemplate, Document doc, org.eclipse.draw2d.geometry.Dimension pageSize, double currentViewportScaleDenom) {
        int w = mapBoundsInTemplate.width * this.page1.getDpi() / 90;
        int h = mapBoundsInTemplate.height * this.page1.getDpi() / 90;
        BufferedImage imageOfRastersOnly = new BufferedImage(w, h, 1);
        Graphics2D g = imageOfRastersOnly.createGraphics();
        ApplicationGIS.DrawMapParameter drawMapParameter = null;
        double scaleDenom = this.page1.getScaleOption() == 2 ? (double)this.page1.getCustomScale() : currentViewportScaleDenom;
        drawMapParameter = new ApplicationGIS.DrawMapParameter(g, new Dimension(w, h), (IMap)mapWithRasterLayersOnly, new BoundsStrategy(scaleDenom), this.page1.getDpi(), SelectionStyle.EXCLUSIVE_ALL, null);
        try {
            ApplicationGIS.drawMap((ApplicationGIS.DrawMapParameter)drawMapParameter);
            Image img = Image.getInstance((byte[])ExportPDFWizard.bufferedImage2ByteArray(imageOfRastersOnly));
            img.scaleAbsolute((float)mapBoundsInTemplate.width, (float)mapBoundsInTemplate.height);
            int left = mapBoundsInTemplate.x;
            int bottom = pageSize.height - mapBoundsInTemplate.height - mapBoundsInTemplate.y;
            img.setAbsolutePosition((float)left, (float)bottom);
            doc.add((Element)img);
            this.addWhiteMapBorder(img, doc);
        }
        catch (Exception exception) {}
    }

    private void addWhiteMapBorder(Image img, Document doc) {
        try {
            Color color = Color.white;
            int borderWidth = 1;
            BufferedImage bufferedTop = new BufferedImage((int)img.getScaledWidth(), borderWidth, 1);
            Graphics2D g1 = bufferedTop.createGraphics();
            g1.setBackground(color);
            g1.clearRect(0, 0, bufferedTop.getWidth(), bufferedTop.getHeight());
            Image top = Image.getInstance((byte[])ExportPDFWizard.bufferedImage2ByteArray(bufferedTop));
            top.setAbsolutePosition(img.getAbsoluteX(), img.getAbsoluteY() + img.getScaledHeight() - (float)(bufferedTop.getHeight() / 2));
            BufferedImage bufferedBottom = new BufferedImage((int)img.getScaledWidth(), borderWidth, 1);
            Graphics2D g2 = bufferedBottom.createGraphics();
            g2.setBackground(color);
            g2.clearRect(0, 0, bufferedBottom.getWidth(), bufferedBottom.getHeight());
            Image bottom = Image.getInstance((byte[])ExportPDFWizard.bufferedImage2ByteArray(bufferedBottom));
            bottom.setAbsolutePosition(img.getAbsoluteX(), img.getAbsoluteY() - (float)(bufferedTop.getHeight() / 2));
            BufferedImage bufferedLeft = new BufferedImage(borderWidth, (int)img.getScaledHeight(), 1);
            Graphics2D g3 = bufferedLeft.createGraphics();
            g3.setBackground(color);
            g3.clearRect(0, 0, bufferedLeft.getWidth(), bufferedLeft.getHeight());
            Image left = Image.getInstance((byte[])ExportPDFWizard.bufferedImage2ByteArray(bufferedLeft));
            left.setAbsolutePosition(img.getAbsoluteX() - (float)(bufferedLeft.getWidth() / 2), img.getAbsoluteY());
            BufferedImage bufferedRight = new BufferedImage(borderWidth, (int)img.getScaledHeight(), 1);
            Graphics2D g4 = bufferedRight.createGraphics();
            g4.setBackground(color);
            g4.clearRect(0, 0, bufferedRight.getWidth(), bufferedRight.getHeight());
            Image right = Image.getInstance((byte[])ExportPDFWizard.bufferedImage2ByteArray(bufferedRight));
            right.setAbsolutePosition(img.getAbsoluteX() + img.getScaledWidth() - (float)(bufferedRight.getWidth() / 2), img.getAbsoluteY());
            doc.add((Element)top);
            doc.add((Element)bottom);
            doc.add((Element)left);
            doc.add((Element)right);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] bufferedImage2ByteArray(BufferedImage img) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            ImageIO.write((RenderedImage)img, "png", baos);
            baos.flush();
            byte[] result = baos.toByteArray();
            baos.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

