/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.template;

import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.awt.Font;
import net.refractions.udig.legend.ui.LegendGraphic;
import net.refractions.udig.mapgraphic.MapGraphicChooserDialog;
import net.refractions.udig.mapgraphic.scalebar.ScalebarMapGraphic;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.model.ModelFactory;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.model.impl.LabelBoxPrinter;
import net.refractions.udig.printing.model.impl.MapBoxPrinter;
import net.refractions.udig.printing.model.impl.MapGraphicBoxPrinter;
import net.refractions.udig.printing.ui.internal.AbstractTemplate;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractPrinterPageTemplate
extends AbstractTemplate {
    protected static final float UPPER_MARGIN_PERCENT = 3.0f;
    protected static final float BOTTOM_MARGIN_PERCENT = 3.0f;
    protected static final float LEFT_MARGIN_PERCENT = 3.0f;
    protected static final float RIGHT_MARGIN_PERCENT = 3.0f;
    protected static final float MAP_WIDTH_PERCENT = 90.0f;
    protected static final float MAP_HEIGHT_PERCENT = 80.0f;
    protected static final float SCALE_WIDTH_PERCENT = 20.0f;
    protected static final float SCALE_HEIGHT_PERCENT = 5.0f;
    protected static final float LEGEND_WIDTH_PERCENT = 20.0f;
    protected static final float LEGEND_HEIGHT_PERCENT = 15.0f;
    protected static final float TITLE_WIDTH_PERCENT = 90.0f;
    protected static final float TITLE_HEIGHT_PERCENT = 8.0f;
    protected static final float SPACING_PERCENT = 2.0f;
    protected static final int BASEFONT_SIZE = 18;
    protected org.eclipse.swt.graphics.Rectangle mapBounds;
    private Page page;

    @Override
    public void init(Page page, Map map) {
        this.page = page;
        Rectangle paperRectangle = this.getPaperSize();
        Dimension paperSize = new Dimension((int)paperRectangle.getWidth(), (int)paperRectangle.getHeight());
        page.setPaperSize(paperSize);
        this.setPageSizeFromPaperSize(page, paperSize);
        float scaleFactor = (float)page.getSize().width / (float)page.getPaperSize().height;
        int height = page.getSize().height;
        int width = page.getSize().width;
        int xPos = this.getPercentagePieceOf(width, 3.0f);
        int yPos = this.getPercentagePieceOf(height, 3.0f);
        int w = this.getPercentagePieceOf(width, 90.0f);
        int h = this.getPercentagePieceOf(height, 8.0f);
        float scaledSize = 18.0f * (float)paperSize.height / PageSize.A4.getHeight();
        this.addLabelBox(this.formatName(map.getName()), xPos, yPos, w, h, (int)scaledSize, scaleFactor);
        xPos = this.getPercentagePieceOf(width, 3.0f);
        yPos = this.getPercentagePieceOf(height, 11.0f);
        w = this.getPercentagePieceOf(width, 90.0f);
        h = this.getPercentagePieceOf(height, 80.0f);
        this.addMapBox(map, xPos, yPos, w, h, paperSize);
        xPos = this.getPercentagePieceOf(width, 7.0f);
        yPos = this.getPercentagePieceOf(height, 86.0f);
        w = this.getPercentagePieceOf(width, 20.0f);
        h = this.getPercentagePieceOf(height, 5.0f);
        this.addScale(xPos, yPos, w, h);
    }

    private int getPercentagePieceOf(int width, float percent) {
        int res = (int)((float)width * percent / 100.0f);
        return res;
    }

    protected void addScale(int xPos, int yPos, int scaleWidth, int scaleHeight) {
        Box scaleBox = ModelFactory.eINSTANCE.createBox();
        MapGraphicBoxPrinter scale = new MapGraphicBoxPrinter(this.page);
        scale.setMapGraphic(MapGraphicChooserDialog.findResource(ScalebarMapGraphic.class));
        scaleBox.setBoxPrinter((BoxPrinter)scale);
        scaleBox.setID("Scalebar Box");
        scaleBox.setLocation(new Point(xPos, yPos));
        scaleBox.setSize(new Dimension(scaleWidth, scaleHeight));
        this.boxes.add(scaleBox);
    }

    protected abstract Rectangle getPaperSize();

    protected int addLabelBox(String text, int xPos, int yPos, int labelWidth, int labelHeight, int fontSize, float scaleFactor) {
        Box labelBox = ModelFactory.eINSTANCE.createBox();
        labelBox.setSize(new Dimension(labelWidth, labelHeight));
        labelBox.setLocation(new Point(xPos, yPos));
        LabelBoxPrinter labelBoxPrinter = new LabelBoxPrinter(scaleFactor);
        labelBox.setBoxPrinter((BoxPrinter)labelBoxPrinter);
        labelBox.setID("Standard Label");
        labelBoxPrinter.setText(text);
        labelBoxPrinter.setHorizontalAlignment(0x1000000);
        try {
            FontData data = Display.getDefault().getSystemFont().getFontData()[0];
            data.setHeight(fontSize);
            data.setStyle(1);
            Font font = AWTSWTImageUtils.swtFontToAwt((FontData)data);
            labelBoxPrinter.setFont(font);
        }
        catch (Exception exception) {}
        this.boxes.add(labelBox);
        return labelHeight;
    }

    private String formatName(String name) {
        name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        name = name.replaceAll("[_\\s]", " ");
        StringBuilder builder = new StringBuilder();
        int prev = 32;
        int i = 0;
        while (i < name.length()) {
            char current = name.charAt(i);
            if (prev == 32) {
                builder.append(Character.toUpperCase(current));
            } else {
                builder.append(current);
            }
            prev = current;
            ++i;
        }
        return builder.toString();
    }

    protected org.eclipse.swt.graphics.Rectangle addMapBox(Map map, int xPos, int yPos, int mapWidth, int mapHeight, Dimension paperSize) {
        Box mapBox = ModelFactory.eINSTANCE.createBox();
        MapBoxPrinter mapBoxPrinter = new MapBoxPrinter();
        mapBox.setID("Standard Map Box");
        mapBox.setBoxPrinter((BoxPrinter)mapBoxPrinter);
        mapBoxPrinter.setMap((IMap)map);
        org.eclipse.swt.graphics.Rectangle mapBounds = new org.eclipse.swt.graphics.Rectangle(xPos, yPos, mapWidth, mapHeight);
        mapBox.setSize(new Dimension(mapBounds.width, mapBounds.height));
        mapBox.setPaperSize(paperSize);
        mapBox.setLocation(new Point(mapBounds.x, mapBounds.y));
        this.boxes.add(mapBox);
        return mapBounds;
    }

    protected void addLegendBox(int xPos, int yPos, int legendWidth, int legendHeight) {
        Box legendBox = ModelFactory.eINSTANCE.createBox();
        MapGraphicBoxPrinter legend = new MapGraphicBoxPrinter(this.page);
        legend.setMapGraphic(MapGraphicChooserDialog.findResource(LegendGraphic.class));
        legendBox.setBoxPrinter((BoxPrinter)legend);
        legendBox.setID("Legend Box");
        legendBox.setLocation(new Point(xPos, yPos));
        legendBox.setSize(new Dimension(legendWidth, legendHeight));
        this.boxes.add(legendBox);
    }

    @Override
    public String getName() {
        return Messages.Landscape_Template_Name;
    }

    @Override
    public org.eclipse.swt.graphics.Rectangle getMapBounds() throws IllegalStateException {
        if (this.mapBounds == null) {
            throw new IllegalStateException("Please initialize the template before calling this method.");
        }
        return this.mapBounds;
    }

    @Override
    public String getAbbreviation() {
        return this.getName();
    }
}

