/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor.commands;

import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.Connection;
import net.refractions.udig.printing.ui.internal.Messages;
import org.eclipse.gef.commands.Command;

public class ConnectionReconnectCommand
extends Command {
    private Box oldTarget;
    private Box oldSource;
    private Box newTarget;
    private Box newSource;
    private Connection connection;

    public ConnectionReconnectCommand(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(Messages.ConnectionReconnectCommand_error_nullConnection);
        }
        this.connection = connection;
        this.oldSource = connection.getSource();
        this.oldTarget = connection.getTarget();
    }

    public boolean canExecute() {
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        if (this.newSource.equals(this.oldTarget)) {
            return false;
        }
        for (Connection conn : this.newSource.getSourceConnections()) {
            if (!conn.getTarget().equals(this.oldTarget) || conn.equals(this.connection)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTargetReconnection() {
        if (this.newTarget.equals(this.oldSource)) {
            return false;
        }
        for (Connection conn : this.newTarget.getTargetConnections()) {
            if (!conn.getSource().equals(this.oldSource) || conn.equals(this.connection)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.reconnect(this.newSource, this.oldTarget);
        } else if (this.newTarget != null) {
            this.connection.reconnect(this.oldSource, this.newTarget);
        } else {
            throw new IllegalStateException(Messages.ConnectionReconnectCommand_error_unreacheable);
        }
    }

    public void setNewSource(Box connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(Messages.ConnectionReconnectCommand_label_startpoint);
        this.newSource = connectionSource;
        this.newTarget = null;
    }

    public void setNewTarget(Box connectionTarget) {
        if (connectionTarget == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(Messages.ConnectionReconnectCommand_label_endpoint);
        this.newSource = null;
        this.newTarget = connectionTarget;
    }

    public void undo() {
        this.connection.reconnect(this.oldSource, this.oldTarget);
    }
}

