/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor.commands;

import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.Connection;
import net.refractions.udig.printing.model.ModelFactory;
import net.refractions.udig.printing.ui.internal.Messages;
import org.eclipse.gef.commands.Command;

public class ConnectionCreateCommand
extends Command {
    private Box source;
    private Box target;
    private Connection connection;

    public ConnectionCreateCommand(Box source) {
        if (source == null) {
            throw new IllegalArgumentException(Messages.ConnectionCreateCommand_error_sourceNull);
        }
        this.source = source;
    }

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        for (Connection connection : this.source.getSourceConnections()) {
            if (!connection.getTarget().equals(this.target)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        this.connection = ModelFactory.eINSTANCE.createConnection();
        this.connection.setSource(this.source);
        this.connection.setTarget(this.target);
    }

    public void redo() {
        this.connection.reconnect();
    }

    public void setTarget(Box target) {
        if (target == null) {
            throw new IllegalArgumentException(Messages.ConnectionCreateCommand_error_targetNull);
        }
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

