/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import java.awt.Dimension;
import net.refractions.udig.printing.model.AbstractBoxPrinter;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.model.impl.MapBoxPrinter;
import net.refractions.udig.printing.ui.IBoxEditAction;
import net.refractions.udig.printing.ui.internal.editor.parts.BoxPart;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.IViewportModel;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class SetScaleAction
implements IBoxEditAction {
    private BoxPart owner;
    Double scale;

    @Override
    public Command getCommand() {
        final double newScale = this.scale;
        this.scale = null;
        final double oldScale = this.calculateScale();
        return new Command(){

            private void setScale(double scale) {
                SetScaleAction.this.applyNewScale(scale);
            }

            public void execute() {
                this.setScale(newScale);
            }

            public void undo() {
                this.setScale(oldScale);
            }
        };
    }

    @Override
    public void init(BoxPart owner) {
        this.owner = owner;
    }

    private MapBoxPrinter getMapBoxPrinter() {
        return (MapBoxPrinter)this.owner.getBoxPrinter();
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public void perform() {
        this.scale = null;
        double scaleDenominator = this.calculateScale();
        Shell parentShell = Display.getCurrent().getActiveShell();
        if (scaleDenominator < 0.01) {
            MessageDialog.openInformation((Shell)parentShell, (String)"Set Scale", (String)"The map scale cannot be accurately calculated because of the map's projection.\n\nTry Changing the projection of the map");
            return;
        }
        ScaleDialog dialog = new ScaleDialog(parentShell, scaleDenominator);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        this.scale = result == 0 ? Double.valueOf(dialog.getScale()) : Double.valueOf(scaleDenominator);
    }

    private double calculateScale() {
        IViewportModel viewportModel = this.getMapBoxPrinter().getMap().getViewportModel();
        Page page = this.getMapBoxPrinter().getBox().getPage();
        org.eclipse.draw2d.geometry.Dimension pageSize = page.getSize();
        org.eclipse.draw2d.geometry.Dimension paperSize = page.getPaperSize();
        org.eclipse.draw2d.geometry.Dimension mapSize = this.owner.getBoxPrinter().getBox().getSize();
        float mapPaperWidthPoints = (float)paperSize.width * (float)mapSize.width / (float)pageSize.width;
        float mapPaperWidthMeters = AbstractBoxPrinter.point2cm((float)mapPaperWidthPoints) / 100.0f;
        ReferencedEnvelope mapEnvelope = viewportModel.getBounds();
        double mapWorldWidthMeters = mapEnvelope.getWidth();
        double thescale = mapWorldWidthMeters / (double)mapPaperWidthMeters;
        return thescale;
    }

    private void applyNewScale(double scale) {
        ViewportModel viewportModel = this.getMapBoxPrinter().getMap().getViewportModelInternal();
        Page page = this.getMapBoxPrinter().getBox().getPage();
        org.eclipse.draw2d.geometry.Dimension pageSize = page.getSize();
        org.eclipse.draw2d.geometry.Dimension paperSize = page.getPaperSize();
        org.eclipse.draw2d.geometry.Dimension mapSize = this.owner.getBoxPrinter().getBox().getSize();
        float mapPaperWidthPoints = (float)paperSize.width * (float)mapSize.width / (float)pageSize.width;
        float mapPaperWidthMeters = AbstractBoxPrinter.point2cm((float)mapPaperWidthPoints) / 100.0f;
        float mapPaperHeightPoints = (float)paperSize.height * (float)mapSize.height / (float)pageSize.height;
        float mapPaperHeightMeters = AbstractBoxPrinter.point2cm((float)mapPaperHeightPoints) / 100.0f;
        double mapWorldWidthMeters = scale * (double)mapPaperWidthMeters;
        double mapWorldHeightMeters = scale * (double)mapPaperHeightMeters;
        ReferencedEnvelope mapEnvelope = viewportModel.getBounds();
        double centerX = (mapEnvelope.getMaxX() + mapEnvelope.getMinX()) / 2.0;
        double centerY = (mapEnvelope.getMaxY() + mapEnvelope.getMinY()) / 2.0;
        double minX = centerX - mapWorldWidthMeters / 2.0;
        double maxX = centerX + mapWorldWidthMeters / 2.0;
        double minY = centerY - mapWorldHeightMeters / 2.0;
        double maxY = centerY + mapWorldHeightMeters / 2.0;
        viewportModel.setBounds(minX, maxX, minY, maxY);
    }

    private Dimension getDisplaySize() {
        org.eclipse.draw2d.geometry.Dimension gefDim = this.owner.getBoxPrinter().getBox().getSize();
        Dimension size = new Dimension(gefDim.width, gefDim.height);
        return size;
    }

    private static class ScaleDialog
    extends Dialog
    implements Listener {
        private Spinner spinner;
        private double scale;

        protected ScaleDialog(Shell parentShell, double scale) {
            super(parentShell);
            this.scale = scale;
            this.setShellStyle(96);
        }

        protected Point getInitialSize() {
            Point tmp = super.getInitialSize();
            return new Point(200, tmp.y);
        }

        protected Control createContents(Composite parent) {
            this.getShell().setText("Set Scale");
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(1808));
            container.setLayout((Layout)new FillLayout());
            this.spinner = new Spinner(container, 2048);
            this.spinner.setMinimum(1);
            this.spinner.setMaximum(Integer.MAX_VALUE);
            this.spinner.setIncrement(1000);
            this.spinner.setPageIncrement(1000000);
            this.spinner.setSelection((int)this.scale);
            this.spinner.addListener(24, (Listener)this);
            this.spinner.addListener(2, (Listener)this);
            return container;
        }

        public void handleEvent(Event event) {
            if (event.type == 24) {
                this.scale = this.spinner.getSelection();
            } else if (event.type == 2 && (event.keyCode == 13 || event.keyCode == 0x1000050 || event.keyCode == 10)) {
                this.okPressed();
            }
        }

        public double getScale() {
            return this.scale;
        }
    }
}

