/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import java.awt.Color;
import java.awt.Font;
import net.refractions.udig.printing.model.impl.LabelBoxPrinter;
import net.refractions.udig.printing.ui.IBoxEditAction;
import net.refractions.udig.printing.ui.internal.editor.parts.BoxPart;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;

public class SetLabelBoxFontAction
implements IBoxEditAction {
    private BoxPart owner;
    private FontDialog dialog;

    @Override
    public Command getCommand() {
        return new Command(){
            private Font oldFont;
            private Font newFont;
            private RGB oldFontRgb;
            private RGB newFontRgb;
            {
                this.oldFont = SetLabelBoxFontAction.this.getBoxPrinter().getFont();
                this.newFont = AWTSWTImageUtils.swtFontToAwt((FontData)SetLabelBoxFontAction.this.dialog.getFontList()[0]);
                this.oldFontRgb = new RGB(0, 0, 0);
                this.newFontRgb = SetLabelBoxFontAction.this.dialog.getRGB();
            }

            public void execute() {
                SetLabelBoxFontAction.this.getBoxPrinter().setFont(this.newFont);
                if (this.newFontRgb != null) {
                    SetLabelBoxFontAction.this.getBoxPrinter().setFontColor(new Color(this.newFontRgb.red, this.newFontRgb.green, this.newFontRgb.blue));
                }
                SetLabelBoxFontAction.this.owner.refresh();
            }

            public void undo() {
                SetLabelBoxFontAction.this.getBoxPrinter().setFont(this.oldFont);
                SetLabelBoxFontAction.this.getBoxPrinter().setFontColor(new Color(this.oldFontRgb.red, this.oldFontRgb.green, this.oldFontRgb.blue));
            }
        };
    }

    protected LabelBoxPrinter getBoxPrinter() {
        return (LabelBoxPrinter)this.owner.getBoxPrinter();
    }

    @Override
    public void init(BoxPart owner) {
        this.owner = owner;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public void perform() {
        this.dialog = new FontDialog(Display.getCurrent().getActiveShell());
        Font oldFont = this.getBoxPrinter().getFont();
        if (oldFont != null) {
            FontData fData = new FontData(oldFont.getName(), oldFont.getSize(), oldFont.getStyle());
            this.dialog.setFontList(new FontData[]{fData});
            Color fontColor = this.getBoxPrinter().getFontColor();
            if (fontColor != null) {
                RGB rbg = new RGB(fontColor.getRed(), fontColor.getGreen(), fontColor.getBlue());
                this.dialog.setRGB(rbg);
            }
        }
        this.dialog.open();
    }
}

