/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import net.refractions.udig.printing.model.impl.LabelBoxPrinter;
import net.refractions.udig.printing.ui.IBoxEditAction;
import net.refractions.udig.printing.ui.internal.editor.figures.BoxFigure;
import net.refractions.udig.printing.ui.internal.editor.parts.BoxPart;
import net.refractions.udig.printing.ui.internal.editor.parts.LabelCellEditorLocator;
import net.refractions.udig.printing.ui.internal.editor.parts.LabelDirectEditManager;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

public class RenameLabelBox
implements IBoxEditAction {
    private BoxPart owner;
    private String value;
    private boolean disposed = false;

    @Override
    public void perform() {
        this.value = null;
        this.disposed = false;
        BoxFigure nodeFigure = (BoxFigure)this.owner.getFigure();
        LabelDirectEditManager manager = new LabelDirectEditManager((GraphicalEditPart)this.owner, TextCellEditor.class, new LabelCellEditorLocator(nodeFigure), nodeFigure){
            private boolean committing;

            @Override
            protected void initCellEditor() {
                super.initCellEditor();
                Text text = (Text)this.getCellEditor().getControl();
                text.setText(RenameLabelBox.this.getText());
            }

            protected void commit() {
                if (this.committing) {
                    return;
                }
                this.committing = true;
                try {
                    this.eraseFeedback();
                    RenameLabelBox.this.value = (String)this.getCellEditor().getValue();
                }
                finally {
                    this.bringDown();
                    this.committing = false;
                }
            }

            @Override
            protected void bringDown() {
                super.bringDown();
                RenameLabelBox.this.disposed = true;
            }
        };
        manager.show();
    }

    private String getText() {
        return this.getLabelBoxPrinter().getText();
    }

    @Override
    public Command getCommand() {
        if (this.value == null) {
            return null;
        }
        return new Command(){
            private LabelBoxPrinter labelBox;
            private String oldValue;
            private String newValue;
            {
                this.labelBox = RenameLabelBox.this.getLabelBoxPrinter();
                this.oldValue = RenameLabelBox.this.getLabelBoxPrinter().getText();
                this.newValue = RenameLabelBox.this.value;
            }

            public boolean canExecute() {
                return RenameLabelBox.this.isDone();
            }

            public void execute() {
                this.labelBox.setText(this.newValue);
            }

            public void redo() {
                this.labelBox.setText(this.newValue);
            }

            public void undo() {
                this.labelBox.setText(this.oldValue);
            }
        };
    }

    private LabelBoxPrinter getLabelBoxPrinter() {
        return (LabelBoxPrinter)this.owner.getBoxPrinter();
    }

    @Override
    public void init(BoxPart owner) {
        this.owner = owner;
    }

    @Override
    public boolean isDone() {
        return this.disposed;
    }
}

