/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.printing.ui.internal.editor.PageContextMenuProvider;
import net.refractions.udig.printing.ui.internal.editor.PageEditor;
import net.refractions.udig.printing.ui.internal.editor.parts.TreePartFactory;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public class PageEditorOutlinePage
extends ContentOutlinePage {
    private PageEditor editor;
    private PageBook pagebook;

    public PageEditorOutlinePage(PageEditor editor, EditPartViewer viewer) {
        super(viewer);
        if (editor == null) {
            throw new IllegalArgumentException(Messages.PageEditor_error_nullEditor);
        }
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        Control outline = this.getViewer().createControl((Composite)this.pagebook);
        this.getViewer().setEditDomain((EditDomain)this.editor.getEditDomain());
        this.getViewer().setEditPartFactory((EditPartFactory)new TreePartFactory());
        PageContextMenuProvider cmProvider = new PageContextMenuProvider(this.getViewer(), this.editor.getActionRegistry());
        this.getViewer().setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu("net.refractions.udig.printing.outline.contextmenu", (MenuManager)cmProvider, this.getSite().getSelectionProvider());
        this.editor.getSelectionSynchronizer().addViewer(this.getViewer());
        this.getViewer().setContents((Object)this.editor.getModel());
        this.pagebook.showPage(outline);
    }

    public Control getControl() {
        return this.pagebook;
    }

    public void dispose() {
        this.editor.getSelectionSynchronizer().removeViewer(this.getViewer());
        super.dispose();
        this.editor.disposeOutlinePage();
    }
}

