/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.EventObject;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.ui.internal.PrintAction;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.printing.ui.internal.editor.BoxAction;
import net.refractions.udig.printing.ui.internal.editor.PageContextMenuProvider;
import net.refractions.udig.printing.ui.internal.editor.PageEditorInput;
import net.refractions.udig.printing.ui.internal.editor.PageEditorOutlinePage;
import net.refractions.udig.printing.ui.internal.editor.PageEditorPaletteFactory;
import net.refractions.udig.printing.ui.internal.editor.PrintingScrollingGraphicalViewer;
import net.refractions.udig.printing.ui.internal.editor.parts.PartFactory;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class PageEditor
extends GraphicalEditorWithFlyoutPalette
implements IAdaptable {
    public static final String EDIT_MAP = "edit map";
    public static final String ID = "net.refractions.udig.printing.ui.internal.editor.pageEditor";
    private boolean savePreviouslyNeeded;
    private Page page;
    private PaletteRoot paletteRoot;
    private PageEditorOutlinePage outlinePage;
    private ZoomManager zoomManager;

    public PageEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        ScalableFreeformRootEditPart scalableFreeformRootEditPart = new ScalableFreeformRootEditPart();
        graphicalViewer.setRootEditPart((RootEditPart)scalableFreeformRootEditPart);
        this.zoomManager = scalableFreeformRootEditPart.getZoomManager();
        graphicalViewer.setEditPartFactory((EditPartFactory)new PartFactory());
        PageContextMenuProvider provider = new PageContextMenuProvider((EditPartViewer)graphicalViewer, this.getActionRegistry());
        graphicalViewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("net.refractions.udig.printing.editor.contextmenu", (MenuManager)provider, (ISelectionProvider)graphicalViewer);
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded) {
                this.savePreviouslyNeeded = true;
                this.firePropertyChange(257);
            }
        } else {
            this.savePreviouslyNeeded = false;
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.page = (Page)((PageEditorInput)input).getProjectElement();
        this.setPartName(this.page.getName());
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.page);
    }

    protected void createGraphicalViewer(Composite parent) {
        PrintingScrollingGraphicalViewer viewer = new PrintingScrollingGraphicalViewer(this);
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Collection<BoxAction> actions = PrintingPlugin.getBoxExtensionActions((IWorkbenchPart)this);
        for (IAction iAction : actions) {
            registry.registerAction(iAction);
            this.getSelectionActions().add(iAction.getId());
        }
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = PageEditorPaletteFactory.createPalette();
        }
        return this.paletteRoot;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return PageEditorPaletteFactory.createPalettePreferences();
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)new PrintAction());
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new PageEditorOutlinePage(this, (EditPartViewer)new TreeViewer());
            }
            return this.outlinePage;
        }
        if (type.isAssignableFrom(Map.class)) {
            Map found = null;
            for (Box box : this.page.getBoxes()) {
                Object obj2;
                if (!(box instanceof IAdaptable) || !((obj2 = box.getAdapter(Map.class)) instanceof Map)) continue;
                if (found != null) {
                    found = null;
                    break;
                }
                found = (Map)obj2;
            }
            if (found != null) {
                return found;
            }
        }
        if (type.isAssignableFrom(GraphicalViewer.class)) {
            return this.getGraphicalViewer();
        }
        if (type.isAssignableFrom(ZoomManager.class)) {
            return this.zoomManager;
        }
        return super.getAdapter(type);
    }

    void disposeOutlinePage() {
        this.outlinePage = null;
    }

    Page getModel() {
        return this.page;
    }

    public void dispose() {
        if (PlatformUI.getWorkbench().isClosing()) {
            ProjectPlugin.getPlugin().turnOffEvents();
            Resource resource = this.page.eResource();
            if (resource != null) {
                try {
                    IPreferenceStore p = ProjectUIPlugin.getDefault().getPreferenceStore();
                    int numEditors = p.getInt(ID);
                    String id = "net.refractions.udig.printing.ui.internal.editor.pageEditor:" + numEditors;
                    p.setValue(ID, ++numEditors);
                    String value = resource.getURI().toString();
                    p.setValue(id, value);
                }
                catch (Exception e) {
                    ProjectUIPlugin.log((String)"Failure saving which maps are open", (Throwable)e);
                }
            }
        }
        try {
            this.getSite().getWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Project p = PageEditor.this.page.getProjectInternal();
                    try {
                        if (p != null) {
                            if (p.eResource() != null && p.eResource().isModified()) {
                                p.eResource().save(ProjectPlugin.getPlugin().saveOptions);
                            }
                            this.saveAndUnload();
                        } else {
                            this.saveAndUnload();
                        }
                    }
                    catch (IOException e) {
                        ProjectPlugin.log((String)"", (Throwable)e);
                    }
                    p.eNotify((Notification)new ENotificationImpl((InternalEObject)p, 1, 1, null, null));
                }

                private void saveAndUnload() throws IOException {
                    Resource resource = PageEditor.this.page.eResource();
                    resource.save(ProjectPlugin.getPlugin().saveOptions);
                    if (!resource.getContents().contains((Object)ProjectPlugin.getPlugin().getProjectRegistry())) {
                        // empty if block
                    }
                    resource.unload();
                }
            });
        }
        catch (Exception e) {
            ProjectPlugin.log((String)"", (Throwable)e);
        }
        super.dispose();
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        return super.getSelectionSynchronizer();
    }

    protected DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    protected ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }
}

