/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import net.refractions.udig.core.AdapterUtil;
import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.ui.IBoxEditAction;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.printing.ui.internal.editor.parts.PrintingEditPolicy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class BoxAction
extends SelectionAction {
    private IConfigurationElement editActionElement;
    Request request;
    private String acceptable;
    private Class<? extends BoxPrinter> acceptableClass;
    private IBoxEditAction editAction;

    public BoxAction(IWorkbenchPart part, IConfigurationElement editActionElement2, String acceptable) {
        super(part);
        this.editActionElement = editActionElement2;
        this.acceptable = acceptable;
        this.setText(editActionElement2.getAttribute("name"));
        String attribute = editActionElement2.getAttribute("image");
        if (attribute != null && attribute.trim().length() != 0) {
            ImageDescriptor image = PrintingPlugin.imageDescriptorFromPlugin((String)editActionElement2.getNamespaceIdentifier(), (String)attribute);
            this.setImageDescriptor(image);
        }
        String id = String.valueOf(editActionElement2.getNamespaceIdentifier()) + "." + editActionElement2.getAttribute("id");
        this.setId(id);
        this.request = new Request(id){
            String type;
            {
                this.type = string;
            }

            public Object getType() {
                return this.type;
            }
        };
    }

    public BoxAction(BoxAction action) {
        super(action.getWorkbenchPart());
        this.setText(action.getText());
        this.setToolTipText(action.getToolTipText());
        this.setId(action.getId());
        this.setActionDefinitionId(action.getActionDefinitionId());
        this.acceptable = action.acceptable;
        this.acceptableClass = action.acceptableClass;
        this.editActionElement = action.editActionElement;
        this.request = action.request;
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1 && this.getSelectedObjects().get(0) instanceof EditPart) {
            EditPart part = (EditPart)this.getSelectedObjects().get(0);
            return part.understandsRequest(this.request);
        }
        return false;
    }

    public void run() {
        try {
            EditPart part = (EditPart)this.getSelectedObjects().get(0);
            part.performRequest(this.request);
        }
        catch (ClassCastException e) {
            PrintingPlugin.log("", e);
        }
        catch (IndexOutOfBoundsException e) {
            PrintingPlugin.log("", e);
        }
    }

    public synchronized boolean isAcceptableBoxPrinter(BoxPrinter printer) {
        if (this.acceptableClass == null) {
            try {
                this.acceptableClass = Class.forName(this.acceptable, true, printer.getClass().getClassLoader());
            }
            catch (Exception e) {
                PrintingPlugin.log("Couldn't instantiate the editAction acceptable action. Verify the class exists", e);
                return false;
            }
        }
        return this.acceptableClass.isAssignableFrom(printer.getClass()) || AdapterUtil.instance.canAdaptTo((Object)printer, this.acceptableClass);
    }

    public synchronized EditPolicy getEditPolicy() {
        PrintingEditPolicy editPolicy = new PrintingEditPolicy(new BoxAction(this));
        return editPolicy;
    }

    public Request getRequest() {
        return this.request;
    }

    public synchronized IBoxEditAction getBoxEditAction() {
        if (this.editAction == null) {
            try {
                this.editAction = (IBoxEditAction)this.editActionElement.createExecutableExtension("class");
            }
            catch (Exception e) {
                PrintingPlugin.getDefault().getLog().log((IStatus)new Status(4, this.editActionElement.getNamespaceIdentifier(), 0, "", (Throwable)e));
            }
        }
        return this.editAction;
    }

    public String toString() {
        return "BoxAction for: " + this.acceptable + " boxes";
    }
}

