/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.printing.ui.Template;
import net.refractions.udig.printing.ui.TemplateFactory;
import net.refractions.udig.printing.ui.internal.BoxFactory;
import net.refractions.udig.printing.ui.internal.editor.BoxAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PrintingPlugin
extends AbstractUIPlugin {
    private static PrintingPlugin plugin;
    private static ArrayList<BoxAction> extensionActions;
    private Map<String, TemplateFactory> templateFactories;
    public static final String TEMPLATE_FACTORIES_ID = "net.refractions.udig.printing.ui.templateFactories";
    public static final String PREF_DEFAULT_TEMPLATE = "udig.preferences.defaultTemplate";
    public static final String ID = "net.refractions.udig.printing.ui";
    private static final String boxEditActionGroupName = "editActionGroup";
    public static final String TRACE_PRINTING = "net.refractions.udig.printing.ui/debug/printing";

    public PrintingPlugin() {
        plugin = this;
    }

    public static PrintingPlugin getDefault() {
        return plugin;
    }

    public Map<String, TemplateFactory> getTemplateFactories() {
        if (this.templateFactories == null) {
            this.templateFactories = this.gatherTemplateFactories();
        }
        return this.templateFactories;
    }

    private Map<String, TemplateFactory> gatherTemplateFactories() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(TEMPLATE_FACTORIES_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        final HashMap<String, TemplateFactory> results = new HashMap<String, TemplateFactory>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if ("templateFactory".equals(element.getName())) {
                        try {
                            Object templateFactory = element.createExecutableExtension("class");
                            if (templateFactory instanceof TemplateFactory) {
                                String id = element.getAttribute("id");
                                results.put(id, (TemplateFactory)templateFactory);
                                break block8;
                            }
                            PrintingPlugin.log("Bad extension! Declared class is not of type TemplateFactory!", null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    } else if ("template".equals(element.getName())) {
                        final String id = element.getAttribute("id");
                        final IConfigurationElement remember = element;
                        TemplateFactory fakeFactory = new TemplateFactory(){

                            @Override
                            public Template createTemplate() {
                                try {
                                    Object created = remember.createExecutableExtension("class");
                                    if (created instanceof Template) {
                                        return (Template)created;
                                    }
                                    PrintingPlugin.log("Bad template for " + id + " Declared class is not of type Template", null);
                                    results.remove(id);
                                }
                                catch (CoreException eek) {
                                    PrintingPlugin.log("Could not create template for " + id, eek);
                                }
                                return null;
                            }

                            @Override
                            public String getName() {
                                return remember.getAttribute("name");
                            }
                        };
                        results.put(id, fakeFactory);
                    }
                }
                ++n2;
            }
            ++i;
        }
        return results;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static synchronized Collection<BoxAction> getBoxExtensionActions(IWorkbenchPart part) {
        if (extensionActions == null) {
            extensionActions = new ArrayList();
            String deprecatedActions = "net.refractions.udig.printing.ui.boxprinter";
            extensionActions.addAll(PrintingPlugin.getEditActions(part, deprecatedActions));
            String editActions = "net.refractions.udig.printing.ui.editAction";
            extensionActions.addAll(PrintingPlugin.getEditActions(part, editActions));
        }
        return extensionActions;
    }

    private static Collection<BoxAction> getEditActions(IWorkbenchPart part, String deprecatedActions) {
        ArrayList<BoxAction> extensionActions = new ArrayList<BoxAction>();
        List list = ExtensionPointList.getExtensionPointList((String)deprecatedActions);
        for (IConfigurationElement element : list) {
            IConfigurationElement[] children;
            if (!element.getName().equals(boxEditActionGroupName)) continue;
            String acceptable = element.getAttribute("acceptable");
            IConfigurationElement[] iConfigurationElementArray = children = element.getChildren("editAction");
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element2 = iConfigurationElementArray[n2];
                extensionActions.add(new BoxAction(part, element2, acceptable));
                ++n2;
            }
        }
        return extensionActions;
    }

    public synchronized List<BoxFactory> getVisibleBoxes() {
        List<BoxFactory> boxes = this.getBoxes();
        ArrayList<BoxFactory> visibleBoxes = new ArrayList<BoxFactory>();
        for (BoxFactory entry : boxes) {
            if (!entry.isVisible()) continue;
            visibleBoxes.add(entry);
        }
        return visibleBoxes;
    }

    public List<BoxFactory> getBoxes() {
        List<BoxFactory> boxes = this.gatherBoxes(ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.printing.ui.boxprinter"));
        return boxes;
    }

    private List<BoxFactory> gatherBoxes(List<IConfigurationElement> list) {
        ArrayList<BoxFactory> results = new ArrayList<BoxFactory>();
        for (IConfigurationElement element : list) {
            if (!element.getName().equals("boxprinter")) continue;
            results.add(new BoxFactory(element));
        }
        return results;
    }

    public static void log(String message, Throwable e) {
        PrintingPlugin.getDefault().getLog().log((IStatus)new Status(1, ID, 0, message, e));
    }

    public static boolean isDebugging(String trace) {
        return PrintingPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }

    public static void trace(String message, Throwable e) {
        if (PrintingPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }
}

