/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.model.Page;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class PdfPrintingEngine {
    private Page page;
    private IProgressMonitor monitor;
    private final File outputPdfFile;

    public PdfPrintingEngine(Page page, File outputPdfFile) {
        this.page = page;
        this.outputPdfFile = outputPdfFile;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean printToPdf() {
        Dimension paperSize = this.page.getPaperSize();
        Dimension pageSize = this.page.getSize();
        float xScale = (float)paperSize.width / (float)pageSize.width;
        float yScale = (float)paperSize.height / (float)pageSize.height;
        Rectangle paperRectangle = new Rectangle((float)paperSize.width, (float)paperSize.height);
        Document document = new Document(paperRectangle, 0.0f, 0.0f, 0.0f, 0.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.outputPdfFile));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D graphics = cb.createGraphics(paperRectangle.getWidth(), paperRectangle.getHeight());
            List boxes = this.page.getBoxes();
            for (Box box : boxes) {
                String id = box.getID();
                System.out.println(id);
                Point boxLocation = box.getLocation();
                if (boxLocation == null) continue;
                int x = boxLocation.x;
                int y = boxLocation.y;
                Dimension size = box.getSize();
                if (size == null) continue;
                int w = size.width;
                int h = size.height;
                float newX = xScale * (float)x;
                float newY = yScale * (float)y;
                float newW = xScale * (float)w;
                float newH = yScale * (float)h;
                box.setSize(new Dimension((int)newW, (int)newH));
                box.setLocation(new Point((int)newX, (int)newY));
                Graphics2D boxGraphics = (Graphics2D)graphics.create((int)newX, (int)newY, (int)newW, (int)newH);
                BoxPrinter boxPrinter = box.getBoxPrinter();
                boxPrinter.draw(boxGraphics, this.monitor);
            }
            graphics.dispose();
            document.newPage();
            document.close();
            writer.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

