/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import java.awt.Font;
import net.refractions.udig.legend.ui.LegendGraphic;
import net.refractions.udig.mapgraphic.MapGraphicChooserDialog;
import net.refractions.udig.mapgraphic.scalebar.ScalebarMapGraphic;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.model.ModelFactory;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.model.impl.LabelBoxPrinter;
import net.refractions.udig.printing.model.impl.MapBoxPrinter;
import net.refractions.udig.printing.model.impl.MapGraphicBoxPrinter;
import net.refractions.udig.printing.ui.internal.AbstractTemplate;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class BasicTemplate
extends AbstractTemplate {
    private static final int MARGIN = 10;
    private static final int SPACING = 10;
    private Rectangle mapBounds;

    @Override
    public void init(Page page, Map map) {
        int width;
        int height = page.getSize().height;
        int labelWidth = width = page.getSize().width;
        int legendWidth = 150;
        int legendHeight = 150;
        int scaleHeight = 20;
        int scaleWidth = 150;
        int labelHeight = this.addLabelBox(map, width, labelWidth);
        this.mapBounds = this.addMapBox(map, width, height, labelHeight, scaleHeight, legendWidth);
        this.addLegendBox(height, legendWidth, legendHeight, labelHeight, this.mapBounds);
        this.addScale(height, scaleHeight, scaleWidth);
    }

    private void addScale(int height, int scaleHeight, int scaleWidth) {
        Box scaleBox = ModelFactory.eINSTANCE.createBox();
        MapGraphicBoxPrinter scale = new MapGraphicBoxPrinter(null);
        scale.setMapGraphic(MapGraphicChooserDialog.findResource(ScalebarMapGraphic.class));
        scaleBox.setBoxPrinter((BoxPrinter)scale);
        scaleBox.setID("Scalebar Box");
        scaleBox.setLocation(new Point(10, height - 10 - scaleHeight));
        scaleBox.setSize(new Dimension(scaleWidth, scaleHeight));
        this.boxes.add(scaleBox);
    }

    private int addLabelBox(Map map, int width, int labelWidth) {
        Box labelBox = ModelFactory.eINSTANCE.createBox();
        LabelBoxPrinter labelBoxPrinter = new LabelBoxPrinter();
        labelBoxPrinter.setText(this.formatName(map.getName()));
        labelBoxPrinter.setHorizontalAlignment(0x1000000);
        try {
            FontData data = Display.getDefault().getSystemFont().getFontData()[0];
            data.setHeight(18);
            data.setStyle(1);
            Font font = AWTSWTImageUtils.swtFontToAwt((FontData)data);
            labelBoxPrinter.setFont(font);
        }
        catch (Exception exception) {}
        labelBox.setBoxPrinter((BoxPrinter)labelBoxPrinter);
        labelBox.setID("Standard Label");
        int labelHeight = 50;
        labelBox.setSize(new Dimension(labelWidth, labelHeight));
        labelBox.setLocation(new Point((width - labelWidth) / 2, 10));
        this.boxes.add(labelBox);
        return labelHeight;
    }

    private String formatName(String name) {
        name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        name = name.replaceAll("[_\\s]", " ");
        StringBuilder builder = new StringBuilder();
        int prev = 32;
        int i = 0;
        while (i < name.length()) {
            char current = name.charAt(i);
            if (prev == 32) {
                builder.append(Character.toUpperCase(current));
            } else {
                builder.append(current);
            }
            prev = current;
            ++i;
        }
        return builder.toString();
    }

    private Rectangle addMapBox(Map map, int width, int height, int labelHeight, int scaleHeight, int legendWidth) {
        Box mapBox = ModelFactory.eINSTANCE.createBox();
        MapBoxPrinter mapBoxPrinter = new MapBoxPrinter();
        mapBox.setID("Standard Map Box");
        mapBox.setBoxPrinter((BoxPrinter)mapBoxPrinter);
        mapBoxPrinter.setMap((IMap)map);
        int bothMargins = 20;
        int mapWidth = width - bothMargins - legendWidth - 10;
        int labelAndSpacing = labelHeight + 10;
        int scaleAndSpacing = scaleHeight + 10;
        int mapHeight = height - bothMargins - labelAndSpacing - scaleAndSpacing;
        int mapX = 10;
        int mapY = 10 + labelAndSpacing;
        Rectangle mapBounds = new Rectangle(mapX, mapY, mapWidth, mapHeight);
        mapBox.setSize(new Dimension(mapBounds.width, mapBounds.height));
        mapBox.setLocation(new Point(mapBounds.x, mapBounds.y));
        this.boxes.add(mapBox);
        return mapBounds;
    }

    private void addLegendBox(int height, int legendWidth, int legendHeight, int labelHeight, Rectangle mapBounds) {
        Box legendBox = ModelFactory.eINSTANCE.createBox();
        MapGraphicBoxPrinter legend = new MapGraphicBoxPrinter(null);
        legend.setMapGraphic(MapGraphicChooserDialog.findResource(LegendGraphic.class));
        legendBox.setBoxPrinter((BoxPrinter)legend);
        legendBox.setID("Legend Box");
        legendBox.setLocation(new Point(10 + mapBounds.width + 10, 10 + labelHeight + 10));
        legendBox.setSize(new Dimension(legendWidth, legendHeight));
        this.boxes.add(legendBox);
    }

    @Override
    public String getName() {
        return Messages.BasicTemplate_name;
    }

    @Override
    public Rectangle getMapBounds() throws IllegalStateException {
        if (this.mapBounds == null) {
            throw new IllegalStateException("Please initialize the template before calling this method.");
        }
        return this.mapBounds;
    }

    @Override
    public String getAbbreviation() {
        return this.getName();
    }
}

