/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.actions;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.ModelFactory;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.ui.Template;
import net.refractions.udig.printing.ui.TemplateFactory;
import net.refractions.udig.printing.ui.internal.BasicTemplateFactory;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapEditorInput;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.MapEditorWithPalette;
import net.refractions.udig.project.ui.internal.MapPart;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class CreatePageAction
implements IEditorActionDelegate {
    public void run(IAction action) {
        Point partSize;
        MapEditorPart part;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorInput input = activeEditor.getEditorInput();
        if (!(activeEditor instanceof MapEditorPart) && !(input instanceof MapEditorInput)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CreatePageAction_printError_title, (String)Messages.CreatePageAction_printError_text);
        }
        MapPart mapEditor = (MapPart)activeEditor;
        Template template = this.getPageTemplate();
        if (template == null) {
            return;
        }
        net.refractions.udig.project.internal.Map map = null;
        Project project = null;
        net.refractions.udig.project.internal.Map oldMap = (net.refractions.udig.project.internal.Map)((MapEditorInput)input).getProjectElement();
        project = oldMap.getProjectInternal();
        try {
            map = (net.refractions.udig.project.internal.Map)EcoreUtil.copy((EObject)oldMap);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        project.getElementsInternal().add(map);
        if (mapEditor instanceof MapEditorPart) {
            part = (MapEditorPart)mapEditor;
            partSize = part.getComposite().getSize();
        } else if (mapEditor instanceof MapEditorWithPalette) {
            part = (MapEditorWithPalette)mapEditor;
            partSize = part.getComposite().getSize();
        } else {
            partSize = new Point(500, 500);
        }
        Page page = this.createPage(template, map, project, partSize);
        ApplicationGIS.openProjectElement((IProjectElement)page, (boolean)false);
    }

    private Page createPage(Template template, net.refractions.udig.project.internal.Map map, Project project, Point partSize) {
        int width = 800;
        int height = 600;
        if (partSize != null) {
            width = partSize.x;
            height = partSize.y;
        } else {
            PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
            width = new Double(pageFormat.getImageableWidth()).intValue();
            height = new Double(pageFormat.getImageableHeight()).intValue();
        }
        Page page = ModelFactory.eINSTANCE.createPage();
        page.setSize(new Dimension(width, height));
        MessageFormat formatter = new MessageFormat("{0} - " + template.getAbbreviation(), Locale.getDefault());
        if (page.getName() == null || page.getName().length() == 0) {
            page.setName(formatter.format(new Object[]{map.getName()}));
        }
        page.setProjectInternal(project);
        template.init(page, map);
        Iterator<Box> iter = template.iterator();
        while (iter.hasNext()) {
            page.getBoxes().add(iter.next());
        }
        return page;
    }

    private Template getPageTemplate() {
        Map<String, TemplateFactory> templateFactories = PrintingPlugin.getDefault().getTemplateFactories();
        PrintingPlugin.getDefault().getPluginPreferences().setValue("udig.preferences.defaultTemplate", "net.refractions.udig.printing.ui.internal.BasicTemplate");
        String defaultTemplate = PrintingPlugin.getDefault().getPluginPreferences().getString("udig.preferences.defaultTemplate");
        ListDialog dialog = this.createTemplateChooserDialog(templateFactories);
        TemplateFactory templateFactory = PrintingPlugin.getDefault().getTemplateFactories().get(defaultTemplate);
        dialog.setInitialSelections(new Object[]{templateFactory});
        int result = dialog.open();
        if (result == 1 || dialog.getResult().length == 0) {
            return null;
        }
        Template template = null;
        templateFactory = (TemplateFactory)dialog.getResult()[0];
        if (templateFactory == null) {
            PrintingPlugin.log(Messages.CreatePageAction_error_cannotFindDefaultTemplate, null);
            TemplateFactory firstAvailable = templateFactories.values().iterator().next();
            if (firstAvailable == null) {
                PrintingPlugin.log("Unable to locate any templates, resorting to hard coded default.", null);
                template = new BasicTemplateFactory().createTemplate();
            } else {
                template = firstAvailable.createTemplate();
            }
        } else {
            template = templateFactory.createTemplate();
        }
        return template;
    }

    private ListDialog createTemplateChooserDialog(Map<String, TemplateFactory> templateFactories) {
        ListDialog dialog = new ListDialog(Display.getDefault().getActiveShell());
        dialog.setTitle(Messages.CreatePageAction_dialog_title);
        dialog.setMessage(Messages.CreatePageAction_dialog_message);
        Set<String> keySet = templateFactories.keySet();
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.addAll(keySet);
        Collections.sort(keyList);
        ArrayList<TemplateFactory> valuesList = new ArrayList<TemplateFactory>();
        for (String key : keyList) {
            valuesList.add(templateFactories.get(key));
        }
        dialog.setInput(valuesList);
        ArrayContentProvider provider = new ArrayContentProvider();
        dialog.setContentProvider((IStructuredContentProvider)provider);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((TemplateFactory)element).getName();
            }
        };
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        return dialog;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

