/*
 * Decompiled with CFR 0.152.
 */
package net.crischan.udig.arcgrid;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.crischan.udig.arcgrid.ArcGridServiceImplementation;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.gce.arcgrid.ArcGridFormatFactory;

public class ArcGridServiceExtension
implements ServiceExtension {
    private static ArcGridFormat format;
    private static ArcGridFormatFactory factory;
    public static final String URL_PARAM = "URL";
    public static final String TYPE = "arcgrid";

    public Map<String, Serializable> createParams(URL url) {
        if (!this.canProcess(url)) {
            return null;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        if (url != null) {
            params.put(URL_PARAM, url);
        }
        return params;
    }

    public IService createService(URL url, Map<String, Serializable> params) {
        URL url2 = url;
        if (url2 == null) {
            url2 = this.extractURL(params);
        }
        if (!this.canProcess(url2)) {
            return null;
        }
        ArcGridServiceImplementation service = new ArcGridServiceImplementation(url2, (GridFormatFactorySpi)ArcGridServiceExtension.getFactory());
        return service;
    }

    private boolean canProcess(URL url) {
        return this.reasonForFailure(url) == null;
    }

    public String reasonForFailure(URL url) {
        if (url == null) {
            String msg = "URL = null";
            return msg;
        }
        if (!this.isSupportedExtension(url)) {
            String msg = "Unsupported extension";
            return msg;
        }
        File file = null;
        try {
            file = new File(url.getFile());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String msg = "Not a file";
            return msg;
        }
        String msg = this.arcGridFile(file);
        if (msg != null) {
            return msg;
        }
        try {
            if (!ArcGridServiceExtension.getFormat().accepts((Object)file)) {
                msg = "Unknown format";
                return msg;
            }
        }
        catch (RuntimeException runtimeException) {
            msg = "Unknown format";
            return msg;
        }
        return null;
    }

    private boolean isSupportedExtension(URL url) {
        String file = url.getFile();
        return (file = file.toLowerCase()).endsWith(".asc") || file.endsWith(".grd") || file.endsWith(".asc.gz");
    }

    private String arcGridFile(File file) {
        return null;
    }

    private static ArcGridFormat getFormat() {
        if (format == null) {
            format = ArcGridServiceExtension.getFactory().createFormat();
        }
        return format;
    }

    private static ArcGridFormatFactory getFactory() {
        if (factory == null) {
            factory = new ArcGridFormatFactory();
        }
        return factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL extractURL(Map<String, Serializable> params) {
        if (!params.containsKey(URL_PARAM)) return null;
        Serializable param = params.get(URL_PARAM);
        if (param instanceof String) {
            try {
                return new URL((String)((Object)param));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (!(param instanceof URL)) return null;
        return (URL)param;
    }
}

