/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ww;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.LayerSet;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.QuadTileSet;
import net.refractions.udig.catalog.internal.wmt.ww.WWFolder;
import net.refractions.udig.catalog.internal.wmt.ww.WWGeoResource;
import net.refractions.udig.catalog.internal.wmt.ww.WWServiceInfo;
import net.refractions.udig.catalog.wmt.internal.Messages;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WWService
extends IService {
    public static final String WW_URL_KEY = "net.refractions.udig.catalog.internal.wmt.WWService.WW_URL_KEY";
    public static final String WW_LAYERSET_KEY = "net.refractions.udig.catalog.internal.wmt.WWService.WW_LAYERSET_KEY";
    private Map<String, Serializable> params;
    private Throwable error;
    private URL url;
    private volatile LayerSet layerSet = null;
    private volatile List<IResolve> members;
    protected final Lock rLock = new UDIGDisplaySafeLock();
    private static final Lock dsLock = new UDIGDisplaySafeLock();

    public WWService(URL url, Map<String, Serializable> params) {
        Serializable obj;
        this.params = params;
        this.url = url;
        if (params.containsKey(WW_LAYERSET_KEY) && (obj = params.get(WW_LAYERSET_KEY)) instanceof LayerSet) {
            this.layerSet = (LayerSet)((Object)obj);
        }
    }

    public IResolve.Status getStatus() {
        if (this.layerSet == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    protected LayerSet getLayerSet(IProgressMonitor theUserIsWatching) throws IOException {
        block9: {
            if (this.layerSet == null) {
                dsLock.lock();
                try {
                    if (this.layerSet != null) break block9;
                    try {
                        if (theUserIsWatching != null) {
                            String message = MessageFormat.format(Messages.WWService_Connecting_to, this.url);
                            theUserIsWatching.beginTask(message, 100);
                        }
                        URL url1 = (URL)this.getConnectionParams().get(WW_URL_KEY);
                        if (theUserIsWatching != null) {
                            theUserIsWatching.worked(5);
                        }
                        this.layerSet = LayerSet.getFromUrl(url1);
                        if (theUserIsWatching != null) {
                            theUserIsWatching.done();
                        }
                    }
                    catch (Exception exc) {
                        IOException broken = new IOException(MessageFormat.format(Messages.WWService_Could_not_connect, exc.getLocalizedMessage()));
                        broken.initCause(exc);
                        this.error = broken;
                        throw broken;
                    }
                }
                finally {
                    dsLock.unlock();
                }
            }
        }
        return this.layerSet;
    }

    protected IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            this.getLayerSet(monitor);
            this.rLock.lock();
            try {
                if (this.info == null) {
                    this.info = new WWServiceInfo(this, monitor);
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        return this.info;
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IServiceInfo.class)) {
            return adaptee.cast(this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(List.class)) {
            return adaptee.cast(this.members(monitor));
        }
        if (adaptee.isAssignableFrom(LayerSet.class)) {
            return adaptee.cast(this.getLayerSet(monitor));
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(LayerSet.class) || super.canResolve(adaptee);
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.members != null) {
            this.members = null;
        }
        if (this.layerSet != null) {
            this.layerSet.dispose();
            this.layerSet = null;
        }
    }

    public List<WWGeoResource> resources(IProgressMonitor monitor) throws IOException {
        this.members(monitor);
        ArrayList<WWGeoResource> children = new ArrayList<WWGeoResource>();
        this.collectChildren((IResolve)this, children);
        return children;
    }

    private void collectChildren(IResolve resolve, List<WWGeoResource> children) throws IOException {
        List resolves = resolve.members((IProgressMonitor)new NullProgressMonitor());
        if (resolves.isEmpty() && resolve instanceof WWGeoResource) {
            children.add((WWGeoResource)resolve);
        } else {
            for (IResolve resolve2 : resolves) {
                this.collectChildren(resolve2, children);
            }
        }
    }

    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            this.getLayerSet(monitor);
            this.rLock.lock();
            try {
                if (this.members == null) {
                    this.getLayerSet(monitor);
                    this.members = new LinkedList<IResolve>();
                    List<QuadTileSet> quadTileSets = this.getLayerSet(monitor).getQuadTileSets();
                    for (QuadTileSet quadTileSet : quadTileSets) {
                        this.members.add((IResolve)new WWGeoResource(this, (IResolve)this, quadTileSet));
                    }
                    List<LayerSet> layerSets = this.getLayerSet(monitor).getChildLayerSets();
                    for (LayerSet layerSet : layerSets) {
                        this.members.add((IResolve)new WWFolder(this, (IResolve)this, layerSet));
                    }
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        return this.members;
    }

    public Throwable getMessage() {
        return this.error;
    }

    public URL getIdentifier() {
        return this.url;
    }
}

