/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ww;

import java.io.IOException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WWSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.QuadTileSet;
import net.refractions.udig.catalog.internal.wmt.ww.WWGeoResourceInfo;
import net.refractions.udig.catalog.internal.wmt.ww.WWService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WWGeoResource
extends IGeoResource {
    private WWSource wwSource;
    private URL identifier;
    private IResolve parent;
    private Throwable msg = null;

    public WWGeoResource(WWService service, IResolve parent, WWSource wwSource) {
        this.service = service;
        this.wwSource = wwSource;
        this.parent = parent == null ? service : parent;
        try {
            this.identifier = new URL(String.valueOf(service.getIdentifier().toString()) + "#" + wwSource.getId());
        }
        catch (Throwable e) {
            WMTPlugin.log(null, e);
            this.identifier = service.getIdentifier();
        }
    }

    public WWGeoResource(WWService service, IResolve parent, QuadTileSet quadTileSet) {
        this(service, parent, new WWSource(quadTileSet));
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.parent;
    }

    public WMTSource getSource() {
        return this.wwSource;
    }

    public String getTitle() {
        return this.getSource().getName();
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(WMTSource.class) || super.canResolve(adaptee));
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(WMTSource.class)) {
            return adaptee.cast(this.getSource());
        }
        return (T)super.resolve(adaptee, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            WWGeoResource wWGeoResource = this;
            synchronized (wWGeoResource) {
                if (this.info == null) {
                    this.info = new WWGeoResourceInfo(this, monitor);
                }
            }
        }
        return this.info;
    }

    public IResolve.Status getStatus() {
        if (this.msg != null) {
            return IResolve.Status.BROKEN;
        }
        if (this.wwSource == null) {
            return IResolve.Status.NOTCONNECTED;
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URL getIdentifier() {
        return this.identifier;
    }
}

