/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ww;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.LayerSet;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.QuadTileSet;
import net.refractions.udig.catalog.internal.wmt.ww.WWGeoResource;
import net.refractions.udig.catalog.internal.wmt.ww.WWService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

public class WWFolder
implements IResolveFolder {
    private WWService service;
    private IResolve parent;
    private LayerSet layerSet;
    private List<IResolve> members;
    private URL identifier;

    public WWFolder(WWService service, IResolve parent, LayerSet layerSet) {
        this.service = service;
        this.layerSet = layerSet;
        this.parent = parent == null ? service : parent;
        this.members = new LinkedList<IResolve>();
        List<QuadTileSet> quadTileSets = layerSet.getQuadTileSets();
        for (QuadTileSet quadTileSet : quadTileSets) {
            this.members.add((IResolve)new WWGeoResource(service, (IResolve)this, quadTileSet));
        }
        List<LayerSet> layerSets = layerSet.getChildLayerSets();
        for (LayerSet childLayerSet : layerSets) {
            this.members.add((IResolve)new WWFolder(service, (IResolve)this, childLayerSet));
        }
        try {
            this.identifier = new URL(String.valueOf(service.getIdentifier().toString()) + "#" + layerSet.getId());
        }
        catch (Throwable e) {
            WMTPlugin.log(null, e);
            this.identifier = service.getIdentifier();
        }
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public ID getID() {
        return new ID(this.getIdentifier());
    }

    public Throwable getMessage() {
        return null;
    }

    public IResolve.Status getStatus() {
        return IResolve.Status.CONNECTED;
    }

    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        return this.members;
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.parent;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        if (adaptee.isAssignableFrom(WWFolder.class) || adaptee.isAssignableFrom(LayerSet.class)) {
            return true;
        }
        return CatalogPlugin.getDefault().getResolveManager().canResolve((IResolve)this, adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            throw new NullPointerException();
        }
        if (adaptee.isAssignableFrom(WWFolder.class)) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(LayerSet.class)) {
            return adaptee.cast(this.layerSet);
        }
        IResolveManager rm = CatalogPlugin.getDefault().getResolveManager();
        if (rm.canResolve((IResolve)this, adaptee)) {
            return (T)rm.resolve((IResolve)this, adaptee, monitor);
        }
        return null;
    }

    public String getTitle() {
        return this.layerSet.getName();
    }

    public IService getService(IProgressMonitor monitor) {
        return this.service;
    }

    public ImageDescriptor getIcon(IProgressMonitor monitor) {
        return null;
    }

    public void dispose(IProgressMonitor monitor) {
    }
}

