/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource.ww;

import java.text.DecimalFormat;
import net.refractions.udig.catalog.internal.wmt.tile.WWTile;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.ImageAccessor;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.TileService;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jdom.Element;

public class WMSTileService
extends TileService {
    private ImageAccessor imageAccessor;
    private String serverGetMapUrl;
    private String version;
    private String imageFormat;
    private String layerName;
    private String layerStyle;
    private boolean useTransparency;
    private static final DecimalFormat formatter = new DecimalFormat("##0.#################");

    public WMSTileService(Element child, ImageAccessor imageAccessor) {
        this.imageAccessor = imageAccessor;
        this.serverGetMapUrl = child.getChildText("ServerGetMapUrl");
        this.version = child.getChildText("Version");
        this.imageFormat = child.getChildText("ImageFormat");
        this.layerStyle = child.getChildText("WMSLayerStyle");
        this.layerName = child.getChildText("WMSLayerName");
        String transparency = child.getChildText("UseTransparency");
        this.useTransparency = transparency != null && transparency.trim().toLowerCase().equals("true");
    }

    @Override
    public String getTileRequest(WWTile.WWTileName tileName) {
        StringBuilder request = new StringBuilder(this.serverGetMapUrl);
        request.append("?request=GetMap");
        request.append("&layers=" + this.layerName);
        request.append("&srs=EPSG:4326");
        request.append("&width=" + this.imageAccessor.getTileSize());
        request.append("&height=" + this.imageAccessor.getTileSize());
        request.append("&format=" + this.imageFormat);
        request.append("&version=" + this.version);
        if (this.layerStyle != null && !this.layerStyle.isEmpty()) {
            request.append("&styles=" + this.layerStyle);
        } else {
            request.append("&styles=");
        }
        if (this.useTransparency && !this.imageFormat.toLowerCase().contains("jpeg")) {
            request.append("&transparent=true");
        }
        this.addBboxString(request, tileName);
        return request.toString();
    }

    private void addBboxString(StringBuilder request, WWTile.WWTileName tileName) {
        ReferencedEnvelope bounds = WWTile.getExtentFromTileName(tileName);
        request.append("&bbox=");
        request.append(this.parseDouble(bounds.getMinX()));
        request.append(',');
        request.append(this.parseDouble(bounds.getMinY()));
        request.append(',');
        request.append(this.parseDouble(bounds.getMaxX()));
        request.append(',');
        request.append(this.parseDouble(bounds.getMaxY()));
    }

    private String parseDouble(double value) {
        return formatter.format(value).replace(',', '.');
    }
}

