/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource.ww;

import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.tile.WWTile;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.ImageAccessor;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.LayerSet;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdom.Element;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class QuadTileSet {
    private String name;
    private String id;
    private ReferencedEnvelope bbox;
    private ImageAccessor accessor;

    public QuadTileSet(Element xmlElement, String id) throws Exception {
        this.name = xmlElement.getChildText("Name");
        this.id = LayerSet.constructId(id, this.name);
        this.parseBbox(xmlElement.getChild("BoundingBox"));
        this.parseImageAccessor(xmlElement.getChild("ImageAccessor"));
    }

    private void parseBbox(Element bboxElement) throws Exception {
        try {
            ReferencedEnvelope bounds;
            double maxY = this.getNumericValueFromChild(bboxElement.getChild("North"));
            double minY = this.getNumericValueFromChild(bboxElement.getChild("South"));
            double minX = this.getNumericValueFromChild(bboxElement.getChild("West"));
            double maxX = this.getNumericValueFromChild(bboxElement.getChild("East"));
            this.bbox = bounds = new ReferencedEnvelope(minX, maxX, minY, maxY, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        catch (Exception exc) {
            WMTPlugin.log("[QuadTileSet.parseBbox] Getting the BBox failed", exc);
            throw exc;
        }
    }

    private double getNumericValueFromChild(Element bboxChild) throws Exception {
        return Double.parseDouble(bboxChild.getChildText("Value"));
    }

    private void parseImageAccessor(Element accessorElement) throws Exception {
        this.accessor = new ImageAccessor(accessorElement, this);
    }

    public ReferencedEnvelope getBounds() {
        return this.bbox;
    }

    public double[] getScaleList() {
        return this.accessor.getScaleList();
    }

    public WWTile.WWTileName.WWZoomLevel getZoomLevel(int index) {
        return this.accessor.getZoomLevel(index);
    }

    public String getFileFormat() {
        return this.accessor.getFileFormat();
    }

    public String getName() {
        return this.name;
    }

    public int getTileSize() {
        return this.accessor.getTileSize();
    }

    public String getId() {
        return this.id;
    }

    public void dispose() {
    }
}

