/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource.ww;

import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.QuadTileSet;
import net.refractions.udig.catalog.wmt.internal.Messages;
import net.refractions.udig.core.internal.CorePlugin;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class LayerSet {
    private String name;
    private String id;
    private List<QuadTileSet> quadTileSets;
    private List<LayerSet> childLayerSets;
    public static final char ID_SEPERATOR = '-';
    private static final String[] ILLEGAL_CHARACTERS = new String[]{"/", "\n", "\r", "\t", "\u0000", "\f", "`", "?", "*", "\\", "<", ">", "|", "\"", ":"};

    public LayerSet(Element xmlElement, String id) throws Exception {
        this.name = xmlElement.getAttributeValue("Name");
        this.id = LayerSet.constructId(id, this.name);
        this.getChildLayerSets(xmlElement.getChildren("ChildLayerSet"));
        this.getQuadTileSets(xmlElement.getChildren("QuadTileSet"));
    }

    private void getQuadTileSets(List<?> children) throws Exception {
        this.quadTileSets = new ArrayList<QuadTileSet>(children.size());
        for (Object child : children) {
            if (!(child instanceof Element)) continue;
            this.quadTileSets.add(new QuadTileSet((Element)child, this.id));
        }
    }

    private void getChildLayerSets(List<?> children) throws Exception {
        this.childLayerSets = new ArrayList<LayerSet>(children.size());
        for (Object child : children) {
            if (!(child instanceof Element)) continue;
            this.childLayerSets.add(new LayerSet((Element)child, this.id));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<QuadTileSet> getQuadTileSets() {
        return this.quadTileSets;
    }

    public List<LayerSet> getChildLayerSets() {
        return this.childLayerSets;
    }

    public static String constructId(String prefix, String name) {
        String id = String.valueOf(prefix) + '-' + name.replace("#", "%20");
        int i = 0;
        while (i < ILLEGAL_CHARACTERS.length) {
            if (id.indexOf(ILLEGAL_CHARACTERS[i]) >= 0) {
                id = id.replace(ILLEGAL_CHARACTERS[i], "%20");
            }
            ++i;
        }
        return id.replace(" ", "%20");
    }

    public static LayerSet getFromUrl(URL url) throws Exception {
        try {
            Element layerSet = LayerSet.getRootElementFromUrl(url);
            if (layerSet == null) {
                throw new Exception(Messages.WWService_NoValidFile);
            }
            String redirect = layerSet.getAttributeValue("redirect");
            if (redirect == null) {
                return new LayerSet(layerSet, "");
            }
            if (redirect.indexOf("${WORLDWINDVERSION}") >= 0) {
                redirect = redirect.replace("${WORLDWINDVERSION}", "1.4.0.0");
            }
            URL redirectUrl = new URL(null, redirect, CorePlugin.RELAXED_HANDLER);
            layerSet = LayerSet.getRootElementFromUrl(redirectUrl);
            return new LayerSet(layerSet, "");
        }
        catch (Exception exc) {
            WMTPlugin.log("[LayerSet.getFromUrl] Loading WorldWind Config-File failed: " + url, exc);
            throw exc;
        }
    }

    private static Element getRootElementFromUrl(URL url) throws Exception {
        SAXBuilder builder = new SAXBuilder(false);
        URLConnection connection = url.openConnection();
        Document dom = builder.build(connection.getInputStream());
        return dom.getRootElement();
    }

    public void dispose() {
        if (this.quadTileSets != null) {
            for (QuadTileSet tileSet : this.quadTileSets) {
                tileSet.dispose();
            }
            this.quadTileSets.clear();
            this.quadTileSets = null;
        }
        if (this.childLayerSets != null) {
            for (LayerSet child : this.childLayerSets) {
                child.dispose();
            }
            this.childLayerSets.clear();
            this.childLayerSets = null;
        }
    }
}

