/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource;

import java.net.URL;
import net.refractions.udig.catalog.internal.wmt.WMTService;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;

public class WMTSourceFactory {
    public static WMTSource createSource(WMTService service, URL url, String resourceId) throws Throwable {
        String className = WMTSourceFactory.getClassFromUrl(url);
        WMTSource source = (WMTSource)Class.forName(className).newInstance();
        source.init(resourceId);
        source.setWmtService(service);
        return source;
    }

    public static String getClassFromUrl(URL url) {
        String withoutId = url.toString().replace(WMTService.ID, "");
        int posSlash = withoutId.indexOf("/");
        if (posSlash >= 0) {
            return withoutId.substring(0, posSlash);
        }
        return withoutId;
    }

    public static WMTSource createSource(WMTService service, URL url, String resourceId, boolean noException) {
        WMTSource source;
        try {
            source = WMTSourceFactory.createSource(service, url, resourceId);
        }
        catch (Throwable throwable) {
            source = null;
        }
        return source;
    }
}

