/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource;

import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.internal.wmt.WMTGeoResource;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTService;
import net.refractions.udig.catalog.internal.wmt.WMTServiceExtension;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.WMTWizardTreeItemData;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.NASAControl;
import net.refractions.udig.catalog.internal.wmt.ui.wizard.controls.WMTWizardControl;
import net.refractions.udig.catalog.internal.wmt.wmtsource.NASASource;
import org.eclipse.swt.widgets.TreeItem;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class NASASourceManager {
    private static final String TILESERVICE_FILE = "NASA-GetTileService.xml";
    private Element tiledPatterns = null;
    private WMTServiceExtension serviceExtension = new WMTServiceExtension();
    private static NASASourceManager instance = null;

    public static synchronized NASASourceManager getInstance() {
        if (instance == null) {
            instance = new NASASourceManager();
        }
        return instance;
    }

    private NASASourceManager() {
        try {
            URL url = NASASource.class.getResource(TILESERVICE_FILE);
            SAXBuilder builder = new SAXBuilder(false);
            URLConnection connection = url.openConnection();
            Document dom = builder.build(connection.getInputStream());
            Element root = dom.getRootElement();
            this.tiledPatterns = root.getChild("TiledPatterns");
        }
        catch (Exception exc) {
            WMTPlugin.log("[NASASourceManager] Loading tileservice-file failed: NASA-GetTileService.xml", exc);
            this.tiledPatterns = null;
        }
    }

    public String getBaseUrl() {
        Element onlineResource = this.tiledPatterns.getChild("OnlineResource");
        Namespace xlink = onlineResource.getNamespace("xlink");
        Attribute href = onlineResource.getAttribute("href", xlink);
        String baseUrl = href.getValue();
        return baseUrl;
    }

    public void buildWizardTree(TreeItem treeItem) {
        NASAControl controlFactory = new NASAControl();
        try {
            List tiledGroups = this.tiledPatterns.getChildren("TiledGroup");
            WMTService service = this.serviceExtension.createService(NASASource.class);
            List<IGeoResource> geoResources = service.emptyResourcesList(null);
            geoResources.clear();
            WMTWizardTreeItemData data = new WMTWizardTreeItemData((IResolve)service, controlFactory);
            treeItem.setData((Object)data);
            this.buildWizardTreeFromTiledGroups(service, geoResources, treeItem, tiledGroups, "", controlFactory);
        }
        catch (Exception exc) {
            WMTPlugin.log("[NASASourceManager.buildWizardTree] Failed: ", exc);
        }
    }

    private void buildWizardTreeFromTiledGroups(WMTService service, List<IGeoResource> geoResources, TreeItem treeItem, List<?> tiledGroups, String groupNames, WMTWizardControl controlFactory) {
        for (Object obj : tiledGroups) {
            TreeItem newTreeItem;
            if (!(obj instanceof Element)) continue;
            Element tiledGroup = (Element)obj;
            String newGroupName = tiledGroup.getChildText("Name");
            String newGroupNames = this.getConcatenatedGroupName(groupNames, newGroupName);
            List newTiledGroups = tiledGroup.getChildren("TiledGroup");
            if (newTiledGroups.isEmpty()) {
                newTreeItem = new TreeItem(treeItem, 0);
                WMTGeoResource geoResource = new WMTGeoResource(service, newGroupNames);
                geoResources.add(geoResource);
                newTreeItem.setText(newGroupName);
                WMTWizardTreeItemData data = new WMTWizardTreeItemData((IResolve)geoResource, controlFactory);
                newTreeItem.setData((Object)data);
                continue;
            }
            newTreeItem = new TreeItem(treeItem, 0);
            newTreeItem.setText(newGroupName);
            WMTWizardTreeItemData data = new WMTWizardTreeItemData(null, controlFactory);
            newTreeItem.setData((Object)data);
            this.buildWizardTreeFromTiledGroups(service, geoResources, newTreeItem, newTiledGroups, newGroupNames, controlFactory);
        }
    }

    public void buildGeoResources(WMTService service, List<IGeoResource> geoResources) throws Exception {
        geoResources.clear();
        try {
            List tiledGroups = this.tiledPatterns.getChildren("TiledGroup");
            this.buildGeoResourcesFromTiledGroups(service, geoResources, tiledGroups, "");
        }
        catch (Exception exc) {
            WMTPlugin.log("[NASASourceManager.buildGeoResources] Failed: ", exc);
            throw exc;
        }
    }

    private void buildGeoResourcesFromTiledGroups(WMTService service, List<IGeoResource> geoResources, List<?> tiledGroups, String groupNames) {
        for (Object obj : tiledGroups) {
            if (!(obj instanceof Element)) continue;
            Element tiledGroup = (Element)obj;
            String newGroupName = tiledGroup.getChildText("Name");
            String newGroupNames = this.getConcatenatedGroupName(groupNames, newGroupName);
            List newTiledGroups = tiledGroup.getChildren("TiledGroup");
            if (newTiledGroups.isEmpty()) {
                WMTGeoResource geoResource = new WMTGeoResource(service, newGroupNames);
                geoResources.add(geoResource);
                continue;
            }
            this.buildGeoResourcesFromTiledGroups(service, geoResources, newTiledGroups, newGroupNames);
        }
    }

    public Element getTiledGroup(String tileGroupName) {
        List tiledGroups = this.tiledPatterns.getChildren("TiledGroup");
        return this.searchTileGroup(tileGroupName, "", tiledGroups);
    }

    private Element searchTileGroup(String groupToSearchFor, String groupNames, List<?> tiledGroups) {
        for (Object obj : tiledGroups) {
            Element tiledGroup;
            String newGroupName;
            String newGroupNames;
            if (!(obj instanceof Element) || !groupToSearchFor.startsWith(newGroupNames = this.getConcatenatedGroupName(groupNames, newGroupName = (tiledGroup = (Element)obj).getChildText("Name")))) continue;
            List newTiledGroups = tiledGroup.getChildren("TiledGroup");
            if (newTiledGroups.isEmpty()) {
                if (!groupToSearchFor.equals(newGroupNames)) continue;
                return tiledGroup;
            }
            Element foundTileGroup = this.searchTileGroup(groupToSearchFor, newGroupNames, newTiledGroups);
            if (foundTileGroup == null) continue;
            return foundTileGroup;
        }
        return null;
    }

    private String getConcatenatedGroupName(String groupNames, String newGroupName) {
        newGroupName = newGroupName.replace('-', ' ').replace('#', ' ');
        if (groupNames.isEmpty()) {
            return newGroupName;
        }
        return String.valueOf(groupNames) + "-" + newGroupName;
    }
}

