/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource;

import eu.udig.mapquest.apiwrapper.MQAPIWrapper;
import net.refractions.udig.catalog.internal.wmt.tile.MQTile;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MQSource
extends WMTSource {
    public static String NAME = "MapQuest Maps";
    private static WMTTile.WMTTileFactory tileFactory = new MQTile.MQTileFactory();
    private static MQAPIWrapper apiWrapper = null;
    public static final CoordinateReferenceSystem CRS_MQ_PROJECTION = DefaultGeographicCRS.WGS84;
    public static final double PIXELSPERLATDEGREE = 3.15552459661917E8;
    public static final double PIXELSPERLNGDEGREE = 2.5034459790989706E8;
    public static final int TILESIZE_WIDTH = 512;
    public static final int TILESIZE_HEIGHT = 320;
    public static double[] scaleList = new double[]{8.8011773E7, 2.9337258E7, 9779086.0, 3520471.0, 1504475.0, 701289.0, 324767.0, 154950.0, 74999.0, 36000.0, 18000.0, 9000.0, 4700.0, 2500.0, 1500.0, 1000.0};

    protected MQSource() {
        this.setName(NAME);
    }

    @Override
    public CoordinateReferenceSystem getProjectedTileCrs() {
        return CRS_MQ_PROJECTION;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return new ReferencedEnvelope(-180.0, 180.0, -90.0, 88.5, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    @Override
    public String getFileFormat() {
        return "gif";
    }

    @Override
    public int getTileHeight() {
        return 320;
    }

    @Override
    public int getTileWidth() {
        return 512;
    }

    @Override
    public double[] getScaleList() {
        return scaleList;
    }

    @Override
    public WMTTile.WMTTileFactory getTileFactory() {
        return tileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQAPIWrapper getApiWrapper() {
        if (apiWrapper == null) {
            MQSource mQSource = this;
            synchronized (mQSource) {
                if (apiWrapper == null) {
                    apiWrapper = new MQAPIWrapper();
                }
            }
        }
        return apiWrapper;
    }
}

