/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.wmtsource;

import java.io.File;
import java.util.Arrays;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.wmtsource.OSMSource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.ww.LayerSet;

public class CSSource
extends OSMSource {
    public static String NAME = "Custom Server";
    private String templateUrl;
    private double[] scales;
    private String id;
    public static final String TAG_ZOOM = "{z}";
    public static final String TAG_X = "{x}";
    public static final String TAG_Y = "{y}";
    private boolean isTms = false;
    public static double[] SCALE_LIST = new double[]{5.91658711E8, 2.95829355E8, 1.47914381E8, 7.395719E7, 3.6978595E7, 1.8489297E7, 9244648.0, 4622324.0, 2311162.0, 1155581.0, 577790.0, 288895.0, 144447.0, 72223.0, 36111.0, 18055.0, 9027.0, 4513.0, 2256.0, 1128.0, 564.0, 282.0, 141.0};

    protected CSSource() {
        this.setName(NAME);
    }

    @Override
    protected void init(String resourceId) throws Exception {
        int zoomMax;
        int zoomMin;
        String zoomMinValue;
        String zoomMaxValue;
        int nextToLastPos;
        int lastPos = resourceId.lastIndexOf(47);
        String lastStr = resourceId.substring(lastPos + 1).trim();
        int splitPoint = 0;
        if (lastStr.toLowerCase().equals("tms")) {
            this.isTms = true;
            nextToLastPos = resourceId.substring(0, lastPos).lastIndexOf(47);
            zoomMaxValue = resourceId.substring(nextToLastPos + 1, lastPos);
            int nextToLastPos2 = resourceId.substring(0, nextToLastPos).lastIndexOf(47);
            zoomMinValue = resourceId.substring(nextToLastPos2 + 1, nextToLastPos);
            splitPoint = nextToLastPos2;
        } else {
            zoomMaxValue = lastStr;
            nextToLastPos = resourceId.substring(0, lastPos).lastIndexOf(47);
            zoomMinValue = resourceId.substring(nextToLastPos + 1, lastPos);
            splitPoint = nextToLastPos;
        }
        String tmpUrlPath = resourceId.substring(0, splitPoint);
        String tmpUrlNoZXY = tmpUrlPath.split("\\{")[0];
        if (!new File(tmpUrlNoZXY).exists()) {
            this.templateUrl = "http://" + tmpUrlPath;
        } else {
            this.templateUrl = tmpUrlPath;
            String name2 = new File(tmpUrlNoZXY).getName();
            this.setName(name2);
        }
        this.id = this.generateId();
        try {
            zoomMin = Integer.parseInt(zoomMinValue);
            zoomMax = Integer.parseInt(zoomMaxValue);
        }
        catch (Exception exc) {
            WMTPlugin.log("[CSSource.init] Couldn't parse the resourceId: " + resourceId, exc);
            zoomMin = 0;
            zoomMax = 20;
        }
        if (this.validZoomValues(zoomMin, zoomMax)) {
            this.scales = Arrays.copyOfRange(SCALE_LIST, 0, zoomMax + 1);
            int i = 0;
            while (i < zoomMin) {
                this.scales[i] = Double.NaN;
                ++i;
            }
        } else {
            this.scales = SCALE_LIST;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    private String generateId() {
        return LayerSet.constructId("", this.templateUrl);
    }

    private boolean validZoomValues(int zoomMin, int zoomMax) {
        return zoomMin < zoomMax && zoomMin >= 0 && zoomMax < SCALE_LIST.length;
    }

    @Override
    public double[] getScaleList() {
        return this.scales;
    }

    @Override
    public String getTileUrl(int zoomLevel, int x, int y) {
        String url;
        if (this.isTms) {
            int[] tmsTiles = CSSource.googleTile2TmsTile(x, y, zoomLevel);
            x = tmsTiles[0];
            y = tmsTiles[1];
            url = this.templateUrl.replace(TAG_ZOOM, Integer.toString(zoomLevel));
            url = url.replace(TAG_X, Integer.toString(x));
            url = url.replace(TAG_Y, Integer.toString(y));
        } else {
            url = this.templateUrl.replace(TAG_ZOOM, Integer.toString(zoomLevel));
            url = url.replace(TAG_X, Integer.toString(x));
            url = url.replace(TAG_Y, Integer.toString(y));
        }
        return url;
    }

    @Override
    public String getBaseUrl() {
        return null;
    }

    public static int[] googleTile2TmsTile(int tx, int ty, int zoom) {
        return new int[]{tx, (int)(Math.pow(2.0, zoom) - 1.0 - (double)ty)};
    }
}

