/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.ui.properties;

import java.io.IOException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.WMTRenderJob;
import net.refractions.udig.catalog.internal.wmt.WMTScaleZoomLevelMatcher;
import net.refractions.udig.catalog.internal.wmt.ui.properties.WMTLayerProperties;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.wmt.internal.Messages;
import net.refractions.udig.project.internal.Layer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class WMTLayerPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private WMTLayerProperties layerProperties;
    private Layer layer;
    private WMTSource wmtSource;
    private Button btnAutomatic;
    private Button btnManual;
    private Label lblUseZoomLevel;
    private Spinner spZoomLevelValue;
    private Label lblRecommended;
    private Label lblRecommendedValue;
    private Label lblWarning;
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            boolean enableState = WMTLayerPropertyPage.this.btnManual.getSelection();
            WMTLayerPropertyPage.this.lblUseZoomLevel.setEnabled(enableState);
            WMTLayerPropertyPage.this.spZoomLevelValue.setEnabled(enableState);
            WMTLayerPropertyPage.this.lblRecommended.setEnabled(enableState);
            WMTLayerPropertyPage.this.lblRecommendedValue.setEnabled(enableState);
            WMTLayerPropertyPage.this.lblWarning.setEnabled(enableState);
        }
    };

    protected Control createContents(Composite parent) {
        this.layer = (Layer)this.getElement();
        IGeoResource resource = this.layer.findGeoResource(WMTSource.class);
        if (resource == null) {
            return this.createErrorMessage(parent);
        }
        try {
            this.wmtSource = (WMTSource)resource.resolve(WMTSource.class, null);
        }
        catch (IOException iOException) {
            this.wmtSource = null;
            return this.createErrorMessage(parent);
        }
        this.layerProperties = new WMTLayerProperties(this.layer.getStyleBlackboard());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(512));
        Group groupBox = new Group(composite, 2048);
        groupBox.setLayout((Layout)new RowLayout(512));
        groupBox.setText(Messages.Properties_Layer_GroupBox);
        this.btnAutomatic = new Button((Composite)groupBox, 16);
        this.btnAutomatic.addSelectionListener(this.selectionListener);
        this.btnAutomatic.setSelection(true);
        this.btnAutomatic.setText(Messages.Properties_Layer_AutomaticSelection);
        this.btnManual = new Button((Composite)groupBox, 16);
        this.btnManual.setText(Messages.Properties_Layer_ManualSelection);
        Composite compositeManual = new Composite((Composite)groupBox, 0);
        compositeManual.setLayout((Layout)new RowLayout(512));
        Composite compositeZoomLevelSelection = new Composite(compositeManual, 0);
        compositeZoomLevelSelection.setLayout((Layout)new RowLayout(256));
        this.lblUseZoomLevel = new Label(compositeZoomLevelSelection, 256);
        this.lblUseZoomLevel.setText(Messages.Properties_Layer_UseZoomLevel);
        this.spZoomLevelValue = new Spinner(compositeZoomLevelSelection, 2056);
        this.spZoomLevelValue.setMinimum(this.wmtSource.getMinZoomLevel());
        this.spZoomLevelValue.setMaximum(this.wmtSource.getMaxZoomLevel());
        this.spZoomLevelValue.setIncrement(1);
        this.spZoomLevelValue.pack();
        this.lblRecommended = new Label(compositeZoomLevelSelection, 256);
        this.lblRecommended.setText(Messages.Properties_Layer_Recommended);
        this.lblRecommendedValue = new Label(compositeZoomLevelSelection, 256);
        this.lblWarning = new Label(compositeManual, 256);
        this.lblWarning.setText(Messages.Properties_Layer_Warning);
        this.loadSettings();
        groupBox.pack();
        return composite;
    }

    private void loadSettings() {
        if (!this.layerProperties.load()) {
            this.updateGuiDefaultValues();
        } else {
            this.updateGui(this.layerProperties.getSelectionAutomatic(), this.layerProperties.getZoomLevel(), this.getDefaultZoomLevel());
        }
    }

    private void updateGuiDefaultValues() {
        int zoomLevel = this.getDefaultZoomLevel();
        this.updateGui(true, zoomLevel, zoomLevel);
    }

    private void updateGui(boolean selectionAutomatic, int zoomLevel, int recommendedZoomLevel) {
        this.btnAutomatic.setSelection(selectionAutomatic);
        this.btnManual.setSelection(!selectionAutomatic);
        this.selectionListener.widgetSelected(null);
        this.lblRecommendedValue.setText(Integer.toString(recommendedZoomLevel));
        if (selectionAutomatic) {
            zoomLevel = recommendedZoomLevel;
        }
        this.spZoomLevelValue.setSelection(zoomLevel);
    }

    private void saveSettings() {
        boolean selectionAutomatic = this.btnAutomatic.getSelection();
        int zoomLevel = this.spZoomLevelValue.getSelection();
        this.layerProperties.save(selectionAutomatic, zoomLevel);
    }

    protected void performApply() {
        this.saveSettings();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        this.updateGuiDefaultValues();
    }

    private Control createErrorMessage(Composite parent) {
        Label lblError = new Label(parent, 256);
        lblError.setText(Messages.Properties_Layer_Error);
        return parent;
    }

    private int getDefaultZoomLevel() {
        try {
            int scaleFactor = WMTRenderJob.getScaleFactor();
            double mapScale = this.layer.getMap().getViewportModel().getScaleDenominator();
            ReferencedEnvelope mapExtentMapCrs = this.layer.getMap().getViewportModel().getBounds();
            WMTScaleZoomLevelMatcher zoomLevelMatcher = WMTScaleZoomLevelMatcher.createMatcher(mapExtentMapCrs, mapScale, this.wmtSource);
            return this.wmtSource.getZoomLevelFromMapScale(zoomLevelMatcher, scaleFactor);
        }
        catch (Exception exc) {
            WMTPlugin.log("[WMTLayerPropertyPage.getDefaultZoomLevel] Failed ", exc);
            return -1;
        }
    }
}

