/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.tile;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTileName;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.geometry.jts.ReferencedEnvelope;

public abstract class WMTTile
implements Tile {
    private static final boolean testing = false;
    public static final int INERROR = 1;
    public static final int OK = 0;
    private WMTTileName tileName;
    private ReferencedEnvelope extent;
    private BufferedImage image;
    private Object imageLock = new Object();
    private int state;
    private String maxCacheAge;

    public WMTTile(ReferencedEnvelope extent, WMTTileName tileName) {
        this.extent = extent;
        this.tileName = tileName;
    }

    public URL getUrl() {
        return this.tileName.getTileUrl();
    }

    public ReferencedEnvelope getExtent() {
        return this.extent;
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public String getId() {
        return this.tileName.getId();
    }

    public String getReleatedSourceId() {
        return this.tileName.getSource().getId();
    }

    public abstract WMTTile getRightNeighbour();

    public abstract WMTTile getLowerNeighbour();

    public Envelope getBounds() {
        return this.extent;
    }

    public String getPosition() {
        return this.getId();
    }

    public double getScale() {
        return this.tileName.getZoomLevel();
    }

    public Object getTileLock() {
        return this.imageLock;
    }

    public TileSet getTileSet() {
        return null;
    }

    public int getTileState() {
        return this.state;
    }

    public void setTileState(int state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadTile(IProgressMonitor monitor) {
        if (this.tileName == null) {
            WMTPlugin.log("error, no tilename", null);
            return false;
        }
        Object lock = this.getTileLock();
        BufferedImage bufImage = null;
        Object object = lock;
        synchronized (object) {
            block14: {
                if ((this.getBufferedImage() == null || this.getTileState() == 1) && !monitor.isCanceled()) break block14;
                monitor.setCanceled(true);
                return true;
            }
            try {
                URL url = this.getUrl();
                WMTPlugin.log("WMT GetTile: " + url, null);
                URLConnection openConnection = url.openConnection();
                if (openConnection != null) {
                    HttpURLConnection connection = null;
                    connection = (HttpURLConnection)openConnection;
                    this.setConnectionParams(connection);
                    bufImage = ImageIO.read(connection.getInputStream());
                } else {
                    File file = new File(url.toExternalForm());
                    if (file.exists()) {
                        bufImage = ImageIO.read(file);
                    }
                }
                if (bufImage != null) {
                    this.setBufferedImageInternal(bufImage);
                    this.setTileState(0);
                } else {
                    this.setBufferedImageInternal(this.createErrorImage());
                    this.setTileState(1);
                }
            }
            catch (Exception e1) {
                this.setBufferedImageInternal(this.createErrorImage());
                this.setTileState(1);
                WMTPlugin.log("error loading tile, placeholder created:", e1);
            }
            catch (Throwable t) {
                this.setBufferedImageInternal(this.createErrorImage());
                this.setTileState(1);
                WMTPlugin.log("error loading tile, placeholder created:", t);
            }
        }
        if (this.getBufferedImage() != null) {
            return true;
        }
        System.out.println("// if we get here, something prevented us from setting an image");
        return false;
    }

    protected void setConnectionParams(HttpURLConnection connection) {
    }

    private BufferedImage createErrorImage() {
        BufferedImage bf = new BufferedImage(this.tileName.getSource().getTileWidth(), this.tileName.getSource().getTileHeight(), 2);
        Graphics2D g = bf.createGraphics();
        g.setColor(Color.RED);
        g.drawLine(0, 0, this.tileName.getSource().getTileWidth(), this.tileName.getSource().getTileHeight());
        g.drawLine(0, this.tileName.getSource().getTileHeight(), this.tileName.getSource().getTileWidth(), 0);
        return bf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferedImage(BufferedImage im) {
        Object lock;
        Object object = lock = this.getTileLock();
        synchronized (object) {
            this.setBufferedImageInternal(im);
            if (this.getBufferedImage() != null) {
                this.setTileState(0);
            } else {
                this.setTileState(1);
            }
        }
    }

    private void setBufferedImageInternal(BufferedImage im) {
        this.image = im;
    }

    public void setPosition(String pos) {
        throw new UnsupportedOperationException();
    }

    public void setMaxCacheAge(String maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
    }

    public String getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public int compareTo(Tile other) {
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Tile) {
            Tile tile = (Tile)arg0;
            return this.getId().equals(tile.getId());
        }
        return super.equals(arg0);
    }

    public static abstract class WMTTileFactory {
        public abstract WMTTile getTileFromCoordinate(double var1, double var3, WMTZoomLevel var5, WMTSource var6);

        public abstract WMTZoomLevel getZoomLevel(int var1, WMTSource var2);

        public static double normalizeDegreeValue(double value, int maxValue) {
            int range = 2 * maxValue;
            if (value > 0.0) {
                if ((value = (value + (double)maxValue - 1.0) % (double)range) < 0.0) {
                    value += (double)range;
                }
                return value - (double)maxValue + 1.0;
            }
            if ((value = (value + (double)maxValue) % (double)range) < 0.0) {
                value += (double)range;
            }
            return value - (double)maxValue;
        }

        public static double moveInRange(double value, double min, double max) {
            if (value < min) {
                value = min;
            } else if (value > max) {
                value = max;
            }
            return value;
        }
    }

    public static abstract class WMTZoomLevel {
        private int zoomLevel;
        private int maxTilePerRowNumber;
        private int maxTilePerColNumber;
        private long maxTileNumber;

        public WMTZoomLevel(int zoomLevel) {
            this.setZoomLevel(zoomLevel);
        }

        public void setZoomLevel(int zoomLevel) {
            this.zoomLevel = zoomLevel;
            this.maxTilePerRowNumber = this.calculateMaxTilePerRowNumber(zoomLevel);
            this.maxTilePerColNumber = this.calculateMaxTilePerColNumber(zoomLevel);
            this.maxTileNumber = this.calculateMaxTileNumber();
        }

        public abstract int calculateMaxTilePerRowNumber(int var1);

        public abstract int calculateMaxTilePerColNumber(int var1);

        public long calculateMaxTileNumber() {
            return (long)this.maxTilePerColNumber * (long)this.maxTilePerRowNumber;
        }

        public int getZoomLevel() {
            return this.zoomLevel;
        }

        public int getMaxTilePerRowNumber() {
            return this.maxTilePerRowNumber;
        }

        public int getMaxTilePerColNumber() {
            return this.maxTilePerColNumber;
        }

        public long getMaxTileNumber() {
            return this.maxTileNumber;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WMTZoomLevel)) {
                return false;
            }
            WMTZoomLevel other = (WMTZoomLevel)obj;
            return this.zoomLevel == other.zoomLevel;
        }
    }
}

