/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wmt.tile;

import java.awt.Dimension;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.refractions.udig.catalog.internal.wmt.WMTPlugin;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTileName;
import net.refractions.udig.catalog.internal.wmt.wmtsource.NASASource;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class NASATile
extends WMTTile {
    private NASATileName tileName;
    private NASASource nasaSource;

    public NASATile(int x, int y, NASATileName.NASAZoomLevel zoomLevel, NASASource nasaSource) {
        this(new NASATileName(x, y, zoomLevel, nasaSource), nasaSource);
    }

    public NASATile(NASATileName tileName, NASASource nasaSource) {
        super(NASATile.getExtentFromTileName(tileName), tileName);
        this.tileName = tileName;
        this.nasaSource = nasaSource;
    }

    public static ReferencedEnvelope getExtentFromTileName(NASATileName tileName) {
        ReferencedEnvelope extent = new ReferencedEnvelope(NASATile.tile2lon(tileName.getX(), tileName), NASATile.tile2lon(tileName.getX() + 1, tileName), NASATile.tile2lat(tileName.getY(), tileName), NASATile.tile2lat(tileName.getY() + 1, tileName), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return extent;
    }

    public static double tile2lat(int row, NASATileName tileName) {
        return tileName.getNasaSource().getBounds().getMaxY() - (double)row * tileName.getHeightInWorldUnits();
    }

    public static double tile2lon(int col, NASATileName tileName) {
        return tileName.getNasaSource().getBounds().getMinX() + (double)col * tileName.getWidthInWorldUnits();
    }

    @Override
    public NASATile getLowerNeighbour() {
        return new NASATile(this.tileName.getLowerNeighbour(), this.nasaSource);
    }

    @Override
    public NASATile getRightNeighbour() {
        return new NASATile(this.tileName.getRightNeighbour(), this.nasaSource);
    }

    public static class NASATileFactory
    extends WMTTile.WMTTileFactory {
        @Override
        public NASATile getTileFromCoordinate(double lat, double lon, WMTTile.WMTZoomLevel zoomLevel, WMTSource wmtSource) {
            NASASource nasaSource = (NASASource)wmtSource;
            lat = WMTTile.WMTTileFactory.normalizeDegreeValue(lat, 90);
            lon = WMTTile.WMTTileFactory.normalizeDegreeValue(lon, 180);
            lat = WMTTile.WMTTileFactory.moveInRange(lat, nasaSource.getBounds().getMinY(), nasaSource.getBounds().getMaxY());
            lon = WMTTile.WMTTileFactory.moveInRange(lon, nasaSource.getBounds().getMinX(), nasaSource.getBounds().getMaxX());
            NASATileName.NASAZoomLevel nasaZoomLevel = (NASATileName.NASAZoomLevel)zoomLevel;
            int row = (int)Math.abs((lat - nasaSource.getBounds().getMaxY()) / nasaZoomLevel.getHeightInWorldUnits());
            int col = (int)Math.abs((lon - nasaSource.getBounds().getMinX()) / nasaZoomLevel.getWidthInWorldUnits());
            WMTPlugin.debug("[NASATile.getTileFromCoordinate] " + zoomLevel.getZoomLevel() + "/" + col + "/" + row + " lon: " + lon + " lat: " + lat, "net.refractions.udig.catalog.wmt/debug/nasa");
            return new NASATile(col, row, nasaZoomLevel, (NASASource)wmtSource);
        }

        @Override
        public WMTTile.WMTZoomLevel getZoomLevel(int zoomLevel, WMTSource wmtSource) {
            NASASource nasaSource = (NASASource)wmtSource;
            return nasaSource.getZoomLevel(zoomLevel);
        }
    }

    public static class NASATileName
    extends WMTTileName {
        private NASAZoomLevel zoomLevel;
        private NASASource nasaSource;

        public NASATileName(int x, int y, NASAZoomLevel zoomLevel, NASASource source) {
            super(zoomLevel, x, y, source);
            this.zoomLevel = zoomLevel;
            this.nasaSource = source;
        }

        @Override
        public URL getTileUrl() {
            try {
                String tileUrl = this.zoomLevel.getTileUrl(NASATile.getExtentFromTileName(this));
                return new URL(null, tileUrl, CorePlugin.RELAXED_HANDLER);
            }
            catch (Exception e) {
                WMTPlugin.log("[NASATile] Could not create the url for tile (Zoom: " + this.zoomLevel.getZoomLevel() + ", X: " + this.getX() + ", " + this.getY(), e);
                return null;
            }
        }

        public NASATileName getRightNeighbour() {
            return new NASATileName(WMTTileName.arithmeticMod(this.getX() + 1, this.zoomLevel.getMaxTilePerRowNumber()), this.getY(), this.zoomLevel, this.nasaSource);
        }

        public NASATileName getLowerNeighbour() {
            return new NASATileName(this.getX(), WMTTileName.arithmeticMod(this.getY() + 1, this.zoomLevel.getMaxTilePerColNumber()), this.zoomLevel, this.nasaSource);
        }

        public double getWidthInWorldUnits() {
            return this.zoomLevel.getWidthInWorldUnits();
        }

        public double getHeightInWorldUnits() {
            return this.zoomLevel.getHeightInWorldUnits();
        }

        public NASASource getNasaSource() {
            return this.nasaSource;
        }

        public String toString() {
            return String.valueOf(this.zoomLevel.getZoomLevel()) + "/" + this.getX() + "/" + this.getY();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NASATileName)) {
                return false;
            }
            NASATileName other = (NASATileName)obj;
            return this.getX() == other.getX() && this.getY() == other.getY() && this.zoomLevel.equals(other.zoomLevel);
        }

        public static class NASAZoomLevel
        extends WMTTile.WMTZoomLevel
        implements Comparable<NASAZoomLevel> {
            private ReferencedEnvelope boundsOfFirstTile;
            private String requestUrlPrefix;
            private String requestUrlSuffix;
            private DecimalFormat boundsFormatter;
            private double scale;
            private NASASource nasaSource;
            private static final char BOUNDS_SEPERATOR = ',';
            private static final String doublePatternString = "([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])";
            private static final String bboxPatternString = "(bbox)(=)([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])(,)([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])(,)([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])(,)([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])";
            private static final Pattern bboxPattern = Pattern.compile("(bbox)(=)([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])(,)([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])(,)([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])(,)([+-]?\\d*\\.?\\d*)(?![-+0-9\\.])", 34);

            public NASAZoomLevel(String tilePattern, NASASource nasaSource) {
                super(0);
                this.nasaSource = nasaSource;
                String rawRequest = this.getRawRequestStringFromTilePattern(tilePattern);
                this.parseBboxFromRequest(rawRequest);
                this.findOutScale();
            }

            public String getTileUrl(ReferencedEnvelope bounds) {
                StringBuffer bbox = new StringBuffer();
                bbox.append(this.nasaSource.getBaseUrl());
                bbox.append(this.requestUrlPrefix);
                bbox.append("bbox=");
                bbox.append(this.getFormattedCoordinate(bounds.getMinX()));
                bbox.append(',');
                bbox.append(this.getFormattedCoordinate(bounds.getMinY()));
                bbox.append(',');
                bbox.append(this.getFormattedCoordinate(bounds.getMaxX()));
                bbox.append(',');
                bbox.append(this.getFormattedCoordinate(bounds.getMaxY()));
                bbox.append(this.requestUrlSuffix);
                return bbox.toString();
            }

            private String getFormattedCoordinate(double value) {
                return this.boundsFormatter.format(value).replace(',', '.');
            }

            private String getRawRequestStringFromTilePattern(String tilePattern) {
                if ((tilePattern = tilePattern.replace('\n', ' ').trim()).contains(" ")) {
                    return tilePattern.substring(0, tilePattern.indexOf(32));
                }
                return tilePattern;
            }

            private void parseBboxFromRequest(String rawRequest) {
                Matcher m = bboxPattern.matcher(rawRequest);
                if (m.find()) {
                    String xMinText = m.group(3);
                    String yMinText = m.group(5);
                    String xMaxText = m.group(7);
                    String yMaxText = m.group(9);
                    this.setBoundsFormatter(xMinText, yMinText, xMaxText, yMaxText);
                    this.requestUrlPrefix = this.getRequestPart(rawRequest, 0, m.start());
                    this.requestUrlSuffix = this.getRequestPart(rawRequest, m.end(), rawRequest.length());
                    try {
                        double xMin = Double.parseDouble(xMinText);
                        double yMin = Double.parseDouble(yMinText);
                        double xMax = Double.parseDouble(xMaxText);
                        double yMax = Double.parseDouble(yMaxText);
                        this.boundsOfFirstTile = new ReferencedEnvelope(xMin, xMax, yMin, yMax, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                        return;
                    }
                    catch (NumberFormatException exc) {
                        WMTPlugin.log("[NASATile] Getting the bbox failed", exc);
                    }
                }
                this.boundsOfFirstTile = null;
            }

            private String getRequestPart(String rawRequest, int start, int end) {
                if (start < 0 || end < 0 || start > end) {
                    return "";
                }
                return rawRequest.substring(start, end);
            }

            private void setBoundsFormatter(String xMinText, String yMinText, String xMaxText, String yMaxText) {
                int maxCountOfDecimalPlaces = this.getMax(this.getDecimalPlacesCount(xMinText), this.getDecimalPlacesCount(yMinText), this.getDecimalPlacesCount(xMaxText), this.getDecimalPlacesCount(yMaxText));
                String format = "##0";
                if (maxCountOfDecimalPlaces > 0) {
                    format = String.valueOf(format) + ".";
                    int i = 0;
                    while (i < maxCountOfDecimalPlaces) {
                        format = String.valueOf(format) + "#";
                        ++i;
                    }
                }
                this.boundsFormatter = new DecimalFormat(format);
            }

            private int getDecimalPlacesCount(String number) {
                if (number.contains(".")) {
                    int posOfDot = number.indexOf(".");
                    return number.length() - 1 - posOfDot;
                }
                return 0;
            }

            private int getMax(int a, int b, int c, int d) {
                return Math.max(a, Math.max(b, Math.max(c, d)));
            }

            private void findOutScale() {
                if (this.boundsOfFirstTile == null) {
                    this.scale = Double.NaN;
                } else {
                    double halfWidth = this.boundsOfFirstTile.getWidth() / 2.0;
                    double halfHeight = this.boundsOfFirstTile.getHeight() / 2.0;
                    ReferencedEnvelope boundsAtEquator = new ReferencedEnvelope(-halfWidth, halfWidth, -halfHeight, halfHeight, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    int dpi = 96;
                    try {
                        dpi = Display.getDefault().getDPI().x;
                    }
                    catch (Exception exception) {}
                    this.scale = ScaleUtils.calculateScaleDenominator((ReferencedEnvelope)boundsAtEquator, (Dimension)new Dimension(this.nasaSource.getTileWidth(), this.nasaSource.getTileHeight()), (int)dpi);
                }
            }

            @Override
            public int calculateMaxTilePerColNumber(int zoomLevel) {
                if (this.boundsOfFirstTile == null) {
                    return 0;
                }
                return (int)Math.ceil(this.nasaSource.getBounds().getHeight() / this.boundsOfFirstTile.getHeight());
            }

            @Override
            public int calculateMaxTilePerRowNumber(int zoomLevel) {
                if (this.boundsOfFirstTile == null) {
                    return 0;
                }
                return (int)Math.ceil(this.nasaSource.getBounds().getWidth() / this.boundsOfFirstTile.getWidth());
            }

            public double getScale() {
                return this.scale;
            }

            public double getWidthInWorldUnits() {
                return this.boundsOfFirstTile.getWidth();
            }

            public double getHeightInWorldUnits() {
                return this.boundsOfFirstTile.getHeight();
            }

            @Override
            public int compareTo(NASAZoomLevel other) {
                return Double.compare(this.scale, other.scale);
            }
        }
    }
}

